/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.filtering;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.IncrementalRuleChange;
import org.apache.james.jmap.cassandra.filtering.RuleDTO;

public class FilteringIncrementalRuleChangeDTO
implements EventDTO {
    private final String type;
    private final int eventId;
    private final String aggregateId;
    private final ImmutableList<RuleDTO> prepended;
    private final ImmutableList<RuleDTO> postpended;
    private final ImmutableSet<String> deleted;
    private final ImmutableList<RuleDTO> updated;

    public static FilteringIncrementalRuleChangeDTO from(IncrementalRuleChange event, String type) {
        return new FilteringIncrementalRuleChangeDTO(type, event.eventId().serialize(), event.getAggregateId().asAggregateKey(), RuleDTO.from((List<Rule>)event.getRulesPrepended()), RuleDTO.from((List<Rule>)event.getRulesPostPended()), RuleDTO.from((List<Rule>)event.getRulesUpdated()), (ImmutableSet<String>)((ImmutableSet)event.getRulesDeleted().stream().map(id -> id.asString()).collect(ImmutableSet.toImmutableSet())));
    }

    public static FilteringIncrementalRuleChangeDTO from(IncrementalRuleChange event) {
        return FilteringIncrementalRuleChangeDTO.from(event, "filtering-increment");
    }

    @JsonCreator
    public FilteringIncrementalRuleChangeDTO(@JsonProperty(value="type") String type, @JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateId") String aggregateId, @JsonProperty(value="prepended") ImmutableList<RuleDTO> prepended, @JsonProperty(value="postpended") ImmutableList<RuleDTO> postpended, @JsonProperty(value="updated") ImmutableList<RuleDTO> updated, @JsonProperty(value="deleted") ImmutableSet<String> deleted) {
        this.type = type;
        this.eventId = eventId;
        this.aggregateId = aggregateId;
        this.prepended = prepended;
        this.postpended = postpended;
        this.updated = updated;
        this.deleted = deleted;
    }

    public String getType() {
        return this.type;
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public ImmutableList<RuleDTO> getPrepended() {
        return this.prepended;
    }

    public ImmutableList<RuleDTO> getPostpended() {
        return this.postpended;
    }

    public ImmutableSet<String> getDeleted() {
        return this.deleted;
    }

    public ImmutableList<RuleDTO> getUpdated() {
        return this.updated;
    }

    @JsonIgnore
    public IncrementalRuleChange toEvent() {
        return new IncrementalRuleChange(FilteringAggregateId.parse((String)this.aggregateId), EventId.fromSerialized((int)this.eventId), RuleDTO.toRules(this.prepended), RuleDTO.toRules(this.postpended), (ImmutableSet)this.deleted.stream().map(Rule.Id::of).collect(ImmutableSet.toImmutableSet()), RuleDTO.toRules(this.updated));
    }

    public final boolean equals(Object o) {
        if (o instanceof FilteringIncrementalRuleChangeDTO) {
            FilteringIncrementalRuleChangeDTO that = (FilteringIncrementalRuleChangeDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.type, that.type) && Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.prepended, that.prepended) && Objects.equals(this.postpended, that.postpended) && Objects.equals(this.updated, that.updated) && Objects.equals(this.deleted, that.deleted);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.eventId, this.aggregateId, this.prepended, this.postpended, this.deleted, this.updated);
    }
}

