/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PKCS11KeyManager
extends WrapperKeyManager {
    @NotNull
    public static final String DEFAULT_KEY_STORE_TYPE = "PKCS11";
    @NotNull
    public static final String DEFAULT_PROVIDER_CLASS = "sun.security.pkcs11.SunPKCS11";
    @NotNull
    private static final String SERVICE_TYPE_KEY_STORE = "KeyStore";
    @NotNull
    private static final String SUN_JSSE_PROVIDER_NAME = "SunJSSE";
    @Nullable
    private static final Provider PKCS11_JSSE_PROVIDER;

    public PKCS11KeyManager(@Nullable char[] keyStorePIN, @Nullable String certificateAlias) throws KeyStoreException {
        this(PKCS11KeyManager.getProvider(null, null, null, false), null, keyStorePIN, certificateAlias);
    }

    public PKCS11KeyManager(@Nullable String providerClassName, @Nullable File providerConfigFile, @Nullable String keyStoreType, @Nullable char[] keyStorePIN, @Nullable String certificateAlias) throws KeyStoreException {
        this(PKCS11KeyManager.getProvider(providerClassName, providerConfigFile, keyStoreType, false), keyStoreType, keyStorePIN, certificateAlias);
    }

    public PKCS11KeyManager(@NotNull Provider provider, @Nullable String keyStoreType, @Nullable char[] keyStorePIN, @Nullable String certificateAlias) throws KeyStoreException {
        super(PKCS11KeyManager.getKeyManagers(provider, keyStoreType, keyStorePIN), certificateAlias);
    }

    @NotNull
    public static Provider getProvider(@Nullable String providerClassName, @Nullable File providerConfigFile, @Nullable String keyStoreType, boolean alwaysCreateNewInstance) throws KeyStoreException {
        Provider configuredProvider;
        Constructor<?> stringConstructor;
        Class<?> providerClass;
        String ksType = keyStoreType == null ? DEFAULT_KEY_STORE_TYPE : keyStoreType;
        Provider[] providers = Security.getProviders();
        if (providerClassName == null) {
            providerClass = PKCS11KeyManager.inferProviderClass(providers, ksType);
        } else {
            try {
                providerClass = Class.forName(providerClassName);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PCKS11_NO_SUCH_PROVIDER_CLASS.get(providerClassName, StaticUtils.getExceptionMessage(e)), e);
            }
        }
        Provider provider = null;
        for (Provider p : providers) {
            if (!p.getClass().getName().equals(providerClass.getName())) continue;
            provider = p;
            if (p.getService(SERVICE_TYPE_KEY_STORE, ksType) == null || providerConfigFile != null && alwaysCreateNewInstance) break;
            return p;
        }
        Constructor<?> defaultConstructor = null;
        try {
            defaultConstructor = providerClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (providerConfigFile == null) {
            if (defaultConstructor == null) {
                throw new KeyStoreException(SSLMessages.ERR_PKCS11_NO_DEFAULT_CONSTRUCTOR_NO_CONFIG.get(providerClass.getName(), ksType));
            }
            try {
                provider = (Provider)defaultConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_INVOKE_DEFAULT_CONSTRUCTOR.get(providerClass.getName(), ksType, StaticUtils.getExceptionMessage(e)), e);
            }
            if (provider.getService(SERVICE_TYPE_KEY_STORE, ksType) == null) {
                throw new KeyStoreException(SSLMessages.ERR_PKCS11_DEFAULT_CONSTRUCTOR_NO_KS_TYPE.get(providerClass.getName(), ksType));
            }
            Security.addProvider(provider);
            return provider;
        }
        if (defaultConstructor != null) {
            Method configureMethod = null;
            try {
                configureMethod = providerClass.getMethod("configure", String.class);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            if (configureMethod != null) {
                Provider configuredProvider2;
                if (provider == null) {
                    try {
                        provider = (Provider)defaultConstructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_INVOKE_DEFAULT_CONSTRUCTOR.get(providerClass.getName(), ksType, StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                try {
                    configuredProvider2 = (Provider)configureMethod.invoke((Object)provider, providerConfigFile.getAbsolutePath());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_CONFIGURE_PROVIDER.get(providerClass.getName(), providerConfigFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
                if (configuredProvider2.getService(SERVICE_TYPE_KEY_STORE, ksType) == null) {
                    throw new KeyStoreException(SSLMessages.ERR_PKCS11_CONFIGURED_PROVIDER_NO_KS_TYPE.get(providerClass.getName(), ksType, providerConfigFile.getAbsolutePath()));
                }
                Security.addProvider(configuredProvider2);
                return configuredProvider2;
            }
        }
        try {
            stringConstructor = providerClass.getConstructor(String.class);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_NO_STRING_CONSTRUCTOR.get(providerClass.getName(), providerConfigFile.getAbsolutePath(), ksType), e);
        }
        try {
            configuredProvider = (Provider)stringConstructor.newInstance(providerConfigFile.getAbsolutePath());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_INVOKE_STRING_CONSTRUCTOR.get(providerClass.getName(), providerConfigFile.getAbsolutePath(), ksType, StaticUtils.getExceptionMessage(e)), e);
        }
        if (configuredProvider.getService(SERVICE_TYPE_KEY_STORE, ksType) == null) {
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CONFIGURED_PROVIDER_NO_KS_TYPE.get(providerClass.getName(), ksType, providerConfigFile.getAbsolutePath()));
        }
        Security.addProvider(configuredProvider);
        return configuredProvider;
    }

    @NotNull
    private static Class<?> inferProviderClass(@NotNull Provider[] providers, @NotNull String keyStoreType) throws KeyStoreException {
        for (Provider p : providers) {
            if (p.getService(SERVICE_TYPE_KEY_STORE, keyStoreType) == null) continue;
            return p.getClass();
        }
        for (Provider p : providers) {
            Class<?> providerClass = p.getClass();
            if (!StaticUtils.toUpperCase(p.getName()).contains(DEFAULT_KEY_STORE_TYPE) && !StaticUtils.toUpperCase(providerClass.getName()).contains(DEFAULT_KEY_STORE_TYPE)) continue;
            return providerClass;
        }
        try {
            return Class.forName(DEFAULT_PROVIDER_CLASS);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_INFER_PROVIDER_CLASS.get(DEFAULT_PROVIDER_CLASS), e);
        }
    }

    @NotNull
    private static KeyManager[] getKeyManagers(@NotNull Provider provider, @Nullable String keyStoreType, @Nullable char[] keyStorePIN) throws KeyStoreException {
        String ksType = keyStoreType == null ? DEFAULT_KEY_STORE_TYPE : keyStoreType;
        KeyStore ks = CryptoHelper.getKeyStore(ksType, provider);
        try {
            ks.load(null, keyStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_ACCESS.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            KeyManagerFactory factory = CryptoHelper.getKeyManagerFactory();
            factory.init(ks, keyStorePIN);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_GET_KEY_MANAGERS.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    public static Provider getPKCS11JSSESProvider() {
        return PKCS11_JSSE_PROVIDER;
    }

    static {
        Provider sunJSSEProvider = Security.getProvider(SUN_JSSE_PROVIDER_NAME);
        if (sunJSSEProvider != null) {
            PKCS11_JSSE_PROVIDER = sunJSSEProvider;
        } else {
            Provider tls13Provider = null;
            Provider tls12Provider = null;
            for (Provider provider : Security.getProviders()) {
                if (provider.getService("SSLContext", "TLSv1.3") != null) {
                    tls13Provider = provider;
                    break;
                }
                if (provider.getService("SSLContext", "TLSv1.2") == null) continue;
                tls12Provider = provider;
            }
            PKCS11_JSSE_PROVIDER = tls13Provider != null ? tls13Provider : tls12Provider;
        }
    }
}

