/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch.indices.add_block.IndicesBlockStatus;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class AddBlockResponse
extends AcknowledgedResponseBase {
    private final boolean shardsAcknowledged;
    private final List<IndicesBlockStatus> indices;
    public static final JsonpDeserializer<AddBlockResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddBlockResponse::setupAddBlockResponseDeserializer);

    private AddBlockResponse(Builder builder) {
        super(builder);
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static AddBlockResponse of(Function<Builder, ObjectBuilder<AddBlockResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public final List<IndicesBlockStatus> indices() {
        return this.indices;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesBlockStatus item0 : this.indices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAddBlockResponseDeserializer(ObjectDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesBlockStatus._DESERIALIZER), "indices");
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AddBlockResponse> {
        private Boolean shardsAcknowledged;
        private List<IndicesBlockStatus> indices;

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        public final Builder indices(List<IndicesBlockStatus> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(IndicesBlockStatus value, IndicesBlockStatus ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<IndicesBlockStatus.Builder, ObjectBuilder<IndicesBlockStatus>> fn) {
            return this.indices(fn.apply(new IndicesBlockStatus.Builder()).build(), new IndicesBlockStatus[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AddBlockResponse build() {
            this._checkSingleUse();
            return new AddBlockResponse(this);
        }
    }
}

