/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsAllOf;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsAnyOf;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsFuzzy;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsMatch;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsPrefix;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsWildcard;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class IntervalsQuery
extends QueryBase
implements TaggedUnion<Kind, Object>,
QueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final String field;
    public static final JsonpDeserializer<IntervalsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsQuery::setupIntervalsQueryDeserializer, Builder::build);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Intervals;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private IntervalsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static IntervalsQuery of(Function<Builder, ObjectBuilder<IntervalsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public boolean isAllOf() {
        return this._kind == Kind.AllOf;
    }

    public IntervalsAllOf allOf() {
        return (IntervalsAllOf)TaggedUnionUtils.get(this, Kind.AllOf);
    }

    public boolean isAnyOf() {
        return this._kind == Kind.AnyOf;
    }

    public IntervalsAnyOf anyOf() {
        return (IntervalsAnyOf)TaggedUnionUtils.get(this, Kind.AnyOf);
    }

    public boolean isFuzzy() {
        return this._kind == Kind.Fuzzy;
    }

    public IntervalsFuzzy fuzzy() {
        return (IntervalsFuzzy)TaggedUnionUtils.get(this, Kind.Fuzzy);
    }

    public boolean isMatch() {
        return this._kind == Kind.Match;
    }

    public IntervalsMatch match() {
        return (IntervalsMatch)TaggedUnionUtils.get(this, Kind.Match);
    }

    public boolean isPrefix() {
        return this._kind == Kind.Prefix;
    }

    public IntervalsPrefix prefix() {
        return (IntervalsPrefix)TaggedUnionUtils.get(this, Kind.Prefix);
    }

    public boolean isWildcard() {
        return this._kind == Kind.Wildcard;
    }

    public IntervalsWildcard wildcard() {
        return (IntervalsWildcard)TaggedUnionUtils.get(this, Kind.Wildcard);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeEnd();
    }

    protected static void setupIntervalsQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::allOf, IntervalsAllOf._DESERIALIZER, "all_of");
        op.add(Builder::anyOf, IntervalsAnyOf._DESERIALIZER, "any_of");
        op.add(Builder::fuzzy, IntervalsFuzzy._DESERIALIZER, "fuzzy");
        op.add(Builder::match, IntervalsMatch._DESERIALIZER, "match");
        op.add(Builder::prefix, IntervalsPrefix._DESERIALIZER, "prefix");
        op.add(Builder::wildcard, IntervalsWildcard._DESERIALIZER, "wildcard");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IntervalsQuery> {
        private Kind _kind;
        private Object _value;
        private String field;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<IntervalsQuery> allOf(IntervalsAllOf v) {
            this._kind = Kind.AllOf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> allOf(Function<IntervalsAllOf.Builder, ObjectBuilder<IntervalsAllOf>> fn) {
            return this.allOf(fn.apply(new IntervalsAllOf.Builder()).build());
        }

        public ObjectBuilder<IntervalsQuery> anyOf(IntervalsAnyOf v) {
            this._kind = Kind.AnyOf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> anyOf(Function<IntervalsAnyOf.Builder, ObjectBuilder<IntervalsAnyOf>> fn) {
            return this.anyOf(fn.apply(new IntervalsAnyOf.Builder()).build());
        }

        public ObjectBuilder<IntervalsQuery> fuzzy(IntervalsFuzzy v) {
            this._kind = Kind.Fuzzy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> fuzzy(Function<IntervalsFuzzy.Builder, ObjectBuilder<IntervalsFuzzy>> fn) {
            return this.fuzzy(fn.apply(new IntervalsFuzzy.Builder()).build());
        }

        public ObjectBuilder<IntervalsQuery> match(IntervalsMatch v) {
            this._kind = Kind.Match;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> match(Function<IntervalsMatch.Builder, ObjectBuilder<IntervalsMatch>> fn) {
            return this.match(fn.apply(new IntervalsMatch.Builder()).build());
        }

        public ObjectBuilder<IntervalsQuery> prefix(IntervalsPrefix v) {
            this._kind = Kind.Prefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> prefix(Function<IntervalsPrefix.Builder, ObjectBuilder<IntervalsPrefix>> fn) {
            return this.prefix(fn.apply(new IntervalsPrefix.Builder()).build());
        }

        public ObjectBuilder<IntervalsQuery> wildcard(IntervalsWildcard v) {
            this._kind = Kind.Wildcard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsQuery> wildcard(Function<IntervalsWildcard.Builder, ObjectBuilder<IntervalsWildcard>> fn) {
            return this.wildcard(fn.apply(new IntervalsWildcard.Builder()).build());
        }

        @Override
        public IntervalsQuery build() {
            this._checkSingleUse();
            return new IntervalsQuery(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        AllOf("all_of"),
        AnyOf("any_of"),
        Fuzzy("fuzzy"),
        Match("match"),
        Prefix("prefix"),
        Wildcard("wildcard");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

