/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxRcptHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxRcptHandler.class);
    private static final HookResult MAX_RCPT = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("452").smtpDescription(DSNStatus.getStatus(4, "5.3") + " Requested action not taken: max recipients reached").build();
    private int maxRcpt = 0;

    public void setMaxRcpt(int maxRcpt) {
        this.maxRcpt = maxRcpt;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (session.getRcptCount() + 1 > this.maxRcpt) {
            LOGGER.info("Maximum recipients of {} reached", (Object)this.maxRcpt);
            return MAX_RCPT;
        }
        return HookResult.DECLINED;
    }
}

