/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacationReply {
    private static final Logger LOGGER = LoggerFactory.getLogger(VacationReply.class);
    private final MailAddress sender;
    private final List<MailAddress> recipients;
    private final MimeMessage mimeMessage;

    public static Builder builder(Mail originalMail, ActionContext context) {
        return new Builder(originalMail, context);
    }

    private VacationReply(MailAddress sender, List<MailAddress> recipients, MimeMessage mimeMessage) {
        this.sender = sender;
        this.recipients = recipients;
        this.mimeMessage = mimeMessage;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public List<MailAddress> getRecipients() {
        return this.recipients;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public static class Builder {
        private final Mail originalMail;
        private final ActionContext context;
        private String from;
        private String reason;
        private String mime;
        private String subject;

        public Builder(Mail originalMail, ActionContext context) {
            Preconditions.checkArgument((boolean)originalMail.hasSender());
            this.originalMail = originalMail;
            this.context = context;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder mime(String mime) {
            this.mime = mime;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public VacationReply build() throws MessagingException {
            Preconditions.checkState((boolean)this.eitherReasonOrMime());
            ActionUtils.detectAndHandleLocalLooping(this.originalMail, this.context, "vacation");
            MimeMessage reply = (MimeMessage)this.originalMail.getMessage().reply(false);
            reply.setSubject(this.generateNotificationSubject());
            reply.setContent(this.generateNotificationContent());
            return new VacationReply(this.retrieveOriginalSender(), (List<MailAddress>)ImmutableList.of((Object)this.originalMail.getMaybeSender().get()), reply);
        }

        private boolean eitherReasonOrMime() {
            return this.reason == null ^ this.mime == null;
        }

        private String generateNotificationSubject() {
            return Optional.ofNullable(this.subject).orElseGet(() -> this.context.getRecipient() + " is currently in vacation");
        }

        private Multipart generateNotificationContent() throws MessagingException {
            try {
                if (this.reason != null) {
                    return this.generateNotificationContentFromReasonString();
                }
                return this.generateNotificationContentFromMime();
            }
            catch (IOException e) {
                throw new MessagingException("Cannot read specified content", (Exception)e);
            }
        }

        private Multipart generateNotificationContentFromMime() throws MessagingException, IOException {
            return new MimeMultipart((DataSource)new ByteArrayDataSource(this.mime, "mixed"));
        }

        private Multipart generateNotificationContentFromReasonString() throws MessagingException, IOException {
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeBodyPart reasonPart = new MimeBodyPart();
            reasonPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.reason, "text/plain; charset=UTF-8")));
            reasonPart.setDisposition("inline");
            multipart.addBodyPart((BodyPart)reasonPart);
            return multipart;
        }

        private MailAddress retrieveOriginalSender() {
            return Optional.ofNullable(this.from).flatMap(this::retrieveAddressFromString).orElse(this.context.getRecipient());
        }

        private Optional<MailAddress> retrieveAddressFromString(String address) {
            try {
                return Optional.of(new MailAddress(address));
            }
            catch (AddressException e) {
                LOGGER.warn("Mail address {} was not well formatted : {}", (Object)address, (Object)e.getLocalizedMessage());
                return Optional.empty();
            }
        }
    }
}

