/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.NSEC3Record;

public class DnssecAlgorithmOption
extends EDNSOption {
    private final List<Integer> algCodes;

    private DnssecAlgorithmOption(int code) {
        super(code);
        switch (code) {
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid option code, must be one of DAU, DHU, N3U");
            }
        }
        this.algCodes = new ArrayList<Integer>();
    }

    public DnssecAlgorithmOption(int code, List<Integer> algCodes) {
        this(code);
        this.algCodes.addAll(algCodes);
    }

    public DnssecAlgorithmOption(int code, int ... algCodes) {
        this(code);
        if (algCodes != null) {
            for (int algCode : algCodes) {
                this.algCodes.add(algCode);
            }
        }
    }

    public List<Integer> getAlgorithms() {
        return Collections.unmodifiableList(this.algCodes);
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        this.algCodes.clear();
        while (in.remaining() > 0) {
            this.algCodes.add(in.readU8());
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        this.algCodes.forEach(out::writeU8);
    }

    @Override
    String optionToString() {
        Function<Integer, String> mapper;
        switch (this.getCode()) {
            case 5: {
                mapper = DNSSEC.Algorithm::string;
                break;
            }
            case 6: {
                mapper = DNSSEC.Digest::string;
                break;
            }
            case 7: {
                mapper = NSEC3Record.Digest::string;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown option code");
            }
        }
        return "[" + this.algCodes.stream().map(mapper).collect(Collectors.joining(", ")) + "]";
    }
}

