/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.terms.AMechanism;

public class MXMechanism
extends AMechanism
implements SPFCheckerDNSResponseListener {
    private static final String ATTRIBUTE_MX_RECORDS = "MXMechanism.mxRecords";
    private static final String ATTRIBUTE_CHECK_RECORDS = "MXMechanism.checkRecords";
    public static final String REGEX = "[mM][xX](?:\\:((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-))))?(?:(?:/(\\d+))?(?://(\\d+))?)?";
    private SPFChecker expandedChecker = new ExpandedChecker();

    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        spfData.increaseCurrentDepth();
        spfData.pushChecker(this.expandedChecker);
        return this.macroExpand.checkExpand(this.getDomain(), spfData, false);
    }

    public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession spfSession) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        try {
            String mx;
            List<String> records = (List<String>)spfSession.getAttribute(ATTRIBUTE_CHECK_RECORDS);
            ArrayList<String> mxR = (ArrayList<String>)spfSession.getAttribute(ATTRIBUTE_MX_RECORDS);
            if (records == null) {
                records = response.getResponse();
                if (records == null) {
                    spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
                    return null;
                }
                spfSession.setAttribute(ATTRIBUTE_CHECK_RECORDS, records);
            } else {
                List<String> res = response.getResponse();
                if (res != null) {
                    if (mxR == null) {
                        mxR = new ArrayList<String>();
                        spfSession.setAttribute(ATTRIBUTE_MX_RECORDS, mxR);
                    }
                    mxR.addAll(res);
                }
            }
            boolean isIPv6 = IPAddr.isIPV6(spfSession.getIpAddress());
            if (records.size() > 0 && (mx = records.remove(0)) != null && mx.length() > 0) {
                this.log.debug("Add MX-Record " + mx + " to list");
                return new DNSLookupContinuation(new DNSRequest(mx, isIPv6 ? 2 : 1), this);
            }
            if (mxR == null || mxR.size() == 0) {
                spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
                return null;
            }
            IPAddr checkAddress = IPAddr.getAddress(spfSession.getIpAddress(), isIPv6 ? this.getIp6cidr() : this.getIp4cidr());
            spfSession.removeAttribute(ATTRIBUTE_CHECK_RECORDS);
            spfSession.removeAttribute(ATTRIBUTE_MX_RECORDS);
            spfSession.setAttribute("Mechanism.result", this.checkAddressList(checkAddress, mxR, this.getIp4cidr()));
            return null;
        }
        catch (TimeoutException e) {
            spfSession.setAttribute(ATTRIBUTE_CHECK_RECORDS, null);
            spfSession.setAttribute(ATTRIBUTE_MX_RECORDS, null);
            throw new TempErrorException("Timeout querying the dns server");
        }
    }

    public String toString() {
        return super.toString("mx");
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            String host = MXMechanism.this.expandHost(spfData);
            return new DNSLookupContinuation(new DNSRequest(host, 3), MXMechanism.this);
        }
    }
}

