/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ConnectAccessLogMessage
extends AccessLogMessage {
    private static final long serialVersionUID = 4254346309071273212L;
    @Nullable
    private final String clientConnectionPolicy;
    @Nullable
    private final String protocolName;
    @Nullable
    private final String sourceAddress = this.getNamedValue("from");
    @Nullable
    private final String targetAddress = this.getNamedValue("to");

    public ConnectAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public ConnectAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.protocolName = this.getNamedValue("protocol");
        this.clientConnectionPolicy = this.getNamedValue("clientConnectionPolicy");
    }

    @Nullable
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    @Nullable
    public String getTargetAddress() {
        return this.targetAddress;
    }

    @Nullable
    public String getProtocolName() {
        return this.protocolName;
    }

    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicy;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CONNECT;
    }
}

