/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.Domain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAddress
implements Serializable {
    public static final Logger LOGGER = LoggerFactory.getLogger(MailAddress.class);
    public static final long serialVersionUID = 2779163542539434916L;
    private static final char[] SPECIAL = new char[]{'<', '>', '(', ')', '[', ']', '\\', '.', ',', ';', ':', '@', '\"'};
    public static final String NULL_SENDER_AS_STRING = "<>";
    private static final MailAddress NULL_SENDER = new MailAddress(){

        @Override
        public Domain getDomain() {
            throw new IllegalStateException("NULL sender '<>' do not have domain part");
        }

        @Override
        public String getLocalPart() {
            throw new IllegalStateException("NULL sender '<>' do not have local part");
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public String asString() {
            return MailAddress.NULL_SENDER_AS_STRING;
        }

        @Override
        public boolean isNullSender() {
            return true;
        }
    };
    private final String localPart;
    private final Domain domain;

    public static MailAddress nullSender() {
        return NULL_SENDER;
    }

    @Deprecated
    public static MailAddress getMailSender(String sender) {
        if (sender == null || sender.trim().length() <= 0) {
            return null;
        }
        if (sender.equals(NULL_SENDER_AS_STRING)) {
            return MailAddress.nullSender();
        }
        try {
            return new MailAddress(sender);
        }
        catch (AddressException e) {
            LOGGER.error("Unable to parse the sender address {}, so we fallback to a null sender", (Object)sender, (Object)e);
            return MailAddress.nullSender();
        }
    }

    private MailAddress() {
        this.localPart = null;
        this.domain = null;
    }

    private int stripSourceRoute(String address, int pos) {
        int i;
        if (pos < address.length() && address.charAt(pos) == '@' && (i = address.indexOf(58)) != -1) {
            pos = i + 1;
        }
        return pos;
    }

    public MailAddress(String address) throws AddressException {
        address = address.trim();
        int pos = 0;
        this.stripSourceRoute(address, pos);
        StringBuilder localPartSB = new StringBuilder();
        StringBuilder domainSB = new StringBuilder();
        try {
            pos = address.charAt(pos) == '\"' ? this.parseQuotedLocalPartOrThrowException(localPartSB, address, pos) : this.parseUnquotedLocalPartOrThrowException(localPartSB, address, pos);
            if (pos >= address.length() || address.charAt(pos) != '@') {
                throw new AddressException("Did not find @ between local-part and domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            ++pos;
            while ((pos = address.charAt(pos) == '#' ? this.parseNumber(domainSB, address, pos) : (address.charAt(pos) == '[' ? this.parseDomainLiteral(domainSB, address, pos) : this.parseDomain(domainSB, address, pos))) < address.length() && address.charAt(pos) == '.') {
                char lastChar = address.charAt(pos - 1);
                if (lastChar == '@' || lastChar == '.') {
                    throw new AddressException("Subdomain expected before '.' or duplicate '.' in " + address);
                }
                domainSB.append('.');
                ++pos;
            }
            if (domainSB.length() == 0) {
                throw new AddressException("No domain found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new AddressException("Out of data at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        this.localPart = localPartSB.toString();
        if (this.localPart.startsWith(".") || this.localPart.endsWith(".") || this.haveDoubleDot(this.localPart)) {
            throw new AddressException("Addresses cannot start end with '.' or contain two consecutive dots");
        }
        this.domain = this.createDomain(domainSB.toString());
    }

    private boolean haveDoubleDot(String localPart) {
        return Splitter.on((char)'.').splitToList((CharSequence)localPart).stream().anyMatch(String::isEmpty);
    }

    private Domain createDomain(String domain) throws AddressException {
        try {
            return Domain.of(domain);
        }
        catch (IllegalArgumentException e) {
            throw new AddressException(e.getMessage());
        }
    }

    private int parseUnquotedLocalPartOrThrowException(StringBuilder localPartSB, String address, int pos) throws AddressException {
        pos = this.parseUnquotedLocalPart(localPartSB, address, pos);
        if (localPartSB.length() == 0) {
            throw new AddressException("No local-part (user account) found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        return pos;
    }

    private int parseQuotedLocalPartOrThrowException(StringBuilder localPartSB, String address, int pos) throws AddressException {
        pos = this.parseQuotedLocalPart(localPartSB, address, pos);
        if (localPartSB.length() == 2) {
            throw new AddressException("No quoted local-part (user account) found at position " + (pos + 2) + " in '" + address + "'", address, pos + 2);
        }
        return pos;
    }

    public MailAddress(String localPart, String domain) throws AddressException {
        this(new InternetAddress(localPart + "@" + domain));
    }

    public MailAddress(String localPart, Domain domain) throws AddressException {
        this(new InternetAddress(localPart + "@" + domain.name()));
    }

    public MailAddress(InternetAddress address) throws AddressException {
        this(address.getAddress());
    }

    @Deprecated
    public String getHost() {
        return this.domain.asString();
    }

    public Domain getDomain() {
        return this.domain;
    }

    @Deprecated
    public String getUser() {
        return this.getLocalPart();
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String asString() {
        return this.localPart + "@" + this.domain.asString();
    }

    public String toString() {
        return this.localPart + "@" + Optional.ofNullable(this.domain).map(Domain::asString).orElse("");
    }

    public String asPrettyString() {
        return "<" + this.asString() + ">";
    }

    public Optional<InternetAddress> toInternetAddress() {
        try {
            return Optional.of(new InternetAddress(this.toString()));
        }
        catch (AddressException ae) {
            LOGGER.warn("A valid address '{}' as per James criterial fails to parse as a javax.mail InternetAdrress", (Object)this.asString());
            return Optional.empty();
        }
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String theString = (String)obj;
            return this.toString().equalsIgnoreCase(theString);
        }
        if (obj instanceof MailAddress) {
            MailAddress that = (MailAddress)obj;
            boolean bothNullSender = this.isNullSender() && that.isNullSender();
            boolean onlyOneIsNullSender = this.isNullSender() ^ that.isNullSender();
            if (bothNullSender) {
                return true;
            }
            if (onlyOneIsNullSender) {
                return false;
            }
            return this.equalsIgnoreCase(this.getLocalPart(), that.getLocalPart()) && Objects.equals(this.getDomain(), that.getDomain());
        }
        return false;
    }

    private boolean equalsIgnoreCase(String a, String b) {
        if (a == null ^ b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.equalsIgnoreCase(b);
    }

    public final int hashCode() {
        return this.toString().toLowerCase(Locale.US).hashCode();
    }

    private int parseQuotedLocalPart(StringBuilder lpSB, String address, int pos) throws AddressException {
        lpSB.append('\"');
        ++pos;
        while (true) {
            if (address.charAt(pos) == '\"') break;
            if (address.charAt(pos) == '\\') {
                lpSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                lpSB.append(x);
                ++pos;
                continue;
            }
            char q = address.charAt(pos);
            if (q <= '\u0000' || q == '\n' || q == '\r' || q == '\"' || q == '\\') {
                throw new AddressException("Unquoted local-part (user account) must be one of the 128 ASCI characters exception <CR>, <LF>, quote (\"), or backslash (\\) at position " + (pos + 1) + " in '" + address + "'");
            }
            lpSB.append(q);
            ++pos;
        }
        lpSB.append('\"');
        return ++pos;
    }

    private int parseUnquotedLocalPart(StringBuilder lpSB, String address, int pos) throws AddressException {
        boolean lastCharDot = false;
        while (true) {
            if (address.charAt(pos) == '\\') {
                lpSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                lpSB.append(x);
                ++pos;
                lastCharDot = false;
                continue;
            }
            if (address.charAt(pos) == '.') {
                if (pos == 0) {
                    throw new AddressException("Local part must not start with a '.'");
                }
                lpSB.append('.');
                ++pos;
                lastCharDot = true;
                continue;
            }
            if (address.charAt(pos) == '@') break;
            char c = address.charAt(pos);
            if (c <= '\u001f' || c >= '\u007f' || c == ' ') {
                throw new AddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            for (int i = 0; i < SPECIAL.length; ++i) {
                if (c != SPECIAL[i]) continue;
                throw new AddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            lpSB.append(c);
            ++pos;
            lastCharDot = false;
        }
        if (lastCharDot) {
            throw new AddressException("local-part (user account) ended with a \".\", which is invalid in address '" + address + "'", address, pos);
        }
        return pos;
    }

    private int parseNumber(StringBuilder dSB, String address, int pos) throws AddressException {
        char d;
        dSB.append(address.charAt(pos));
        ++pos;
        while (pos < address.length() && (d = address.charAt(pos)) != '.') {
            if (d < '0' || d > '9') {
                throw new AddressException("In domain, did not find a number in # address at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            dSB.append(d);
            ++pos;
        }
        if (dSB.length() < 2) {
            throw new AddressException("In domain, did not find a number in # address at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        return pos;
    }

    private int parseDomainLiteral(StringBuilder dSB, String address, int pos) throws AddressException {
        dSB.append(address.charAt(pos));
        ++pos;
        for (int octet = 0; octet < 4; ++octet) {
            char currentChar;
            StringBuilder snumSB = new StringBuilder();
            for (int digits = 0; digits < 3 && (currentChar = address.charAt(pos)) != '.' && currentChar != ']'; ++digits) {
                if (currentChar < '0' || currentChar > '9') {
                    throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                snumSB.append(currentChar);
                ++pos;
            }
            if (snumSB.length() == 0) {
                throw new AddressException("Number not found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            try {
                int snum = Integer.parseInt(snumSB.toString());
                if (snum > 255) {
                    throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
            }
            catch (NumberFormatException nfe) {
                throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            dSB.append(snumSB.toString());
            if (address.charAt(pos) == ']') {
                if (octet >= 3) break;
                throw new AddressException("End of number reached too quickly at " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            if (address.charAt(pos) != '.') continue;
            dSB.append('.');
            ++pos;
        }
        if (address.charAt(pos) != ']') {
            throw new AddressException("Did not find closing bracket \"]\" in domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        dSB.append(']');
        return ++pos;
    }

    private int parseDomain(StringBuilder dSB, String address, int pos) throws AddressException {
        String result;
        StringBuilder resultSB = new StringBuilder();
        while (pos < address.length()) {
            char ch = address.charAt(pos);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-') {
                resultSB.append(ch);
                ++pos;
                continue;
            }
            if (ch == '.') break;
            throw new AddressException("Invalid character at " + pos + " in '" + address + "'", address, pos);
        }
        if ((result = resultSB.toString()).startsWith("-") || result.endsWith("-")) {
            throw new AddressException("Domain name cannot begin or end with a hyphen \"-\" at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        dSB.append(result);
        return pos;
    }

    @Deprecated
    public boolean isNullSender() {
        return false;
    }
}

