/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.NoOpRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedRequestProperties;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.DurationCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.HeadAndTailSizeCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionPostConnectProcessor;
import com.unboundid.ldap.sdk.unboundidds.extensions.TimeWindowCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.ldap.sdk.unboundidds.tools.CollectSupportDataIRListener;
import com.unboundid.ldap.sdk.unboundidds.tools.ReportBindResultLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.TimestampArgument;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CollectSupportData
extends LDAPCommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    static final String SERVER_LOG_TIMESTAMP_FORMAT_WITH_MILLIS = "'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'";
    @NotNull
    static final String SERVER_LOG_TIMESTAMP_FORMAT_WITHOUT_MILLIS = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    @NotNull
    private static final String SERVER_CSD_TOOL_CLASS = "com.unboundid.directory.server.tools.CollectSupportData";
    @NotNull
    private final AtomicReference<String> toolCompletionMessage = new AtomicReference();
    @Nullable
    private ArgumentParser parser = null;
    @Nullable
    private BooleanArgument archiveExtensionSourceArg = null;
    @Nullable
    private BooleanArgument collectExpensiveDataArg = null;
    @Nullable
    private BooleanArgument collectReplicationStateDumpArg = null;
    @Nullable
    private BooleanArgument dryRunArg = null;
    @Nullable
    private BooleanArgument encryptArg = null;
    @Nullable
    private BooleanArgument generatePassphraseArg = null;
    @Nullable
    private BooleanArgument includeBinaryFilesArg = null;
    @Nullable
    private BooleanArgument noLDAPArg = null;
    @Nullable
    private BooleanArgument noPromptArg = null;
    @Nullable
    private BooleanArgument scriptFriendlyArg = null;
    @Nullable
    private BooleanArgument sequentialArg = null;
    @Nullable
    private BooleanArgument useAdministrativeSessionArg;
    @Nullable
    private BooleanArgument useRemoteServerArg = null;
    @Nullable
    private DurationArgument logDurationArg = null;
    @Nullable
    private FileArgument decryptArg = null;
    @Nullable
    private FileArgument outputPathArg = null;
    @Nullable
    private FileArgument passphraseFileArg = null;
    @Nullable
    private IntegerArgument jstackCountArg = null;
    @Nullable
    private IntegerArgument logFileHeadCollectionSizeKBArg = null;
    @Nullable
    private IntegerArgument logFileTailCollectionSizeKBArg = null;
    @Nullable
    private IntegerArgument reportCountArg = null;
    @Nullable
    private IntegerArgument reportIntervalSecondsArg = null;
    @Nullable
    private IntegerArgument pidArg = null;
    @Nullable
    private IntegerArgument proxyToServerPortArg = null;
    @Nullable
    private StringArgument commentArg = null;
    @Nullable
    private StringArgument proxyToServerAddressArg = null;
    @Nullable
    private StringArgument securityLevelArg = null;
    @Nullable
    private StringArgument logTimeRangeArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = CollectSupportData.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS && resultCode != ResultCode.NO_OPERATION) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        CollectSupportData tool = new CollectSupportData(out, err);
        return tool.runTool(args);
    }

    public CollectSupportData(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "collect-support-data";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_CSD_TOOL_DESCRIPTION_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.singletonList(ToolMessages.INFO_CSD_TOOL_DESCRIPTION_2.get());
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.3";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return false;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return this.noPromptArg == null || !this.noPromptArg.isPresent();
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.toolCompletionMessage.get();
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.outputPathArg = new FileArgument(null, "outputPath", false, 1, null, ToolMessages.INFO_CSD_ARG_DESC_OUTPUT_PATH.get(), false, true, false, false);
        this.outputPathArg.addLongIdentifier("output-path", true);
        this.outputPathArg.addLongIdentifier("outputFile", true);
        this.outputPathArg.addLongIdentifier("output-file", true);
        this.outputPathArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputPathArg);
        this.encryptArg = new BooleanArgument(null, "encrypt", 1, ToolMessages.INFO_CSD_ARG_DESC_ENCRYPT.get());
        this.encryptArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.encryptArg);
        this.passphraseFileArg = new FileArgument(null, "passphraseFile", false, 1, null, ToolMessages.INFO_CSD_ARG_DESC_PASSPHRASE_FILE.get(), false, true, true, false);
        this.passphraseFileArg.addLongIdentifier("passphrase-file", true);
        this.passphraseFileArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.passphraseFileArg);
        this.generatePassphraseArg = new BooleanArgument(null, "generatePassphrase", 1, ToolMessages.INFO_CSD_ARG_DESC_GENERATE_PASSPHRASE.get());
        this.generatePassphraseArg.addLongIdentifier("generate-passphrase", true);
        this.generatePassphraseArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.generatePassphraseArg);
        this.decryptArg = new FileArgument(null, "decrypt", false, 1, null, ToolMessages.INFO_CSD_ARG_DESC_DECRYPT.get(), false, true, true, false);
        this.decryptArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.decryptArg);
        this.collectExpensiveDataArg = new BooleanArgument(null, "collectExpensiveData", 1, ToolMessages.INFO_CSD_ARG_DESC_COLLECT_EXPENSIVE_DATA.get());
        this.collectExpensiveDataArg.addLongIdentifier("collect-expensive-data", true);
        this.collectExpensiveDataArg.addLongIdentifier("includeExpensiveData", true);
        this.collectExpensiveDataArg.addLongIdentifier("include-expensive-data", true);
        this.collectExpensiveDataArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.collectExpensiveDataArg);
        this.collectReplicationStateDumpArg = new BooleanArgument(null, "collectReplicationStateDump", 1, ToolMessages.INFO_CSD_ARG_DESC_COLLECT_REPL_STATE.get());
        this.collectReplicationStateDumpArg.addLongIdentifier("collect-replication-state-dump", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("collectReplicationState", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("collect-replication-state", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("includeReplicationStateDump", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("include-replication-state-dump", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("includeReplicationState", true);
        this.collectReplicationStateDumpArg.addLongIdentifier("include-replication-state", true);
        this.collectReplicationStateDumpArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.collectReplicationStateDumpArg);
        this.includeBinaryFilesArg = new BooleanArgument(null, "includeBinaryFiles", 1, ToolMessages.INFO_CSD_ARG_DESC_INCLUDE_BINARY_FILES.get());
        this.includeBinaryFilesArg.addLongIdentifier("include-binary-files", true);
        this.includeBinaryFilesArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.includeBinaryFilesArg);
        this.archiveExtensionSourceArg = new BooleanArgument(null, "archiveExtensionSource", 1, ToolMessages.INFO_CSD_ARG_DESC_ARCHIVE_EXTENSION_SOURCE.get());
        this.archiveExtensionSourceArg.addLongIdentifier("archive-extension-source", true);
        this.archiveExtensionSourceArg.addLongIdentifier("includeExtensionSource", true);
        this.archiveExtensionSourceArg.addLongIdentifier("include-extension-source", true);
        this.archiveExtensionSourceArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.archiveExtensionSourceArg);
        this.sequentialArg = new BooleanArgument(null, "sequential", 1, ToolMessages.INFO_CSD_ARG_DESC_SEQUENTIAL.get());
        this.sequentialArg.addLongIdentifier("sequentialMode", true);
        this.sequentialArg.addLongIdentifier("sequential-mode", true);
        this.sequentialArg.addLongIdentifier("useSequentialMode", true);
        this.sequentialArg.addLongIdentifier("use-sequential-mode", true);
        this.sequentialArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.sequentialArg);
        this.securityLevelArg = new StringArgument(null, "securityLevel", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_SECURITY_LEVEL.get(), ToolMessages.INFO_CSD_ARG_DESC_SECURITY_LEVEL.get(), StaticUtils.setOf(CollectSupportDataSecurityLevel.NONE.getName(), CollectSupportDataSecurityLevel.OBSCURE_SECRETS.getName(), CollectSupportDataSecurityLevel.MAXIMUM.getName()));
        this.securityLevelArg.addLongIdentifier("security-level", true);
        this.securityLevelArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.securityLevelArg);
        this.jstackCountArg = new IntegerArgument(null, "jstackCount", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_COUNT.get(), ToolMessages.INFO_CSD_ARG_DESC_JSTACK_COUNT.get(), 0, Integer.MAX_VALUE);
        this.jstackCountArg.addLongIdentifier("jstack-count", true);
        this.jstackCountArg.addLongIdentifier("maxJstacks", true);
        this.jstackCountArg.addLongIdentifier("max-jstacks", true);
        this.jstackCountArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.jstackCountArg);
        this.reportCountArg = new IntegerArgument(null, "reportCount", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_COUNT.get(), ToolMessages.INFO_CSD_ARG_DESC_REPORT_COUNT.get(), 0, Integer.MAX_VALUE);
        this.reportCountArg.addLongIdentifier("report-count", true);
        this.reportCountArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.reportCountArg);
        this.reportIntervalSecondsArg = new IntegerArgument(null, "reportIntervalSeconds", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_SECONDS.get(), ToolMessages.INFO_CSD_ARG_DESC_REPORT_INTERVAL_SECONDS.get(), 1, Integer.MAX_VALUE);
        this.reportIntervalSecondsArg.addLongIdentifier("report-interval-seconds", true);
        this.reportIntervalSecondsArg.addLongIdentifier("reportInterval", true);
        this.reportIntervalSecondsArg.addLongIdentifier("report-interval", true);
        this.reportIntervalSecondsArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.reportIntervalSecondsArg);
        this.logTimeRangeArg = new StringArgument(null, "logTimeRange", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_TIME_RANGE.get(), ToolMessages.INFO_CSD_ARG_DESC_TIME_RANGE.get());
        this.logTimeRangeArg.addLongIdentifier("log-time-range", true);
        this.logTimeRangeArg.addLongIdentifier("timeRange", true);
        this.logTimeRangeArg.addLongIdentifier("time-range", true);
        this.logTimeRangeArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.logTimeRangeArg);
        this.logDurationArg = new DurationArgument(null, "logDuration", false, null, ToolMessages.INFO_CSD_ARG_DESC_DURATION.get());
        this.logDurationArg.addLongIdentifier("log-duration", true);
        this.logDurationArg.addLongIdentifier("duration", true);
        this.logDurationArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.logDurationArg);
        this.logFileHeadCollectionSizeKBArg = new IntegerArgument(null, "logFileHeadCollectionSizeKB", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_SIZE_KB.get(), ToolMessages.INFO_CSD_ARG_DESC_LOG_HEAD_SIZE_KB.get(), 0, Integer.MAX_VALUE);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("log-file-head-collection-size-kb", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("logFileHeadSizeKB", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("log-file-head-size-kb", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("logHeadCollectionSizeKB", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("log-head-collection-size-kb", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("logHeadSizeKB", true);
        this.logFileHeadCollectionSizeKBArg.addLongIdentifier("log-head-size-kb", true);
        this.logFileHeadCollectionSizeKBArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.logFileHeadCollectionSizeKBArg);
        this.logFileTailCollectionSizeKBArg = new IntegerArgument(null, "logFileTailCollectionSizeKB", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_SIZE_KB.get(), ToolMessages.INFO_CSD_ARG_DESC_LOG_TAIL_SIZE_KB.get(), 0, Integer.MAX_VALUE);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("log-file-tail-collection-size-kb", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("logFileTailSizeKB", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("log-file-tail-size-kb", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("logTailCollectionSizeKB", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("log-tail-collection-size-kb", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("logTailSizeKB", true);
        this.logFileTailCollectionSizeKBArg.addLongIdentifier("log-tail-size-kb", true);
        this.logFileTailCollectionSizeKBArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.logFileTailCollectionSizeKBArg);
        this.pidArg = new IntegerArgument(null, "pid", false, 0, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_PID.get(), ToolMessages.INFO_CSD_ARG_DESC_PID.get());
        this.pidArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.pidArg);
        this.commentArg = new StringArgument(null, "comment", false, 1, null, ToolMessages.INFO_CSD_ARG_DESC_COMMENT.get());
        this.commentArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COLLECTION.get());
        parser.addArgument(this.commentArg);
        this.useRemoteServerArg = new BooleanArgument(null, "useRemoteServer", 1, ToolMessages.INFO_CSD_ARG_DEC_USE_REMOTE_SERVER.get());
        this.useRemoteServerArg.addLongIdentifier("use-remote-server", true);
        this.useRemoteServerArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COMMUNICATION.get());
        parser.addArgument(this.useRemoteServerArg);
        this.useAdministrativeSessionArg = new BooleanArgument(null, "useAdministrativeSession", 1, ToolMessages.INFO_CSD_ARG_DESC_USE_ADMIN_SESSION.get());
        this.useAdministrativeSessionArg.addLongIdentifier("use-administrative-session", true);
        this.useAdministrativeSessionArg.addLongIdentifier("useAdminSession", true);
        this.useAdministrativeSessionArg.addLongIdentifier("use-admin-session", true);
        this.useAdministrativeSessionArg.addLongIdentifier("administrativeSession", true);
        this.useAdministrativeSessionArg.addLongIdentifier("administrative-session", true);
        this.useAdministrativeSessionArg.addLongIdentifier("adminSession", true);
        this.useAdministrativeSessionArg.addLongIdentifier("admin-session", true);
        this.useAdministrativeSessionArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COMMUNICATION.get());
        parser.addArgument(this.useAdministrativeSessionArg);
        this.proxyToServerAddressArg = new StringArgument(null, "proxyToServerAddress", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_ADDRESS.get(), ToolMessages.INFO_CSD_ARG_DESC_PROXY_TO_ADDRESS.get());
        this.proxyToServerAddressArg.addLongIdentifier("proxy-to-server-address", true);
        this.proxyToServerAddressArg.addLongIdentifier("proxyToAddress", true);
        this.proxyToServerAddressArg.addLongIdentifier("proxy-to-address", true);
        this.proxyToServerAddressArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COMMUNICATION.get());
        parser.addArgument(this.proxyToServerAddressArg);
        this.proxyToServerPortArg = new IntegerArgument(null, "proxyToServerPort", false, 1, ToolMessages.INFO_CSD_ARG_PLACEHOLDER_PORT.get(), ToolMessages.INFO_CSD_ARG_DESC_PROXY_TO_PORT.get(), 1, 65535);
        this.proxyToServerPortArg.addLongIdentifier("proxy-to-server-port", true);
        this.proxyToServerPortArg.addLongIdentifier("proxyToPort", true);
        this.proxyToServerPortArg.addLongIdentifier("proxy-to-port", true);
        this.proxyToServerPortArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COMMUNICATION.get());
        parser.addArgument(this.proxyToServerPortArg);
        this.noLDAPArg = new BooleanArgument(null, "noLDAP", 1, ToolMessages.INFO_CSD_ARG_DESC_NO_LDAP.get());
        this.noLDAPArg.addLongIdentifier("no-ldap", true);
        this.noLDAPArg.setArgumentGroupName(ToolMessages.INFO_CSD_ARG_GROUP_COMMUNICATION.get());
        parser.addArgument(this.noLDAPArg);
        this.noPromptArg = new BooleanArgument(Character.valueOf('n'), "noPrompt", 1, ToolMessages.INFO_CSD_ARG_DESC_NO_PROMPT.get());
        this.noPromptArg.addLongIdentifier("no-prompt", true);
        parser.addArgument(this.noPromptArg);
        this.dryRunArg = new BooleanArgument(null, "dryRun", 1, ToolMessages.INFO_CSD_ARG_DESC_DRY_RUN.get());
        this.dryRunArg.addLongIdentifier("dry-run", true);
        this.dryRunArg.addLongIdentifier("noOperation", true);
        this.dryRunArg.addLongIdentifier("no-operation", true);
        this.dryRunArg.addLongIdentifier("noOp", true);
        this.dryRunArg.addLongIdentifier("no-op", true);
        parser.addArgument(this.dryRunArg);
        this.scriptFriendlyArg = new BooleanArgument(null, "scriptFriendly", 1, ToolMessages.INFO_CSD_ARG_DESC_SCRIPT_FRIENDLY.get());
        this.scriptFriendlyArg.addLongIdentifier("script-friendly", true);
        this.scriptFriendlyArg.setHidden(true);
        parser.addArgument(this.scriptFriendlyArg);
        parser.addExclusiveArgumentSet(this.useRemoteServerArg, this.pidArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useRemoteServerArg, this.decryptArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useRemoteServerArg, this.noLDAPArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useRemoteServerArg, this.scriptFriendlyArg, new Argument[0]);
        parser.addDependentArgumentSet(this.useAdministrativeSessionArg, this.useRemoteServerArg, new Argument[0]);
        parser.addMutuallyDependentArgumentSet(this.proxyToServerAddressArg, this.proxyToServerPortArg, new Argument[0]);
        parser.addDependentArgumentSet(this.proxyToServerAddressArg, this.useRemoteServerArg, new Argument[0]);
        parser.addDependentArgumentSet(this.proxyToServerPortArg, this.useRemoteServerArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.logTimeRangeArg, this.logDurationArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.logFileHeadCollectionSizeKBArg, this.logTimeRangeArg, this.logDurationArg);
        parser.addExclusiveArgumentSet(this.logFileTailCollectionSizeKBArg, this.logTimeRangeArg, this.logDurationArg);
        parser.addDependentArgumentSet(this.generatePassphraseArg, this.encryptArg, new Argument[0]);
        parser.addDependentArgumentSet(this.generatePassphraseArg, this.passphraseFileArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.encryptArg, this.decryptArg, new Argument[0]);
        for (String argumentIdentifier : Arrays.asList("promptForBindPassword", "promptForKeyStorePassword", "promptForTrustStorePassword", "enableSSLDebugging", "useSASLExternal")) {
            Argument arg = parser.getNamedArgument(argumentIdentifier);
            parser.addDependentArgumentSet(arg, this.useRemoteServerArg, new Argument[0]);
        }
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        File passphraseFile;
        if (this.logTimeRangeArg.isPresent()) {
            try {
                CollectSupportData.parseTimeRange(this.logTimeRangeArg.getValue(), this.useRemoteServerArg.isPresent());
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.toolCompletionMessage.set(e.getMessage());
                throw new ArgumentException(e.getMessage(), e);
            }
        }
        if (this.passphraseFileArg.isPresent() && !this.generatePassphraseArg.isPresent() && !(passphraseFile = this.passphraseFileArg.getValue()).exists()) {
            String message = ToolMessages.ERR_CSD_PASSPHRASE_FILE_MISSING.get(passphraseFile.getAbsolutePath());
            this.toolCompletionMessage.set(message);
            throw new ArgumentException(message);
        }
        if (this.noPromptArg.isPresent() && (this.encryptArg.isPresent() || this.decryptArg.isPresent()) && !this.passphraseFileArg.isPresent()) {
            String message = ToolMessages.ERR_CSD_NO_PASSPHRASE_WITH_NO_PROMPT.get();
            this.toolCompletionMessage.set(message);
            throw new ArgumentException(message);
        }
    }

    @Nullable
    static ObjectPair<Date, Date> parseTimeRange(@NotNull String timeRangeStr, boolean strict) throws LDAPException {
        Date endTime;
        Date startTime;
        try {
            int commaPos = timeRangeStr.indexOf(44);
            if (commaPos > 0) {
                startTime = CollectSupportData.parseTimestamp(timeRangeStr.substring(0, commaPos).trim());
                endTime = CollectSupportData.parseTimestamp(timeRangeStr.substring(commaPos + 1).trim());
            } else {
                startTime = CollectSupportData.parseTimestamp(timeRangeStr);
                endTime = null;
            }
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            if (strict) {
                throw e;
            }
            return null;
        }
        if (endTime != null && startTime.getTime() > endTime.getTime()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_CSD_TIME_RANGE_START_GREATER_THAN_END.get());
        }
        return new ObjectPair<Date, Date>(startTime, endTime);
    }

    @NotNull
    static Date parseTimestamp(@NotNull String timestampStr) throws LDAPException {
        try {
            return TimestampArgument.parseTimestamp(timestampStr);
        }
        catch (Exception e) {
            Debug.debugException(Level.FINEST, e);
            try {
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(SERVER_LOG_TIMESTAMP_FORMAT_WITH_MILLIS);
                timestampFormatter.setLenient(false);
                return timestampFormatter.parse(timestampStr);
            }
            catch (Exception e2) {
                Debug.debugException(Level.FINEST, e2);
                try {
                    SimpleDateFormat timestampFormatter = new SimpleDateFormat(SERVER_LOG_TIMESTAMP_FORMAT_WITHOUT_MILLIS);
                    timestampFormatter.setLenient(false);
                    return timestampFormatter.parse(timestampStr);
                }
                catch (Exception e3) {
                    Debug.debugException(Level.FINEST, e3);
                    throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_CSD_TIME_RANGE_CANNOT_PARSE_TIMESTAMP.get(timestampStr));
                }
            }
        }
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        if (this.useRemoteServerArg.isPresent()) {
            return this.doExtendedOperationProcessing();
        }
        return this.doLocalProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ResultCode doExtendedOperationProcessing() {
        LDAPConnectionPool pool;
        StartAdministrativeSessionPostConnectProcessor p = this.useAdministrativeSessionArg.isPresent() ? new StartAdministrativeSessionPostConnectProcessor(new StartAdministrativeSessionExtendedRequest(this.getToolName(), true, new Control[0])) : null;
        try {
            pool = this.getConnectionPool(1, 1, 0, p, null, true, new ReportBindResultLDAPConnectionPoolHealthCheck(this, true, false));
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, e.getMessage());
            this.toolCompletionMessage.set(e.getMessage());
            return e.getResultCode();
        }
        try {
            ResultCode resultCode;
            block48: {
                CollectSupportDataExtendedRequestProperties properties = new CollectSupportDataExtendedRequestProperties();
                File outputPath = this.outputPathArg.getValue();
                if (!(outputPath == null || outputPath.exists() && outputPath.isDirectory())) {
                    properties.setArchiveFileName(outputPath.getName());
                }
                try {
                    properties.setEncryptionPassphrase(this.getEncryptionPassphraseForExtOpProcessing());
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                    this.toolCompletionMessage.set(e.getMessage());
                    ResultCode resultCode2 = e.getResultCode();
                    pool.close();
                    return resultCode2;
                }
                properties.setIncludeExpensiveData(this.collectExpensiveDataArg.isPresent());
                properties.setIncludeReplicationStateDump(this.collectReplicationStateDumpArg.isPresent());
                properties.setIncludeBinaryFiles(this.includeBinaryFilesArg.isPresent());
                properties.setIncludeExtensionSource(this.archiveExtensionSourceArg.isPresent());
                properties.setUseSequentialMode(this.sequentialArg.isPresent());
                if (this.securityLevelArg.isPresent()) {
                    properties.setSecurityLevel(CollectSupportDataSecurityLevel.forName(this.securityLevelArg.getValue()));
                }
                if (this.jstackCountArg.isPresent()) {
                    properties.setJStackCount(this.jstackCountArg.getValue());
                }
                if (this.reportCountArg.isPresent()) {
                    properties.setReportCount(this.reportCountArg.getValue());
                }
                if (this.reportIntervalSecondsArg.isPresent()) {
                    properties.setReportIntervalSeconds(this.reportIntervalSecondsArg.getValue());
                }
                if (this.logTimeRangeArg.isPresent()) {
                    try {
                        ObjectPair<Date, Date> timeRange = CollectSupportData.parseTimeRange(this.logTimeRangeArg.getValue(), true);
                        properties.setLogCaptureWindow(new TimeWindowCollectSupportDataLogCaptureWindow(timeRange.getFirst(), timeRange.getSecond()));
                    }
                    catch (LDAPException e) {
                        Debug.debugException(e);
                        this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                        this.toolCompletionMessage.set(e.getMessage());
                        ResultCode resultCode3 = e.getResultCode();
                        pool.close();
                        return resultCode3;
                    }
                } else if (this.logDurationArg.isPresent()) {
                    properties.setLogCaptureWindow(new DurationCollectSupportDataLogCaptureWindow(this.logDurationArg.getValue(TimeUnit.MILLISECONDS)));
                } else if (this.logFileHeadCollectionSizeKBArg.isPresent() || this.logFileTailCollectionSizeKBArg.isPresent()) {
                    properties.setLogCaptureWindow(new HeadAndTailSizeCollectSupportDataLogCaptureWindow(this.logFileHeadCollectionSizeKBArg.getValue(), this.logFileTailCollectionSizeKBArg.getValue()));
                }
                if (this.commentArg.isPresent()) {
                    properties.setComment(this.commentArg.getValue());
                }
                if (this.proxyToServerAddressArg.isPresent()) {
                    properties.setProxyToServer(this.proxyToServerAddressArg.getValue(), this.proxyToServerPortArg.getValue());
                }
                resultCode = null;
                try {
                    CollectSupportDataIRListener listener = new CollectSupportDataIRListener(this, this.outputPathArg.getValue());
                    Throwable throwable = null;
                    try {
                        CollectSupportDataExtendedResult result;
                        Control[] controls = this.dryRunArg.isPresent() ? new Control[]{new NoOpRequestControl()} : StaticUtils.NO_CONTROLS;
                        CollectSupportDataExtendedRequest request = new CollectSupportDataExtendedRequest(properties, listener, controls);
                        request.setResponseTimeoutMillis(0L);
                        try {
                            result = (CollectSupportDataExtendedResult)pool.processExtendedOperation(request);
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            String message = ToolMessages.ERR_CSD_ERROR_SENDING_REQUEST.get(StaticUtils.getExceptionMessage(e));
                            this.wrapErr(0, WRAP_COLUMN, message);
                            this.toolCompletionMessage.set(message);
                            ResultCode resultCode4 = e.getResultCode();
                            if (listener != null) {
                                if (throwable != null) {
                                    try {
                                        listener.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    listener.close();
                                }
                            }
                            pool.close();
                            return resultCode4;
                        }
                        resultCode = result.getResultCode();
                        String diagnosticMessage = result.getDiagnosticMessage();
                        if (diagnosticMessage != null) {
                            if (resultCode == ResultCode.SUCCESS || resultCode == ResultCode.NO_OPERATION) {
                                this.wrapOut(0, WRAP_COLUMN, diagnosticMessage);
                            } else {
                                this.wrapErr(0, WRAP_COLUMN, diagnosticMessage);
                            }
                            this.toolCompletionMessage.set(diagnosticMessage);
                        } else {
                            this.toolCompletionMessage.set(ToolMessages.INFO_CSD_COMPLETED_WITH_RESULT_CODE.get(String.valueOf(resultCode)));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    Debug.debugException(e);
                    if (resultCode != ResultCode.SUCCESS) break block48;
                    resultCode = ResultCode.LOCAL_ERROR;
                    this.toolCompletionMessage.set(e.getMessage());
                }
            }
            ResultCode resultCode5 = resultCode;
            return resultCode5;
        }
        finally {
            pool.close();
        }
    }

    @Nullable
    private ASN1OctetString getEncryptionPassphraseForExtOpProcessing() throws LDAPException {
        if (!this.encryptArg.isPresent()) {
            return null;
        }
        if (this.passphraseFileArg.isPresent()) {
            File passphraseFile = this.passphraseFileArg.getValue();
            if (this.generatePassphraseArg.isPresent()) {
                byte[] randomBytes = new byte[64];
                ThreadLocalSecureRandom.get().nextBytes(randomBytes);
                String passphrase = Base64.urlEncode(randomBytes, false);
                try (PrintWriter writer = new PrintWriter(passphraseFile);){
                    writer.println(passphrase);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_CSD_CANNOT_WRITE_GENERATED_PASSPHRASE.get(passphraseFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
                return new ASN1OctetString(passphrase);
            }
            try {
                char[] passphrase = this.getPasswordFileReader().readPassword(passphraseFile);
                return new ASN1OctetString(new String(passphrase));
            }
            catch (Exception e) {
                Debug.debugException(e);
                ResultCode resultCode = ResultCode.LOCAL_ERROR;
                if (e instanceof LDAPException) {
                    resultCode = ((LDAPException)e).getResultCode();
                }
                throw new LDAPException(resultCode, ToolMessages.ERR_CSD_CANNOT_READ_PASSPHRASE.get(passphraseFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        try {
            while (true) {
                this.getOut().print(ToolMessages.INFO_CSD_PASSPHRASE_INITIAL_PROMPT.get());
                byte[] passphraseBytes = PasswordReader.readPassword();
                this.getOut().print(ToolMessages.INFO_CSD_PASSPHRASE_CONFIRM_PROMPT.get());
                byte[] confirmBytes = PasswordReader.readPassword();
                if (Arrays.equals(passphraseBytes, confirmBytes)) {
                    return new ASN1OctetString(passphraseBytes);
                }
                this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_CSD_PASSPHRASE_MISMATCH.get());
                this.err(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_CSD_PASSPHRASE_PROMPT_READ_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private ResultCode doLocalProcessing() {
        Method doMainMethod;
        ArrayList<String> argList = new ArrayList<String>(20);
        if (this.outputPathArg.isPresent()) {
            argList.add("--outputPath");
            argList.add(this.outputPathArg.getValue().getAbsolutePath());
        }
        if (this.noLDAPArg.isPresent()) {
            argList.add("--noLdap");
        }
        if (this.pidArg.isPresent()) {
            for (Integer pid : this.pidArg.getValues()) {
                argList.add("--pid");
                argList.add(pid.toString());
            }
        }
        if (this.sequentialArg.isPresent()) {
            argList.add("--sequential");
        }
        if (this.reportCountArg.isPresent()) {
            argList.add("--reportCount");
            argList.add(this.reportCountArg.getValue().toString());
        }
        if (this.reportIntervalSecondsArg.isPresent()) {
            argList.add("--reportInterval");
            argList.add(this.reportIntervalSecondsArg.getValue().toString());
        }
        if (this.jstackCountArg.isPresent()) {
            argList.add("--maxJstacks");
            argList.add(this.jstackCountArg.getValue().toString());
        }
        if (this.collectExpensiveDataArg.isPresent()) {
            argList.add("--collectExpensiveData");
        }
        if (this.collectReplicationStateDumpArg.isPresent()) {
            argList.add("--collectReplicationStateDump");
        }
        if (this.commentArg.isPresent()) {
            argList.add("--comment");
            argList.add(this.commentArg.getValue());
        }
        if (this.includeBinaryFilesArg.isPresent()) {
            argList.add("--includeBinaryFiles");
        }
        if (this.securityLevelArg.isPresent()) {
            argList.add("--securityLevel");
            argList.add(this.securityLevelArg.getValue());
        }
        if (this.encryptArg.isPresent()) {
            argList.add("--encrypt");
        }
        if (this.passphraseFileArg.isPresent()) {
            argList.add("--passphraseFile");
            argList.add(this.passphraseFileArg.getValue().getAbsolutePath());
        }
        if (this.generatePassphraseArg.isPresent()) {
            argList.add("--generatePassphrase");
        }
        if (this.decryptArg.isPresent()) {
            argList.add("--decrypt");
            argList.add(this.decryptArg.getValue().getAbsolutePath());
        }
        if (this.logTimeRangeArg.isPresent()) {
            ObjectPair<Date, Date> timeRange;
            try {
                timeRange = CollectSupportData.parseTimeRange(this.logTimeRangeArg.getValue(), false);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                return e.getResultCode();
            }
            if (timeRange == null) {
                argList.add("--timeRange");
                argList.add(this.logTimeRangeArg.getValue());
            } else {
                Date startTime = timeRange.getFirst();
                Date endTime = timeRange.getSecond();
                if (endTime == null) {
                    endTime = new Date(Math.max(System.currentTimeMillis(), startTime.getTime()));
                }
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(SERVER_LOG_TIMESTAMP_FORMAT_WITH_MILLIS);
                argList.add("--timeRange");
                argList.add(timestampFormatter.format(startTime) + ',' + timestampFormatter.format(endTime));
            }
        }
        if (this.logDurationArg.isPresent()) {
            argList.add("--duration");
            argList.add(DurationArgument.nanosToDuration(this.logDurationArg.getValue(TimeUnit.NANOSECONDS)));
        }
        if (this.logFileHeadCollectionSizeKBArg.isPresent()) {
            argList.add("--logFileHeadCollectionSizeKB");
            argList.add(String.valueOf(this.logFileHeadCollectionSizeKBArg.getValue()));
        }
        if (this.logFileTailCollectionSizeKBArg.isPresent()) {
            argList.add("--logFileTailCollectionSizeKB");
            argList.add(String.valueOf(this.logFileTailCollectionSizeKBArg.getValue()));
        }
        if (this.archiveExtensionSourceArg.isPresent()) {
            argList.add("--archiveExtensionSource");
        }
        if (this.noPromptArg.isPresent()) {
            argList.add("--no-prompt");
        }
        if (this.scriptFriendlyArg.isPresent()) {
            argList.add("--script-friendly");
        }
        for (String argumentIdentifier : Arrays.asList("hostname", "port", "bindDN", "bindPassword", "bindPasswordFile", "useSSL", "useStartTLS", "trustAll", "keyStorePath", "keyStorePassword", "keyStorePasswordFile", "keyStoreFormat", "trustStorePath", "trustStorePassword", "trustStorePasswordFile", "trustStoreFormat", "certNickname", "saslOption", "propertiesFilePath", "noPropertiesFile")) {
            Argument arg = this.parser.getNamedArgument(argumentIdentifier);
            if (arg.getNumOccurrences() <= 0) continue;
            for (String value : arg.getValueStringRepresentations(false)) {
                argList.add("--" + argumentIdentifier);
                if (!arg.takesValue()) continue;
                argList.add(value);
            }
        }
        if (this.dryRunArg.isPresent()) {
            String message = ToolMessages.INFO_CSD_LOCAL_MODE_DRY_RUN.get();
            this.wrapOut(0, WRAP_COLUMN, message);
            this.toolCompletionMessage.set(message);
            return ResultCode.NO_OPERATION;
        }
        try {
            Class<?> csdToolClass = Class.forName(SERVER_CSD_TOOL_CLASS);
            doMainMethod = csdToolClass.getMethod("doMain", Boolean.TYPE, OutputStream.class, OutputStream.class, String[].class);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            String message = ToolMessages.ERR_CSD_SERVER_CODE_NOT_AVAILABLE.get();
            this.wrapErr(0, WRAP_COLUMN, message);
            this.toolCompletionMessage.set(message);
            return ResultCode.NOT_SUPPORTED;
        }
        String[] argArray = new String[argList.size()];
        argList.toArray(argArray);
        try {
            Object doMainMethodReturnValue = doMainMethod.invoke(null, true, this.getOut(), this.getErr(), argArray);
            int exitCode = (Integer)doMainMethodReturnValue;
            return ResultCode.valueOf(exitCode);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            String message = ToolMessages.ERR_CSD_INVOKE_ERROR.get(StaticUtils.getExceptionMessage(t));
            this.wrapErr(0, WRAP_COLUMN, message);
            this.toolCompletionMessage.set(message);
            return ResultCode.LOCAL_ERROR;
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(3));
        examples.put(new String[]{"--bindDN", "uid=admin,dc=example,dc=com", "--bindPasswordFile", "admin-pw.txt"}, ToolMessages.INFO_CSD_EXAMPLE_1.get());
        examples.put(new String[]{"--useRemoteServer", "--hostname", "ds.example.com", "--port", "636", "--useSSL", "--trustStorePath", "config/truststore", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPasswordFile", "admin-pw.txt", "--collectExpensiveData", "--collectReplicationStateDump", "--securityLevel", "maximum", "--logDuration", "10 minutes", "--encrypt", "--passphraseFile", "encryption-passphrase.txt", "--generatePassphrase", "--outputPath", "csd.zip"}, ToolMessages.INFO_CSD_EXAMPLE_2.get());
        examples.put(new String[]{"--decrypt", "support-data-ds-inst1-" + StaticUtils.encodeGeneralizedTime(new Date()) + "-zip-encrypted", "--passphraseFile", "encryption-passphrase.txt"}, ToolMessages.INFO_CSD_EXAMPLE_3.get());
        return examples;
    }
}

