/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.HealthCheckState;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPExternalServerMonitorEntry
extends MonitorEntry {
    @NotNull
    protected static final String LDAP_EXTERNAL_SERVER_MONITOR_OC = "ds-ldap-external-server-monitor-entry";
    @NotNull
    private static final String ATTR_ADD_ATTEMPTS = "add-attempts";
    @NotNull
    private static final String ATTR_ADD_FAILURES = "add-failures";
    @NotNull
    private static final String ATTR_ADD_SUCCESSES = "add-successes";
    @NotNull
    private static final String ATTR_BIND_ATTEMPTS = "bind-attempts";
    @NotNull
    private static final String ATTR_BIND_FAILURES = "bind-failures";
    @NotNull
    private static final String ATTR_BIND_SUCCESSES = "bind-successes";
    @NotNull
    private static final String ATTR_COMMUNICATION_SECURITY = "communication-security";
    @NotNull
    private static final String ATTR_COMPARE_ATTEMPTS = "compare-attempts";
    @NotNull
    private static final String ATTR_COMPARE_FAILURES = "compare-failures";
    @NotNull
    private static final String ATTR_COMPARE_SUCCESSES = "compare-successes";
    @NotNull
    private static final String ATTR_DELETE_ATTEMPTS = "delete-attempts";
    @NotNull
    private static final String ATTR_DELETE_FAILURES = "delete-failures";
    @NotNull
    private static final String ATTR_DELETE_SUCCESSES = "delete-successes";
    @NotNull
    private static final String ATTR_HEALTH_CHECK_MESSAGE = "health-check-message";
    @NotNull
    private static final String ATTR_HEALTH_CHECK_STATE = "health-check-state";
    @NotNull
    private static final String ATTR_HEALTH_CHECK_SCORE = "health-check-score";
    @NotNull
    private static final String ATTR_HEALTH_CHECK_UPDATE_TIME = "health-check-update-time";
    @NotNull
    private static final String ATTR_LOAD_BALANCING_ALGORITHM_DN = "load-balancing-algorithm";
    @NotNull
    private static final String ATTR_MODIFY_ATTEMPTS = "modify-attempts";
    @NotNull
    private static final String ATTR_MODIFY_FAILURES = "modify-failures";
    @NotNull
    private static final String ATTR_MODIFY_SUCCESSES = "modify-successes";
    @NotNull
    private static final String ATTR_MODIFY_DN_ATTEMPTS = "modify-dn-attempts";
    @NotNull
    private static final String ATTR_MODIFY_DN_FAILURES = "modify-dn-failures";
    @NotNull
    private static final String ATTR_MODIFY_DN_SUCCESSES = "modify-dn-successes";
    @NotNull
    private static final String ATTR_SEARCH_ATTEMPTS = "search-attempts";
    @NotNull
    private static final String ATTR_SEARCH_FAILURES = "search-failures";
    @NotNull
    private static final String ATTR_SEARCH_SUCCESSES = "search-successes";
    @NotNull
    private static final String ATTR_SERVER_ADDRESS = "server-address";
    @NotNull
    private static final String ATTR_SERVER_PORT = "server-port";
    @NotNull
    private static final String ATTR_PREFIX_BIND_POOL = "bind-";
    @NotNull
    private static final String ATTR_PREFIX_COMMON_POOL = "common-";
    @NotNull
    private static final String ATTR_PREFIX_NONBIND_POOL = "non-bind-";
    @NotNull
    private static final String ATTR_SUFFIX_AVAILABLE_CONNS = "pool-available-connections";
    @NotNull
    private static final String ATTR_SUFFIX_CLOSED_DEFUNCT = "pool-num-closed-defunct";
    @NotNull
    private static final String ATTR_SUFFIX_CLOSED_EXPIRED = "pool-num-closed-expired";
    @NotNull
    private static final String ATTR_SUFFIX_CLOSED_UNNEEDED = "pool-num-closed-unneeded";
    @NotNull
    private static final String ATTR_SUFFIX_FAILED_CHECKOUTS = "pool-num-failed-checkouts";
    @NotNull
    private static final String ATTR_SUFFIX_FAILED_CONNECTS = "pool-num-failed-connection-attempts";
    @NotNull
    private static final String ATTR_SUFFIX_MAX_AVAILABLE_CONNS = "pool-max-available-connections";
    @NotNull
    private static final String ATTR_SUFFIX_RELEASED_VALID = "pool-num-released-valid";
    @NotNull
    private static final String ATTR_SUFFIX_SUCCESSFUL_CHECKOUTS = "pool-num-successful-checkouts";
    @NotNull
    private static final String ATTR_SUFFIX_SUCCESSFUL_CHECKOUTS_AFTER_WAITING = "pool-num-successful-checkouts-after-waiting";
    @NotNull
    private static final String ATTR_SUFFIX_SUCCESSFUL_CHECKOUTS_NEW_CONN = "pool-num-successful-checkouts-new-connection";
    @NotNull
    private static final String ATTR_SUFFIX_SUCCESSFUL_CHECKOUTS_WITHOUT_WAITING = "pool-num-successful-checkouts-without-waiting";
    @NotNull
    private static final String ATTR_SUFFIX_SUCCESSFUL_CONNECTS = "pool-num-successful-connection-attempts";
    private static final long serialVersionUID = 6054649631882735072L;
    @Nullable
    private final Date healthCheckUpdateTime;
    @Nullable
    private final HealthCheckState healthCheckState;
    @NotNull
    private final List<String> healthCheckMessages;
    @Nullable
    private final Long addAttempts;
    @Nullable
    private final Long addFailures;
    @Nullable
    private final Long addSuccesses;
    @Nullable
    private final Long bindAttempts;
    @Nullable
    private final Long bindFailures;
    @Nullable
    private final Long bindPoolAvailableConnections;
    @Nullable
    private final Long bindPoolMaxAvailableConnections;
    @Nullable
    private final Long bindPoolNumClosedDefunct;
    @Nullable
    private final Long bindPoolNumClosedExpired;
    @Nullable
    private final Long bindPoolNumClosedUnneeded;
    @Nullable
    private final Long bindPoolNumFailedCheckouts;
    @Nullable
    private final Long bindPoolNumFailedConnectionAttempts;
    @Nullable
    private final Long bindPoolNumReleasedValid;
    @Nullable
    private final Long bindPoolNumSuccessfulCheckouts;
    @Nullable
    private final Long bindPoolNumSuccessfulCheckoutsAfterWaiting;
    @Nullable
    private final Long bindPoolNumSuccessfulCheckoutsNewConnection;
    @Nullable
    private final Long bindPoolNumSuccessfulCheckoutsWithoutWaiting;
    @Nullable
    private final Long bindPoolNumSuccessfulConnectionAttempts;
    @Nullable
    private final Long bindSuccesses;
    @Nullable
    private final Long commonPoolAvailableConnections;
    @Nullable
    private final Long commonPoolMaxAvailableConnections;
    @Nullable
    private final Long commonPoolNumClosedDefunct;
    @Nullable
    private final Long commonPoolNumClosedExpired;
    @Nullable
    private final Long commonPoolNumClosedUnneeded;
    @Nullable
    private final Long commonPoolNumFailedCheckouts;
    @Nullable
    private final Long commonPoolNumFailedConnectionAttempts;
    @Nullable
    private final Long commonPoolNumReleasedValid;
    @Nullable
    private final Long commonPoolNumSuccessfulCheckouts;
    @Nullable
    private final Long commonPoolNumSuccessfulCheckoutsAfterWaiting;
    @Nullable
    private final Long commonPoolNumSuccessfulCheckoutsNewConnection;
    @Nullable
    private final Long commonPoolNumSuccessfulCheckoutsWithoutWaiting;
    @Nullable
    private final Long commonPoolNumSuccessfulConnectionAttempts;
    @Nullable
    private final Long compareAttempts;
    @Nullable
    private final Long compareFailures;
    @Nullable
    private final Long compareSuccesses;
    @Nullable
    private final Long deleteAttempts;
    @Nullable
    private final Long deleteFailures;
    @Nullable
    private final Long deleteSuccesses;
    @Nullable
    private final Long healthCheckScore;
    @Nullable
    private final Long modifyAttempts;
    @Nullable
    private final Long modifyFailures;
    @Nullable
    private final Long modifySuccesses;
    @Nullable
    private final Long modifyDNAttempts;
    @Nullable
    private final Long modifyDNFailures;
    @Nullable
    private final Long modifyDNSuccesses;
    @Nullable
    private final Long nonBindPoolAvailableConnections;
    @Nullable
    private final Long nonBindPoolMaxAvailableConnections;
    @Nullable
    private final Long nonBindPoolNumClosedDefunct;
    @Nullable
    private final Long nonBindPoolNumClosedExpired;
    @Nullable
    private final Long nonBindPoolNumClosedUnneeded;
    @Nullable
    private final Long nonBindPoolNumFailedCheckouts;
    @Nullable
    private final Long nonBindPoolNumFailedConnectionAttempts;
    @Nullable
    private final Long nonBindPoolNumReleasedValid;
    @Nullable
    private final Long nonBindPoolNumSuccessfulCheckouts;
    @Nullable
    private final Long nonBindPoolNumSuccessfulCheckoutsAfterWaiting;
    @Nullable
    private final Long nonBindPoolNumSuccessfulCheckoutsNewConnection;
    @Nullable
    private final Long nonBindPoolNumSuccessfulCheckoutsWithoutWaiting;
    @Nullable
    private final Long nonBindPoolNumSuccessfulConnectionAttempts;
    @Nullable
    private final Long searchAttempts;
    @Nullable
    private final Long searchFailures;
    @Nullable
    private final Long searchSuccesses;
    @Nullable
    private final Long serverPort;
    @Nullable
    private final String communicationSecurity;
    @Nullable
    private final String loadBalancingAlgorithmDN;
    @Nullable
    private final String serverAddress = this.getString("server-address");

    public LDAPExternalServerMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.serverPort = this.getLong(ATTR_SERVER_PORT);
        this.communicationSecurity = this.getString(ATTR_COMMUNICATION_SECURITY);
        this.loadBalancingAlgorithmDN = this.getString(ATTR_LOAD_BALANCING_ALGORITHM_DN);
        this.healthCheckScore = this.getLong(ATTR_HEALTH_CHECK_SCORE);
        this.healthCheckMessages = this.getStrings(ATTR_HEALTH_CHECK_MESSAGE);
        this.healthCheckUpdateTime = this.getDate(ATTR_HEALTH_CHECK_UPDATE_TIME);
        this.addAttempts = this.getLong(ATTR_ADD_ATTEMPTS);
        this.addFailures = this.getLong(ATTR_ADD_FAILURES);
        this.addSuccesses = this.getLong(ATTR_ADD_SUCCESSES);
        this.bindAttempts = this.getLong(ATTR_BIND_ATTEMPTS);
        this.bindFailures = this.getLong(ATTR_BIND_FAILURES);
        this.bindSuccesses = this.getLong(ATTR_BIND_SUCCESSES);
        this.compareAttempts = this.getLong(ATTR_COMPARE_ATTEMPTS);
        this.compareFailures = this.getLong(ATTR_COMPARE_FAILURES);
        this.compareSuccesses = this.getLong(ATTR_COMPARE_SUCCESSES);
        this.deleteAttempts = this.getLong(ATTR_DELETE_ATTEMPTS);
        this.deleteFailures = this.getLong(ATTR_DELETE_FAILURES);
        this.deleteSuccesses = this.getLong(ATTR_DELETE_SUCCESSES);
        this.modifyAttempts = this.getLong(ATTR_MODIFY_ATTEMPTS);
        this.modifyFailures = this.getLong(ATTR_MODIFY_FAILURES);
        this.modifySuccesses = this.getLong(ATTR_MODIFY_SUCCESSES);
        this.modifyDNAttempts = this.getLong(ATTR_MODIFY_DN_ATTEMPTS);
        this.modifyDNFailures = this.getLong(ATTR_MODIFY_DN_FAILURES);
        this.modifyDNSuccesses = this.getLong(ATTR_MODIFY_DN_SUCCESSES);
        this.searchAttempts = this.getLong(ATTR_SEARCH_ATTEMPTS);
        this.searchFailures = this.getLong(ATTR_SEARCH_FAILURES);
        this.searchSuccesses = this.getLong(ATTR_SEARCH_SUCCESSES);
        this.bindPoolAvailableConnections = this.getLong("bind-pool-available-connections");
        this.bindPoolMaxAvailableConnections = this.getLong("bind-pool-max-available-connections");
        this.bindPoolNumSuccessfulConnectionAttempts = this.getLong("bind-pool-num-successful-connection-attempts");
        this.bindPoolNumFailedConnectionAttempts = this.getLong("bind-pool-num-failed-connection-attempts");
        this.bindPoolNumClosedDefunct = this.getLong("bind-pool-num-closed-defunct");
        this.bindPoolNumClosedExpired = this.getLong("bind-pool-num-closed-expired");
        this.bindPoolNumClosedUnneeded = this.getLong("bind-pool-num-closed-unneeded");
        this.bindPoolNumSuccessfulCheckouts = this.getLong("bind-pool-num-successful-checkouts");
        this.bindPoolNumSuccessfulCheckoutsWithoutWaiting = this.getLong("bind-pool-num-successful-checkouts-without-waiting");
        this.bindPoolNumSuccessfulCheckoutsAfterWaiting = this.getLong("bind-pool-num-successful-checkouts-after-waiting");
        this.bindPoolNumSuccessfulCheckoutsNewConnection = this.getLong("bind-pool-num-successful-checkouts-new-connection");
        this.bindPoolNumFailedCheckouts = this.getLong("bind-pool-num-failed-checkouts");
        this.bindPoolNumReleasedValid = this.getLong("bind-pool-num-released-valid");
        this.commonPoolAvailableConnections = this.getLong("common-pool-available-connections");
        this.commonPoolMaxAvailableConnections = this.getLong("common-pool-max-available-connections");
        this.commonPoolNumSuccessfulConnectionAttempts = this.getLong("common-pool-num-successful-connection-attempts");
        this.commonPoolNumFailedConnectionAttempts = this.getLong("common-pool-num-failed-connection-attempts");
        this.commonPoolNumClosedDefunct = this.getLong("common-pool-num-closed-defunct");
        this.commonPoolNumClosedExpired = this.getLong("common-pool-num-closed-expired");
        this.commonPoolNumClosedUnneeded = this.getLong("common-pool-num-closed-unneeded");
        this.commonPoolNumSuccessfulCheckouts = this.getLong("common-pool-num-successful-checkouts");
        this.commonPoolNumSuccessfulCheckoutsWithoutWaiting = this.getLong("common-pool-num-successful-checkouts-without-waiting");
        this.commonPoolNumSuccessfulCheckoutsAfterWaiting = this.getLong("common-pool-num-successful-checkouts-after-waiting");
        this.commonPoolNumSuccessfulCheckoutsNewConnection = this.getLong("common-pool-num-successful-checkouts-new-connection");
        this.commonPoolNumFailedCheckouts = this.getLong("common-pool-num-failed-checkouts");
        this.commonPoolNumReleasedValid = this.getLong("common-pool-num-released-valid");
        this.nonBindPoolAvailableConnections = this.getLong("non-bind-pool-available-connections");
        this.nonBindPoolMaxAvailableConnections = this.getLong("non-bind-pool-max-available-connections");
        this.nonBindPoolNumSuccessfulConnectionAttempts = this.getLong("non-bind-pool-num-successful-connection-attempts");
        this.nonBindPoolNumFailedConnectionAttempts = this.getLong("non-bind-pool-num-failed-connection-attempts");
        this.nonBindPoolNumClosedDefunct = this.getLong("non-bind-pool-num-closed-defunct");
        this.nonBindPoolNumClosedExpired = this.getLong("non-bind-pool-num-closed-expired");
        this.nonBindPoolNumClosedUnneeded = this.getLong("non-bind-pool-num-closed-unneeded");
        this.nonBindPoolNumSuccessfulCheckouts = this.getLong("non-bind-pool-num-successful-checkouts");
        this.nonBindPoolNumSuccessfulCheckoutsWithoutWaiting = this.getLong("non-bind-pool-num-successful-checkouts-without-waiting");
        this.nonBindPoolNumSuccessfulCheckoutsAfterWaiting = this.getLong("non-bind-pool-num-successful-checkouts-after-waiting");
        this.nonBindPoolNumSuccessfulCheckoutsNewConnection = this.getLong("non-bind-pool-num-successful-checkouts-new-connection");
        this.nonBindPoolNumFailedCheckouts = this.getLong("non-bind-pool-num-failed-checkouts");
        this.nonBindPoolNumReleasedValid = this.getLong("non-bind-pool-num-released-valid");
        String hcStateStr = this.getString(ATTR_HEALTH_CHECK_STATE);
        this.healthCheckState = hcStateStr == null ? null : HealthCheckState.forName(hcStateStr);
    }

    @Nullable
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Nullable
    public Long getServerPort() {
        return this.serverPort;
    }

    @Nullable
    public String getCommunicationSecurity() {
        return this.communicationSecurity;
    }

    @Nullable
    public String getLoadBalancingAlgorithmDN() {
        return this.loadBalancingAlgorithmDN;
    }

    @Nullable
    public HealthCheckState getHealthCheckState() {
        return this.healthCheckState;
    }

    @Nullable
    public Long getHealthCheckScore() {
        return this.healthCheckScore;
    }

    @NotNull
    public List<String> getHealthCheckMessages() {
        return this.healthCheckMessages;
    }

    @Nullable
    public Date getHealthCheckUpdateTime() {
        return this.healthCheckUpdateTime;
    }

    @Nullable
    public Long getAddAttempts() {
        return this.addAttempts;
    }

    @Nullable
    public Long getAddFailures() {
        return this.addFailures;
    }

    @Nullable
    public Long getAddSuccesses() {
        return this.addSuccesses;
    }

    @Nullable
    public Long getBindAttempts() {
        return this.bindAttempts;
    }

    @Nullable
    public Long getBindFailures() {
        return this.bindFailures;
    }

    @Nullable
    public Long getBindSuccesses() {
        return this.bindSuccesses;
    }

    @Nullable
    public Long getCompareAttempts() {
        return this.compareAttempts;
    }

    @Nullable
    public Long getCompareFailures() {
        return this.compareFailures;
    }

    @Nullable
    public Long getCompareSuccesses() {
        return this.compareSuccesses;
    }

    @Nullable
    public Long getDeleteAttempts() {
        return this.deleteAttempts;
    }

    @Nullable
    public Long getDeleteFailures() {
        return this.deleteFailures;
    }

    @Nullable
    public Long getDeleteSuccesses() {
        return this.deleteSuccesses;
    }

    @Nullable
    public Long getModifyAttempts() {
        return this.modifyAttempts;
    }

    @Nullable
    public Long getModifyFailures() {
        return this.modifyFailures;
    }

    @Nullable
    public Long getModifySuccesses() {
        return this.modifySuccesses;
    }

    @Nullable
    public Long getModifyDNAttempts() {
        return this.modifyDNAttempts;
    }

    @Nullable
    public Long getModifyDNFailures() {
        return this.modifyDNFailures;
    }

    @Nullable
    public Long getModifyDNSuccesses() {
        return this.modifyDNSuccesses;
    }

    @Nullable
    public Long getSearchAttempts() {
        return this.searchAttempts;
    }

    @Nullable
    public Long getSearchFailures() {
        return this.searchFailures;
    }

    @Nullable
    public Long getSearchSuccesses() {
        return this.searchSuccesses;
    }

    @Nullable
    public Long getCommonPoolAvailableConnections() {
        return this.commonPoolAvailableConnections;
    }

    @Nullable
    public Long getCommonPoolMaxAvailableConnections() {
        return this.commonPoolMaxAvailableConnections;
    }

    @Nullable
    public Long getCommonPoolNumSuccessfulConnectionAttempts() {
        return this.commonPoolNumSuccessfulConnectionAttempts;
    }

    @Nullable
    public Long getCommonPoolNumFailedConnectionAttempts() {
        return this.commonPoolNumFailedConnectionAttempts;
    }

    @Nullable
    public Long getCommonPoolNumClosedDefunct() {
        return this.commonPoolNumClosedDefunct;
    }

    @Nullable
    public Long getCommonPoolNumClosedExpired() {
        return this.commonPoolNumClosedExpired;
    }

    @Nullable
    public Long getCommonPoolNumClosedUnneeded() {
        return this.commonPoolNumClosedUnneeded;
    }

    @Nullable
    public Long getCommonPoolTotalSuccessfulCheckouts() {
        return this.commonPoolNumSuccessfulCheckouts;
    }

    @Nullable
    public Long getCommonPoolNumSuccessfulCheckoutsWithoutWaiting() {
        return this.commonPoolNumSuccessfulCheckoutsWithoutWaiting;
    }

    @Nullable
    public Long getCommonPoolNumSuccessfulCheckoutsAfterWaiting() {
        return this.commonPoolNumSuccessfulCheckoutsAfterWaiting;
    }

    @Nullable
    public Long getCommonPoolNumSuccessfulCheckoutsNewConnection() {
        return this.commonPoolNumSuccessfulCheckoutsNewConnection;
    }

    @Nullable
    public Long getCommonPoolNumFailedCheckouts() {
        return this.commonPoolNumFailedCheckouts;
    }

    @Nullable
    public Long getCommonPoolNumReleasedValid() {
        return this.commonPoolNumReleasedValid;
    }

    @Nullable
    public Long getBindPoolAvailableConnections() {
        return this.bindPoolAvailableConnections;
    }

    @Nullable
    public Long getBindPoolMaxAvailableConnections() {
        return this.bindPoolMaxAvailableConnections;
    }

    @Nullable
    public Long getBindPoolNumSuccessfulConnectionAttempts() {
        return this.bindPoolNumSuccessfulConnectionAttempts;
    }

    @Nullable
    public Long getBindPoolNumFailedConnectionAttempts() {
        return this.bindPoolNumFailedConnectionAttempts;
    }

    @Nullable
    public Long getBindPoolNumClosedDefunct() {
        return this.bindPoolNumClosedDefunct;
    }

    @Nullable
    public Long getBindPoolNumClosedExpired() {
        return this.bindPoolNumClosedExpired;
    }

    @Nullable
    public Long getBindPoolNumClosedUnneeded() {
        return this.bindPoolNumClosedUnneeded;
    }

    @Nullable
    public Long getBindPoolTotalSuccessfulCheckouts() {
        return this.bindPoolNumSuccessfulCheckouts;
    }

    @Nullable
    public Long getBindPoolNumSuccessfulCheckoutsWithoutWaiting() {
        return this.bindPoolNumSuccessfulCheckoutsWithoutWaiting;
    }

    @Nullable
    public Long getBindPoolNumSuccessfulCheckoutsAfterWaiting() {
        return this.bindPoolNumSuccessfulCheckoutsAfterWaiting;
    }

    @Nullable
    public Long getBindPoolNumSuccessfulCheckoutsNewConnection() {
        return this.bindPoolNumSuccessfulCheckoutsNewConnection;
    }

    @Nullable
    public Long getBindPoolNumFailedCheckouts() {
        return this.bindPoolNumFailedCheckouts;
    }

    @Nullable
    public Long getBindPoolNumReleasedValid() {
        return this.bindPoolNumReleasedValid;
    }

    @Nullable
    public Long getNonBindPoolAvailableConnections() {
        return this.nonBindPoolAvailableConnections;
    }

    @Nullable
    public Long getNonBindPoolMaxAvailableConnections() {
        return this.nonBindPoolMaxAvailableConnections;
    }

    @Nullable
    public Long getNonBindPoolNumSuccessfulConnectionAttempts() {
        return this.nonBindPoolNumSuccessfulConnectionAttempts;
    }

    @Nullable
    public Long getNonBindPoolNumFailedConnectionAttempts() {
        return this.nonBindPoolNumFailedConnectionAttempts;
    }

    @Nullable
    public Long getNonBindPoolNumClosedDefunct() {
        return this.nonBindPoolNumClosedDefunct;
    }

    @Nullable
    public Long getNonBindPoolNumClosedExpired() {
        return this.nonBindPoolNumClosedExpired;
    }

    @Nullable
    public Long getNonBindPoolNumClosedUnneeded() {
        return this.nonBindPoolNumClosedUnneeded;
    }

    @Nullable
    public Long getNonBindPoolTotalSuccessfulCheckouts() {
        return this.nonBindPoolNumSuccessfulCheckouts;
    }

    @Nullable
    public Long getNonBindPoolNumSuccessfulCheckoutsWithoutWaiting() {
        return this.nonBindPoolNumSuccessfulCheckoutsWithoutWaiting;
    }

    @Nullable
    public Long getNonBindPoolNumSuccessfulCheckoutsAfterWaiting() {
        return this.nonBindPoolNumSuccessfulCheckoutsAfterWaiting;
    }

    @Nullable
    public Long getNonBindPoolNumSuccessfulCheckoutsNewConnection() {
        return this.nonBindPoolNumSuccessfulCheckoutsNewConnection;
    }

    @Nullable
    public Long getNonBindPoolNumFailedCheckouts() {
        return this.nonBindPoolNumFailedCheckouts;
    }

    @Nullable
    public Long getNonBindPoolNumReleasedValid() {
        return this.nonBindPoolNumReleasedValid;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_LDAP_EXT_SERVER_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_LDAP_EXT_SERVER_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(50));
        if (this.serverAddress != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SERVER_ADDRESS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_SERVER_ADDRESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_SERVER_ADDRESS.get(), this.serverAddress);
        }
        if (this.serverPort != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SERVER_PORT, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_SERVER_PORT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_SERVER_PORT.get(), this.serverPort);
        }
        if (this.communicationSecurity != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_COMMUNICATION_SECURITY, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMUNICATION_SECURITY.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMUNICATION_SECURITY.get(), this.communicationSecurity);
        }
        if (this.loadBalancingAlgorithmDN != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_LOAD_BALANCING_ALGORITHM_DN, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_LOAD_BALANCING_ALGORITHM_DN.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_LOAD_BALANCING_ALGORITHM_DN.get(), this.loadBalancingAlgorithmDN);
        }
        if (this.healthCheckState != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_HEALTH_CHECK_STATE, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_HEALTH_CHECK_STATE.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_HEALTH_CHECK_STATE.get(), this.healthCheckState.getName());
        }
        if (this.healthCheckScore != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_HEALTH_CHECK_SCORE, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_HEALTH_CHECK_SCORE.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_HEALTH_CHECK_SCORE.get(), this.healthCheckScore);
        }
        if (this.healthCheckMessages != null && !this.healthCheckMessages.isEmpty()) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_HEALTH_CHECK_MESSAGE, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_HEALTH_CHECK_MESSAGE.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_HEALTH_CHECK_MESSAGE.get(), this.healthCheckMessages);
        }
        if (this.healthCheckUpdateTime != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_HEALTH_CHECK_UPDATE_TIME, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_HEALTH_CHECK_UPDATE_TIME.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_HEALTH_CHECK_UPDATE_TIME.get(), this.healthCheckUpdateTime);
        }
        if (this.commonPoolAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_AVAILABLE_CONNS.get(), this.commonPoolAvailableConnections);
        }
        if (this.commonPoolMaxAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-max-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_MAX_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_MAX_AVAILABLE_CONNS.get(), this.commonPoolMaxAvailableConnections);
        }
        if (this.commonPoolNumSuccessfulConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-successful-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CONNECT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CONNECT_SUCCESS.get(), this.commonPoolNumSuccessfulConnectionAttempts);
        }
        if (this.commonPoolNumFailedConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-failed-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CONNECT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CONNECT_FAILED.get(), this.commonPoolNumFailedConnectionAttempts);
        }
        if (this.commonPoolNumClosedDefunct != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-closed-defunct", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CLOSED_DEFUNCT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CLOSED_DEFUNCT.get(), this.commonPoolNumClosedDefunct);
        }
        if (this.commonPoolNumClosedExpired != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-closed-expired", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CLOSED_EXPIRED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CLOSED_EXPIRED.get(), this.commonPoolNumClosedExpired);
        }
        if (this.commonPoolNumClosedUnneeded != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-closed-unneeded", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CLOSED_UNNEEDED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CLOSED_UNNEEDED.get(), this.commonPoolNumClosedUnneeded);
        }
        if (this.commonPoolNumSuccessfulCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-successful-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CHECKOUT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CHECKOUT_SUCCESS.get(), this.commonPoolNumSuccessfulCheckouts);
        }
        if (this.commonPoolNumSuccessfulCheckoutsWithoutWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-successful-checkouts-without-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CHECKOUT_NO_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CHECKOUT_NO_WAIT.get(), this.commonPoolNumSuccessfulCheckoutsWithoutWaiting);
        }
        if (this.commonPoolNumSuccessfulCheckoutsAfterWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-successful-checkouts-after-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CHECKOUT_WITH_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CHECKOUT_WITH_WAIT.get(), this.commonPoolNumSuccessfulCheckoutsAfterWaiting);
        }
        if (this.commonPoolNumSuccessfulCheckoutsNewConnection != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-successful-checkouts-new-connection", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CHECKOUT_NEW_CONN.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CHECKOUT_NEW_CONN.get(), this.commonPoolNumSuccessfulCheckoutsNewConnection);
        }
        if (this.commonPoolNumFailedCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-failed-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_CHECKOUT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_CHECKOUT_FAILED.get(), this.commonPoolNumFailedCheckouts);
        }
        if (this.commonPoolNumReleasedValid != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "common-pool-num-released-valid", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMMON_RELEASED_VALID.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMMON_RELEASED_VALID.get(), this.commonPoolNumReleasedValid);
        }
        if (this.bindPoolAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_AVAILABLE_CONNS.get(), this.bindPoolAvailableConnections);
        }
        if (this.bindPoolMaxAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-max-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_MAX_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_MAX_AVAILABLE_CONNS.get(), this.bindPoolMaxAvailableConnections);
        }
        if (this.bindPoolNumSuccessfulConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-successful-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CONNECT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CONNECT_SUCCESS.get(), this.bindPoolNumSuccessfulConnectionAttempts);
        }
        if (this.bindPoolNumFailedConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-failed-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CONNECT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CONNECT_FAILED.get(), this.bindPoolNumFailedConnectionAttempts);
        }
        if (this.bindPoolNumClosedDefunct != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-closed-defunct", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CLOSED_DEFUNCT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CLOSED_DEFUNCT.get(), this.bindPoolNumClosedDefunct);
        }
        if (this.bindPoolNumClosedExpired != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-closed-expired", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CLOSED_EXPIRED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CLOSED_EXPIRED.get(), this.bindPoolNumClosedExpired);
        }
        if (this.bindPoolNumClosedUnneeded != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-closed-unneeded", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CLOSED_UNNEEDED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CLOSED_UNNEEDED.get(), this.bindPoolNumClosedUnneeded);
        }
        if (this.bindPoolNumSuccessfulCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-successful-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CHECKOUT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CHECKOUT_SUCCESS.get(), this.bindPoolNumSuccessfulCheckouts);
        }
        if (this.bindPoolNumSuccessfulCheckoutsWithoutWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-successful-checkouts-without-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CHECKOUT_NO_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CHECKOUT_NO_WAIT.get(), this.bindPoolNumSuccessfulCheckoutsWithoutWaiting);
        }
        if (this.bindPoolNumSuccessfulCheckoutsAfterWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-successful-checkouts-after-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CHECKOUT_WITH_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CHECKOUT_WITH_WAIT.get(), this.bindPoolNumSuccessfulCheckoutsAfterWaiting);
        }
        if (this.bindPoolNumSuccessfulCheckoutsNewConnection != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-successful-checkouts-new-connection", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CHECKOUT_NEW_CONN.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CHECKOUT_NEW_CONN.get(), this.bindPoolNumSuccessfulCheckoutsNewConnection);
        }
        if (this.bindPoolNumFailedCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-failed-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_CHECKOUT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_CHECKOUT_FAILED.get(), this.bindPoolNumFailedCheckouts);
        }
        if (this.bindPoolNumReleasedValid != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "bind-pool-num-released-valid", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_RELEASED_VALID.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_RELEASED_VALID.get(), this.bindPoolNumReleasedValid);
        }
        if (this.nonBindPoolAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_AVAILABLE_CONNS.get(), this.nonBindPoolAvailableConnections);
        }
        if (this.nonBindPoolMaxAvailableConnections != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-max-available-connections", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_MAX_AVAILABLE_CONNS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_MAX_AVAILABLE_CONNS.get(), this.nonBindPoolMaxAvailableConnections);
        }
        if (this.nonBindPoolNumSuccessfulConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-successful-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CONNECT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CONNECT_SUCCESS.get(), this.nonBindPoolNumSuccessfulConnectionAttempts);
        }
        if (this.nonBindPoolNumFailedConnectionAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-failed-connection-attempts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CONNECT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CONNECT_FAILED.get(), this.nonBindPoolNumFailedConnectionAttempts);
        }
        if (this.nonBindPoolNumClosedDefunct != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-closed-defunct", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CLOSED_DEFUNCT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CLOSED_DEFUNCT.get(), this.nonBindPoolNumClosedDefunct);
        }
        if (this.nonBindPoolNumClosedExpired != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-closed-expired", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CLOSED_EXPIRED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CLOSED_EXPIRED.get(), this.nonBindPoolNumClosedExpired);
        }
        if (this.nonBindPoolNumClosedUnneeded != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-closed-unneeded", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CLOSED_UNNEEDED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CLOSED_UNNEEDED.get(), this.nonBindPoolNumClosedUnneeded);
        }
        if (this.nonBindPoolNumSuccessfulCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-successful-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CHECKOUT_SUCCESS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CHECKOUT_SUCCESS.get(), this.nonBindPoolNumSuccessfulCheckouts);
        }
        if (this.nonBindPoolNumSuccessfulCheckoutsWithoutWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-successful-checkouts-without-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CHECKOUT_NO_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CHECKOUT_NO_WAIT.get(), this.nonBindPoolNumSuccessfulCheckoutsWithoutWaiting);
        }
        if (this.nonBindPoolNumSuccessfulCheckoutsAfterWaiting != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-successful-checkouts-after-waiting", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CHECKOUT_WITH_WAIT.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CHECKOUT_WITH_WAIT.get(), this.nonBindPoolNumSuccessfulCheckoutsAfterWaiting);
        }
        if (this.nonBindPoolNumSuccessfulCheckoutsNewConnection != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-successful-checkouts-new-connection", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CHECKOUT_NEW_CONN.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CHECKOUT_NEW_CONN.get(), this.nonBindPoolNumSuccessfulCheckoutsNewConnection);
        }
        if (this.nonBindPoolNumFailedCheckouts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-failed-checkouts", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_CHECKOUT_FAILED.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_CHECKOUT_FAILED.get(), this.nonBindPoolNumFailedCheckouts);
        }
        if (this.nonBindPoolNumReleasedValid != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, "non-bind-pool-num-released-valid", MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_NONBIND_RELEASED_VALID.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_NONBIND_RELEASED_VALID.get(), this.nonBindPoolNumReleasedValid);
        }
        if (this.addAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_ADD_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_ADD_ATTEMPTS.get(), this.addAttempts);
        }
        if (this.addFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_ADD_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_ADD_FAILURES.get(), this.addFailures);
        }
        if (this.addSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_ADD_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_ADD_SUCCESSES.get(), this.addSuccesses);
        }
        if (this.bindAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_ATTEMPTS.get(), this.bindAttempts);
        }
        if (this.bindFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_FAILURES.get(), this.bindFailures);
        }
        if (this.bindSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_BIND_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_BIND_SUCCESSES.get(), this.bindSuccesses);
        }
        if (this.compareAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMPARE_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMPARE_ATTEMPTS.get(), this.compareAttempts);
        }
        if (this.compareFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMPARE_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMPARE_FAILURES.get(), this.compareFailures);
        }
        if (this.compareSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_COMPARE_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_COMPARE_SUCCESSES.get(), this.compareSuccesses);
        }
        if (this.deleteAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_DELETE_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_DELETE_ATTEMPTS.get(), this.deleteAttempts);
        }
        if (this.deleteFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_DELETE_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_DELETE_FAILURES.get(), this.deleteFailures);
        }
        if (this.deleteSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_DELETE_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_DELETE_SUCCESSES.get(), this.deleteSuccesses);
        }
        if (this.modifyAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_ATTEMPTS.get(), this.modifyAttempts);
        }
        if (this.modifyFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_FAILURES.get(), this.modifyFailures);
        }
        if (this.modifySuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_SUCCESSES.get(), this.modifySuccesses);
        }
        if (this.modifyDNAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_DN_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_DN_ATTEMPTS.get(), this.modifyDNAttempts);
        }
        if (this.modifyDNFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_DN_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_DN_FAILURES.get(), this.modifyDNFailures);
        }
        if (this.modifyDNSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_MODIFY_DN_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_MODIFY_DN_SUCCESSES.get(), this.modifyDNSuccesses);
        }
        if (this.searchAttempts != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_ATTEMPTS, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_SEARCH_ATTEMPTS.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_SEARCH_ATTEMPTS.get(), this.searchAttempts);
        }
        if (this.searchFailures != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_FAILURES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_SEARCH_FAILURES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_SEARCH_FAILURES.get(), this.searchFailures);
        }
        if (this.searchSuccesses != null) {
            LDAPExternalServerMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_SUCCESSES, MonitorMessages.INFO_LDAP_EXT_SERVER_DISPNAME_SEARCH_SUCCESSES.get(), MonitorMessages.INFO_LDAP_EXT_SERVER_DESC_SEARCH_SUCCESSES.get(), this.searchSuccesses);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

