/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionTreeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.PatternRecognitionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExcludedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.MeasureDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternRecognitionRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ProcessingMode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RangeQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SkipTo;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubsetDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.VariableDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;

public class PatternRecognitionAnalyzer {
    private PatternRecognitionAnalyzer() {
    }

    public static PatternRecognitionAnalysis analyze(List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions, List<MeasureDefinition> measures, RowPattern pattern, Optional<SkipTo> skipTo) {
        String label;
        Set primaryLabels = (Set)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)pattern), Identifier.class).stream().map(PatternRecognitionAnalyzer::label).collect(ImmutableSet.toImmutableSet());
        List unionLabels = (List)subsets.stream().map(SubsetDefinition::getName).map(PatternRecognitionAnalyzer::label).collect(ImmutableList.toImmutableList());
        HashSet<String> unique = new HashSet<String>();
        for (SubsetDefinition subset : subsets) {
            label = PatternRecognitionAnalyzer.label(subset.getName());
            if (primaryLabels.contains(label)) {
                throw new SemanticException(String.format("union pattern variable name: %s is a duplicate of primary pattern variable name", subset.getName()));
            }
            if (!unique.add(label)) {
                throw new SemanticException(String.format("union pattern variable name: %s is declared twice", subset.getName()));
            }
            for (Identifier element : subset.getIdentifiers()) {
                if (primaryLabels.contains(PatternRecognitionAnalyzer.label(element))) continue;
                throw new SemanticException(String.format("subset element: %s is not a primary pattern variable", element));
            }
        }
        unique = new HashSet();
        for (VariableDefinition definition : variableDefinitions) {
            label = PatternRecognitionAnalyzer.label(definition.getName());
            if (!primaryLabels.contains(label)) {
                throw new SemanticException(String.format("defined variable: %s is not a primary pattern variable", definition.getName()));
            }
            if (!unique.add(label)) {
                throw new SemanticException(String.format("pattern variable with name: %s is defined twice", definition.getName()));
            }
            Expression expression2 = definition.getExpression();
            ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)expression2), FunctionCall.class).stream().filter(functionCall -> functionCall.getProcessingMode().map(mode -> mode.getMode() == ProcessingMode.Mode.FINAL).orElse(false)).findFirst().ifPresent(functionCall -> {
                throw new SemanticException(String.format("FINAL semantics is not supported in DEFINE clause", new Object[0]));
            });
        }
        Sets.SetView undefinedLabels = Sets.difference((Set)primaryLabels, unique);
        ImmutableMap.Builder ranges = ImmutableMap.builder();
        AstUtil.preOrder(pattern).filter(RangeQuantifier.class::isInstance).map(RangeQuantifier.class::cast).forEach(quantifier -> {
            Optional<Long> atLeast = quantifier.getAtLeast().map(LongLiteral::getParsedValue);
            atLeast.ifPresent(value -> {
                if (value < 0L) {
                    throw new SemanticException("Pattern quantifier lower bound must be greater than or equal to 0");
                }
                if (value > Integer.MAX_VALUE) {
                    throw new SemanticException("Pattern quantifier lower bound must not exceed 2147483647");
                }
            });
            Optional<Long> atMost = quantifier.getAtMost().map(LongLiteral::getParsedValue);
            atMost.ifPresent(value -> {
                if (value < 1L) {
                    throw new SemanticException("Pattern quantifier upper bound must be greater than or equal to 1");
                }
                if (value > Integer.MAX_VALUE) {
                    throw new SemanticException("Pattern quantifier upper bound must not exceed 2147483647");
                }
            });
            if (atLeast.isPresent() && atMost.isPresent() && atLeast.get() > atMost.get()) {
                throw new SemanticException("Pattern quantifier lower bound must not exceed upper bound");
            }
            ranges.put(NodeRef.of(quantifier), (Object)new Analysis.Range(atLeast.map(Math::toIntExact), atMost.map(Math::toIntExact)));
        });
        ImmutableSet allLabels = ImmutableSet.builder().addAll((Iterable)primaryLabels).addAll((Iterable)unionLabels).build();
        skipTo.flatMap(SkipTo::getIdentifier).ifPresent(arg_0 -> PatternRecognitionAnalyzer.lambda$analyze$6((Set)allLabels, arg_0));
        List expressions = (List)Streams.concat((Stream[])new Stream[]{measures.stream().map(MeasureDefinition::getExpression), variableDefinitions.stream().map(VariableDefinition::getExpression)}).collect(ImmutableList.toImmutableList());
        expressions.forEach(expression -> AstUtil.preOrder(expression).filter(child -> child instanceof PatternRecognitionRelation || child instanceof RowPattern).findFirst().ifPresent(nested -> {
            throw new SemanticException("nested row pattern recognition in row pattern recognition");
        }));
        return new PatternRecognitionAnalysis((Set<String>)allLabels, (Set<String>)undefinedLabels, (Map<NodeRef<RangeQuantifier>, Analysis.Range>)ranges.buildOrThrow());
    }

    public static void validatePatternExclusions(Optional<PatternRecognitionRelation.RowsPerMatch> rowsPerMatch, RowPattern pattern) {
        if (rowsPerMatch.isPresent() && rowsPerMatch.get() == PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED) {
            AstUtil.preOrder(pattern).filter(ExcludedPattern.class::isInstance).findFirst().ifPresent(exclusion -> {
                throw new SemanticException("Pattern exclusion syntax is not allowed when ALL ROWS PER MATCH WITH UNMATCHED ROWS is specified");
            });
        }
    }

    private static String label(Identifier identifier) {
        return identifier.getCanonicalValue();
    }

    private static /* synthetic */ void lambda$analyze$6(Set allLabels, Identifier identifier) {
        String label = PatternRecognitionAnalyzer.label(identifier);
        if (!allLabels.contains(label)) {
            throw new SemanticException(String.format("%s is not a primary or union pattern variable", identifier));
        }
    }
}

