/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PhysicalValueAccessor;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.Computation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.PatternExpressionComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;

public class PatternVariableRecognizer {
    private final long matchNumber;
    private final int patternStart;
    private final int partitionStart;
    private final int searchStart;
    private final int searchEnd;
    private final List<PatternVariableComputation> patternVariableComputations;
    private final Partition partition;

    public PatternVariableRecognizer(long matchNumber, int patternStart, int partitionStart, int searchStart, int searchEnd, List<PatternVariableComputation> patternVariableComputations, Partition partition) {
        this.matchNumber = matchNumber;
        this.patternStart = patternStart;
        this.partitionStart = partitionStart;
        this.searchStart = searchStart;
        this.searchEnd = searchEnd;
        this.patternVariableComputations = Objects.requireNonNull(patternVariableComputations, "evaluations is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    public int getInputLength() {
        return this.searchEnd - this.patternStart;
    }

    public boolean isMatchingAtPartitionStart() {
        return this.patternStart == this.partitionStart;
    }

    public boolean evaluateLabel(ArrayView matchedLabels, PatternAggregator[] patternAggregators) {
        int label = matchedLabels.get(matchedLabels.length() - 1);
        PatternVariableComputation patternVariableComputation = this.patternVariableComputations.get(label);
        return patternVariableComputation.test(matchedLabels, patternAggregators, this.partitionStart, this.searchStart, this.searchEnd, this.patternStart, this.matchNumber, this.partition);
    }

    public static class PatternVariableComputation
    extends PatternExpressionComputation {
        private final List<String> labelNames;

        public PatternVariableComputation(List<PhysicalValueAccessor> valueAccessors, Computation computation, List<PatternAggregator> patternAggregators, List<String> labelNames) {
            super(valueAccessors, computation, patternAggregators);
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
        }

        public boolean test(ArrayView matchedLabels, PatternAggregator[] patternAggregators, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, Partition partition) {
            int currentRow = patternStart + matchedLabels.length() - 1;
            Object result = this.compute(currentRow, matchedLabels, patternAggregators, partitionStart, searchStart, searchEnd, patternStart, matchNumber, this.labelNames, partition);
            return (Boolean)result;
        }
    }
}

