/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.table.TsFileInsertionEventTableParser;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.pipe.receiver.transform.statement.PipeConvertedInsertRowStatement;
import org.apache.iotdb.db.pipe.receiver.transform.statement.PipeConvertedInsertTabletStatement;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTableStatementDataTypeConvertExecutionVisitor
extends StatementVisitor<Optional<TSStatus>, Pair<TSStatus, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTableStatementDataTypeConvertExecutionVisitor.class);
    private final StatementExecutor statementExecutor;

    public PipeTableStatementDataTypeConvertExecutionVisitor(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    private Optional<TSStatus> tryExecute(Statement statement, String databaseName) {
        try {
            if (Objects.isNull(databaseName)) {
                LOGGER.warn("Database name is unexpectedly null for statement: {}. Skip data type conversion.", (Object)statement);
                return Optional.empty();
            }
            return Optional.of(this.statementExecutor.execute(statement, databaseName));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to execute statement after data type conversion.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<TSStatus> visitNode(StatementNode statementNode, Pair<TSStatus, String> statusAndDatabaseName) {
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TSStatus> visitLoadFile(LoadTsFileStatement loadTsFileStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        TSStatus status = (TSStatus)statusAndDatabaseName.getLeft();
        String databaseName = (String)statusAndDatabaseName.getRight();
        if (Objects.isNull(databaseName)) {
            LOGGER.warn("Database name is unexpectedly null for LoadTsFileStatement: {}. Skip data type conversion.", (Object)loadTsFileStatement);
            return Optional.empty();
        }
        if (!PipeConfig.getInstance().isPipeReceiverLoadConversionEnabled()) {
            return Optional.empty();
        }
        if (status.getCode() != TSStatusCode.LOAD_FILE_ERROR.getStatusCode()) return Optional.empty();
        if (status.getMessage() != null && status.getMessage().contains("memory")) {
            return Optional.empty();
        }
        LOGGER.warn("Data type mismatch detected (TSStatus: {}) for LoadTsFileStatement: {}. Start data type conversion.", (Object)status, (Object)loadTsFileStatement);
        for (File file : loadTsFileStatement.getTsFiles()) {
            try (TsFileInsertionEventTableParser parser = new TsFileInsertionEventTableParser(file, new TablePattern(true, null, null), Long.MIN_VALUE, Long.MAX_VALUE, null, "root", null);){
                for (TabletInsertionEvent tabletInsertionEvent : parser.toTabletInsertionEvents()) {
                    TSStatus result;
                    if (!(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) continue;
                    PipeRawTabletInsertionEvent rawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
                    PipeConvertedInsertTabletStatement statement = new PipeConvertedInsertTabletStatement(PipeTransferTabletRawReqV2.toTPipeTransferRawReq(rawTabletInsertionEvent.convertToTablet(), rawTabletInsertionEvent.isAligned(), databaseName).constructStatement(), false);
                    try {
                        result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement, databaseName));
                        for (int i = 0; i < 5 && result.getCode() == TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode(); ++i) {
                            Thread.sleep(100L * (long)(i + 1));
                            result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement, databaseName));
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_EXCEPTION_VISITOR, e);
                    }
                    if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || result.getCode() == TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()) continue;
                    Optional<TSStatus> optional = Optional.empty();
                    return optional;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to convert data type for LoadTsFileStatement: {}.", (Object)loadTsFileStatement, (Object)e);
                return Optional.empty();
            }
        }
        if (loadTsFileStatement.isDeleteAfterLoad()) {
            loadTsFileStatement.getTsFiles().forEach(FileUtils::deleteQuietly);
        }
        LOGGER.warn("Data type conversion for LoadTsFileStatement {} is successful.", (Object)loadTsFileStatement);
        return Optional.of(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
    }

    @Override
    public Optional<TSStatus> visitInsertRow(InsertRowStatement insertRowStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        return this.tryExecute(new PipeConvertedInsertRowStatement(insertRowStatement), (String)statusAndDatabaseName.getRight());
    }

    @Override
    public Optional<TSStatus> visitInsertRows(InsertRowsStatement insertRowsStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        if (insertRowsStatement.getInsertRowStatementList() == null || insertRowsStatement.getInsertRowStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertRowsStatement convertedInsertRowsStatement = new InsertRowsStatement();
        convertedInsertRowsStatement.setInsertRowStatementList(insertRowsStatement.getInsertRowStatementList().stream().map(PipeConvertedInsertRowStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertRowsStatement, (String)statusAndDatabaseName.getRight());
    }

    @Override
    public Optional<TSStatus> visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        if (insertRowsOfOneDeviceStatement.getInsertRowStatementList() == null || insertRowsOfOneDeviceStatement.getInsertRowStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertRowsOfOneDeviceStatement convertedInsertRowsOfOneDeviceStatement = new InsertRowsOfOneDeviceStatement();
        convertedInsertRowsOfOneDeviceStatement.setInsertRowStatementList(insertRowsOfOneDeviceStatement.getInsertRowStatementList().stream().map(PipeConvertedInsertRowStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertRowsOfOneDeviceStatement, (String)statusAndDatabaseName.getRight());
    }

    @Override
    public Optional<TSStatus> visitInsertTablet(InsertTabletStatement insertTabletStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        return this.tryExecute(new PipeConvertedInsertTabletStatement(insertTabletStatement), (String)statusAndDatabaseName.getRight());
    }

    @Override
    public Optional<TSStatus> visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, Pair<TSStatus, String> statusAndDatabaseName) {
        if (insertMultiTabletsStatement.getInsertTabletStatementList() == null || insertMultiTabletsStatement.getInsertTabletStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertMultiTabletsStatement convertedInsertMultiTabletsStatement = new InsertMultiTabletsStatement();
        convertedInsertMultiTabletsStatement.setInsertTabletStatementList(insertMultiTabletsStatement.getInsertTabletStatementList().stream().map(PipeConvertedInsertTabletStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertMultiTabletsStatement, (String)statusAndDatabaseName.getRight());
    }

    @FunctionalInterface
    public static interface StatementExecutor {
        public TSStatus execute(Statement var1, String var2);
    }
}

