/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer.base;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.subscription.config.ConsumerConstant;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionConnectionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionPipeTimeoutException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionPollTimeoutException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionRuntimeCriticalException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionRuntimeNonCriticalException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionTimeoutException;
import org.apache.iotdb.rpc.subscription.payload.poll.ErrorPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileSealPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.apache.iotdb.session.subscription.consumer.AsyncCommitCallback;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionConsumerBuilder;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionProvider;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionProviders;
import org.apache.iotdb.session.subscription.consumer.base.SubscriptionExecutorServiceManager;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessageType;
import org.apache.iotdb.session.subscription.util.CollectionUtils;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.apache.iotdb.session.subscription.util.PollTimer;
import org.apache.iotdb.session.subscription.util.RandomStringGenerator;
import org.apache.iotdb.session.subscription.util.SetPartitioner;
import org.apache.iotdb.session.util.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSubscriptionConsumer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSubscriptionConsumer.class);
    private static final long SLEEP_MS = 100L;
    private static final long SLEEP_DELTA_MS = 50L;
    private static final long TIMER_DELTA_MS = 250L;
    private final String username;
    private final String password;
    protected String consumerId;
    protected String consumerGroupId;
    private final long heartbeatIntervalMs;
    private final long endpointsSyncIntervalMs;
    private final AbstractSubscriptionProviders providers;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final AtomicBoolean isReleased = new AtomicBoolean(false);
    private final String fileSaveDir;
    private final boolean fileSaveFsync;
    private final Set<SubscriptionCommitContext> inFlightFilesCommitContextSet = new HashSet<SubscriptionCommitContext>();
    private final int thriftMaxFrameSize;
    private final int maxPollParallelism;
    protected volatile Map<String, TopicConfig> subscribedTopics = new HashMap<String, TopicConfig>();
    private final Map<SubscriptionPollResponseType, BiFunction<SubscriptionPollResponse, PollTimer, Optional<SubscriptionMessage>>> responseTransformer = Collections.unmodifiableMap(new HashMap<SubscriptionPollResponseType, BiFunction<SubscriptionPollResponse, PollTimer, Optional<SubscriptionMessage>>>(){
        {
            this.put(SubscriptionPollResponseType.TABLETS, (resp, timer) -> AbstractSubscriptionConsumer.this.pollTablets(resp, timer));
            this.put(SubscriptionPollResponseType.FILE_INIT, (resp, timer) -> AbstractSubscriptionConsumer.this.pollFile(resp, timer));
            this.put(SubscriptionPollResponseType.ERROR, (resp, timer) -> {
                ErrorPayload payload = (ErrorPayload)resp.getPayload();
                String errorMessage = payload.getErrorMessage();
                if (payload.isCritical()) {
                    throw new SubscriptionRuntimeCriticalException(errorMessage);
                }
                throw new SubscriptionRuntimeNonCriticalException(errorMessage);
            });
            this.put(SubscriptionPollResponseType.TERMINATION, (resp, timer) -> {
                SubscriptionCommitContext commitContext = resp.getCommitContext();
                String topicNameToUnsubscribe = commitContext.getTopicName();
                LOGGER.info("Termination occurred when SubscriptionConsumer {} polling topics, unsubscribe topic {} automatically", AbstractSubscriptionConsumer.this.coreReportMessage(), (Object)topicNameToUnsubscribe);
                AbstractSubscriptionConsumer.this.unsubscribe(Collections.singleton(topicNameToUnsubscribe), false);
                return Optional.empty();
            });
        }
    });

    @Deprecated
    public boolean allSnapshotTopicMessagesHaveBeenConsumed() {
        return this.allTopicMessagesHaveBeenConsumed(this.subscribedTopics.keySet());
    }

    public boolean allTopicMessagesHaveBeenConsumed() {
        return this.allTopicMessagesHaveBeenConsumed(this.subscribedTopics.keySet());
    }

    private boolean allTopicMessagesHaveBeenConsumed(Collection<String> topicNames) {
        return topicNames.stream().map(this.subscribedTopics::get).noneMatch(Objects::nonNull);
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    protected AbstractSubscriptionConsumer(AbstractSubscriptionConsumerBuilder builder) {
        HashSet<TEndPoint> initialEndpoints = new HashSet<TEndPoint>();
        if (Objects.nonNull(builder.host) || Objects.nonNull(builder.port)) {
            if (Objects.isNull(builder.host)) {
                builder.host = "localhost";
            }
            if (Objects.isNull(builder.port)) {
                builder.port = 6667;
            }
            initialEndpoints.add(new TEndPoint(builder.host, builder.port.intValue()));
        } else if (Objects.isNull(builder.nodeUrls)) {
            builder.host = "localhost";
            builder.port = 6667;
            initialEndpoints.add(new TEndPoint(builder.host, builder.port.intValue()));
        } else {
            initialEndpoints.addAll(SessionUtils.parseSeedNodeUrls(builder.nodeUrls));
        }
        this.providers = new AbstractSubscriptionProviders(initialEndpoints);
        this.username = builder.username;
        this.password = builder.password;
        this.consumerId = builder.consumerId;
        this.consumerGroupId = builder.consumerGroupId;
        this.heartbeatIntervalMs = builder.heartbeatIntervalMs;
        this.endpointsSyncIntervalMs = builder.endpointsSyncIntervalMs;
        this.fileSaveDir = builder.fileSaveDir;
        this.fileSaveFsync = builder.fileSaveFsync;
        this.thriftMaxFrameSize = builder.thriftMaxFrameSize;
        this.maxPollParallelism = builder.maxPollParallelism;
    }

    protected AbstractSubscriptionConsumer(AbstractSubscriptionConsumerBuilder builder, Properties properties) {
        this(builder.host((String)properties.get("host")).port((Integer)properties.get("port")).nodeUrls((List)properties.get("node-urls")).username((String)properties.getOrDefault((Object)"username", "root")).password((String)properties.getOrDefault((Object)"password", "root")).consumerId((String)properties.get("consumer-id")).consumerGroupId((String)properties.get("group-id")).heartbeatIntervalMs((Long)properties.getOrDefault((Object)"heartbeat-interval-ms", (Object)30000L)).endpointsSyncIntervalMs((Long)properties.getOrDefault((Object)"endpoints-sync-interval-ms", (Object)120000L)).fileSaveDir((String)properties.getOrDefault((Object)"file-save-dir", ConsumerConstant.FILE_SAVE_DIR_DEFAULT_VALUE)).fileSaveFsync((Boolean)properties.getOrDefault((Object)"file-save-fsync", (Object)false)).thriftMaxFrameSize((Integer)properties.getOrDefault((Object)"thrift-max-frame-size", (Object)0x4000000)).maxPollParallelism((Integer)properties.getOrDefault((Object)"max-poll-parallelism", (Object)1)));
    }

    private void checkIfHasBeenClosed() throws SubscriptionException {
        if (this.isReleased.get()) {
            String errorMessage = String.format("%s has ever been closed, unsupported operation after closing.", this);
            LOGGER.error(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
    }

    private void checkIfOpened() throws SubscriptionException {
        if (this.isClosed.get()) {
            String errorMessage = String.format("%s is not yet open, please open the subscription consumer first.", this);
            LOGGER.error(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
    }

    protected synchronized void open() throws SubscriptionException {
        this.checkIfHasBeenClosed();
        if (!this.isClosed.get()) {
            return;
        }
        this.providers.acquireWriteLock();
        try {
            this.providers.openProviders(this);
        }
        finally {
            this.providers.releaseWriteLock();
        }
        this.isClosed.set(false);
        this.submitHeartbeatWorker();
        this.submitEndpointsSyncer();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.get()) {
            return;
        }
        this.providers.acquireWriteLock();
        try {
            this.providers.closeProviders();
        }
        finally {
            this.providers.releaseWriteLock();
        }
        this.isClosed.set(true);
        this.isReleased.set(true);
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    protected void subscribe(String topicName) throws SubscriptionException {
        this.subscribe(Collections.singleton(topicName));
    }

    protected void subscribe(String ... topicNames) throws SubscriptionException {
        this.subscribe(new HashSet<String>(Arrays.asList(topicNames)));
    }

    protected void subscribe(Set<String> topicNames) throws SubscriptionException {
        this.subscribe(topicNames, true);
    }

    private void subscribe(Set<String> topicNames, boolean needParse) throws SubscriptionException {
        this.checkIfOpened();
        if (needParse) {
            topicNames = topicNames.stream().map(IdentifierUtils::checkAndParseIdentifier).collect(Collectors.toSet());
        }
        this.providers.acquireReadLock();
        try {
            this.subscribeWithRedirection(topicNames);
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    protected void unsubscribe(String topicName) throws SubscriptionException {
        this.unsubscribe(Collections.singleton(topicName));
    }

    protected void unsubscribe(String ... topicNames) throws SubscriptionException {
        this.unsubscribe(new HashSet<String>(Arrays.asList(topicNames)));
    }

    protected void unsubscribe(Set<String> topicNames) throws SubscriptionException {
        this.unsubscribe(topicNames, true);
    }

    private void unsubscribe(Set<String> topicNames, boolean needParse) throws SubscriptionException {
        this.checkIfOpened();
        if (needParse) {
            topicNames = topicNames.stream().map(IdentifierUtils::checkAndParseIdentifier).collect(Collectors.toSet());
        }
        this.providers.acquireReadLock();
        try {
            this.unsubscribeWithRedirection(topicNames);
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    protected abstract AbstractSubscriptionProvider constructSubscriptionProvider(TEndPoint var1, String var2, String var3, String var4, String var5, int var6);

    AbstractSubscriptionProvider constructProviderAndHandshake(TEndPoint endPoint) throws SubscriptionException {
        AbstractSubscriptionProvider provider = this.constructSubscriptionProvider(endPoint, this.username, this.password, this.consumerId, this.consumerGroupId, this.thriftMaxFrameSize);
        try {
            provider.handshake();
        }
        catch (Exception e) {
            try {
                provider.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SubscriptionConnectionException(String.format("Failed to handshake with subscription provider %s because of %s", provider, e), (Throwable)e);
        }
        if (Objects.isNull(this.consumerId)) {
            this.consumerId = provider.getConsumerId();
        }
        if (Objects.isNull(this.consumerGroupId)) {
            this.consumerGroupId = provider.getConsumerGroupId();
        }
        return provider;
    }

    private Path getFileDir(String topicName) throws IOException {
        Path dirPath = Paths.get(this.fileSaveDir, new String[0]).resolve(this.consumerGroupId).resolve(this.consumerId).resolve(topicName);
        Files.createDirectories(dirPath, new FileAttribute[0]);
        return dirPath;
    }

    private Path getFilePath(SubscriptionCommitContext commitContext, String topicName, String fileName, boolean allowFileAlreadyExistsException, boolean allowInvalidPathException) throws SubscriptionException {
        try {
            Path filePath;
            try {
                filePath = this.getFileDir(topicName).resolve(fileName);
            }
            catch (InvalidPathException invalidPathException) {
                if (allowInvalidPathException) {
                    return this.getFilePath(commitContext, URLEncoder.encode(topicName), fileName, true, false);
                }
                throw new SubscriptionRuntimeNonCriticalException(invalidPathException.getMessage(), (Throwable)invalidPathException);
            }
            try {
                Files.createFile(filePath, new FileAttribute[0]);
                return filePath;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (allowFileAlreadyExistsException) {
                    if (this.inFlightFilesCommitContextSet.contains(commitContext)) {
                        LOGGER.info("Detect already existed file {} when polling topic {}, resume consumption", (Object)fileName, (Object)topicName);
                        return filePath;
                    }
                    String suffix = RandomStringGenerator.generate(16);
                    LOGGER.warn("Detect already existed file {} when polling topic {}, add random suffix {} to filename", new Object[]{fileName, topicName, suffix});
                    return this.getFilePath(commitContext, topicName, fileName + "." + suffix, false, true);
                }
                throw new SubscriptionRuntimeNonCriticalException(fileAlreadyExistsException.getMessage(), (Throwable)fileAlreadyExistsException);
            }
        }
        catch (IOException e) {
            throw new SubscriptionRuntimeNonCriticalException(e.getMessage(), (Throwable)e);
        }
    }

    protected List<SubscriptionMessage> multiplePoll(Set<String> topicNames, long timeoutMs) {
        if (topicNames.isEmpty()) {
            return Collections.emptyList();
        }
        int availableCount = SubscriptionExecutorServiceManager.getAvailableThreadCountForPollTasks();
        if (availableCount == 0) {
            return this.singlePoll(topicNames, timeoutMs);
        }
        ArrayList<PollTask> tasks = new ArrayList<PollTask>();
        List<Set<String>> partitionedTopicNames = SetPartitioner.partition(topicNames, Math.min(this.maxPollParallelism, availableCount));
        for (Set<String> partition : partitionedTopicNames) {
            tasks.add(new PollTask(partition, timeoutMs));
        }
        ArrayList<SubscriptionMessage> messages = new ArrayList<SubscriptionMessage>();
        SubscriptionRuntimeCriticalException lastSubscriptionRuntimeCriticalException = null;
        try {
            for (Future future : SubscriptionExecutorServiceManager.submitMultiplePollTasks(tasks, timeoutMs)) {
                try {
                    if (future.isCancelled()) continue;
                    messages.addAll((Collection)future.get());
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SubscriptionRuntimeCriticalException) {
                        SubscriptionRuntimeCriticalException ex = (SubscriptionRuntimeCriticalException)cause;
                        LOGGER.warn("SubscriptionRuntimeCriticalException occurred when SubscriptionConsumer {} polling topics {}", new Object[]{this, topicNames, ex});
                        lastSubscriptionRuntimeCriticalException = ex;
                        continue;
                    }
                    LOGGER.warn("ExecutionException occurred when SubscriptionConsumer {} polling topics {}", new Object[]{this, topicNames, e});
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("InterruptedException occurred when SubscriptionConsumer {} polling topics {}", new Object[]{this, topicNames, e});
            Thread.currentThread().interrupt();
        }
        if (messages.isEmpty() && Objects.nonNull(lastSubscriptionRuntimeCriticalException)) {
            throw lastSubscriptionRuntimeCriticalException;
        }
        return messages;
    }

    /*
     * Exception decompiling
     */
    private List<SubscriptionMessage> singlePoll(Set<String> topicNames, long timeoutMs) throws SubscriptionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<SubscriptionMessage> pollFile(SubscriptionPollResponse response, PollTimer timer) throws SubscriptionException {
        Optional<SubscriptionMessage> optional;
        SubscriptionCommitContext commitContext = response.getCommitContext();
        String fileName = ((FileInitPayload)response.getPayload()).getFileName();
        String topicName = commitContext.getTopicName();
        Path filePath = this.getFilePath(commitContext, topicName, fileName, true, true);
        File file = filePath.toFile();
        RandomAccessFile fileWriter = new RandomAccessFile(file, "rw");
        try {
            optional = this.pollFileInternal(commitContext, fileName, file, fileWriter, timer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (!(e instanceof SubscriptionPollTimeoutException)) {
                    this.inFlightFilesCommitContextSet.remove(commitContext);
                }
                this.nack((Iterable<SubscriptionMessage>)Collections.singletonList(new SubscriptionMessage(commitContext, file.getAbsolutePath(), null)));
                throw new SubscriptionRuntimeNonCriticalException(e.getMessage(), (Throwable)e);
            }
        }
        fileWriter.close();
        return optional;
    }

    private Optional<SubscriptionMessage> pollFileInternal(SubscriptionCommitContext commitContext, String rawFileName, File file, RandomAccessFile fileWriter, PollTimer timer) throws IOException, SubscriptionException {
        String errorMessage;
        short responseType;
        long writingOffset = fileWriter.length();
        LOGGER.info("{} start to poll file {} with commit context {} at offset {}", new Object[]{this, file.getAbsolutePath(), commitContext, writingOffset});
        fileWriter.seek(writingOffset);
        block5: while (true) {
            timer.update();
            if (timer.isExpired(250L)) {
                this.inFlightFilesCommitContextSet.add(commitContext);
                String message = String.format("Timeout occurred when SubscriptionConsumer %s polling file %s with commit context %s, record writing offset %s for subsequent poll", this, file.getAbsolutePath(), commitContext, writingOffset);
                LOGGER.info(message);
                throw new SubscriptionRuntimeNonCriticalException(message);
            }
            List<SubscriptionPollResponse> responses = this.pollFileInternal(commitContext, writingOffset, timer.remainingMs());
            if (responses.isEmpty()) {
                return Optional.empty();
            }
            SubscriptionPollResponse response = responses.get(0);
            SubscriptionPollPayload payload = response.getPayload();
            responseType = response.getResponseType();
            if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
                errorMessage = String.format("unexpected response type: %s", responseType);
                LOGGER.warn(errorMessage);
                throw new SubscriptionRuntimeNonCriticalException(errorMessage);
            }
            switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
                case FILE_PIECE: {
                    SubscriptionCommitContext incomingCommitContext = response.getCommitContext();
                    if (Objects.isNull(incomingCommitContext) || !Objects.equals(commitContext, incomingCommitContext)) {
                        String errorMessage2 = String.format("inconsistent commit context, current is %s, incoming is %s, consumer: %s", commitContext, incomingCommitContext, this);
                        LOGGER.warn(errorMessage2);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage2);
                    }
                    if (!Objects.equals(rawFileName, ((FilePiecePayload)payload).getFileName())) {
                        String errorMessage3 = String.format("inconsistent file name, current is %s, incoming is %s, consumer: %s", rawFileName, ((FilePiecePayload)payload).getFileName(), this);
                        LOGGER.warn(errorMessage3);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage3);
                    }
                    fileWriter.write(((FilePiecePayload)payload).getFilePiece());
                    if (this.fileSaveFsync) {
                        fileWriter.getFD().sync();
                    }
                    if (!Objects.equals(fileWriter.length(), ((FilePiecePayload)payload).getNextWritingOffset())) {
                        String errorMessage4 = String.format("inconsistent file offset, current is %s, incoming is %s, consumer: %s", fileWriter.length(), ((FilePiecePayload)payload).getNextWritingOffset(), this);
                        LOGGER.warn(errorMessage4);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage4);
                    }
                    writingOffset = ((FilePiecePayload)payload).getNextWritingOffset();
                    continue block5;
                }
                case FILE_SEAL: {
                    SubscriptionCommitContext incomingCommitContext = response.getCommitContext();
                    if (Objects.isNull(incomingCommitContext) || !Objects.equals(commitContext, incomingCommitContext)) {
                        String errorMessage5 = String.format("inconsistent commit context, current is %s, incoming is %s, consumer: %s", commitContext, incomingCommitContext, this);
                        LOGGER.warn(errorMessage5);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage5);
                    }
                    if (!Objects.equals(rawFileName, ((FileSealPayload)payload).getFileName())) {
                        String errorMessage6 = String.format("inconsistent file name, current is %s, incoming is %s, consumer: %s", rawFileName, ((FileSealPayload)payload).getFileName(), this);
                        LOGGER.warn(errorMessage6);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage6);
                    }
                    if (fileWriter.length() != ((FileSealPayload)payload).getFileLength()) {
                        String errorMessage7 = String.format("inconsistent file length, current is %s, incoming is %s, consumer: %s", fileWriter.length(), ((FileSealPayload)payload).getFileLength(), this);
                        LOGGER.warn(errorMessage7);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage7);
                    }
                    if (this.fileSaveFsync) {
                        fileWriter.getFD().sync();
                    }
                    fileWriter.close();
                    LOGGER.info("SubscriptionConsumer {} successfully poll file {} with commit context {}", new Object[]{this, file.getAbsolutePath(), commitContext});
                    this.inFlightFilesCommitContextSet.remove(commitContext);
                    return Optional.of(new SubscriptionMessage(commitContext, file.getAbsolutePath(), ((FileSealPayload)payload).getDatabaseName()));
                }
                case ERROR: {
                    errorMessage = ((ErrorPayload)payload).getErrorMessage();
                    boolean critical = ((ErrorPayload)payload).isCritical();
                    if (!critical && Objects.nonNull(errorMessage) && errorMessage.contains(SubscriptionTimeoutException.KEYWORD)) {
                        this.inFlightFilesCommitContextSet.add(commitContext);
                        String message = String.format("Timeout occurred when SubscriptionConsumer %s polling file %s with commit context %s, record writing offset %s for subsequent poll", this, file.getAbsolutePath(), commitContext, writingOffset);
                        LOGGER.info(message);
                        throw new SubscriptionPollTimeoutException(message);
                    }
                    LOGGER.warn("Error occurred when SubscriptionConsumer {} polling file {} with commit context {}: {}, critical: {}", new Object[]{this, file.getAbsolutePath(), commitContext, errorMessage, critical});
                    if (critical) {
                        throw new SubscriptionRuntimeCriticalException(errorMessage);
                    }
                    throw new SubscriptionRuntimeNonCriticalException(errorMessage);
                }
            }
            break;
        }
        errorMessage = String.format("unexpected response type: %s", responseType);
        LOGGER.warn(errorMessage);
        throw new SubscriptionRuntimeNonCriticalException(errorMessage);
    }

    private Optional<SubscriptionMessage> pollTablets(SubscriptionPollResponse response, PollTimer timer) throws SubscriptionException {
        try {
            return this.pollTabletsInternal(response, timer);
        }
        catch (Exception e) {
            this.nack((Iterable<SubscriptionMessage>)Collections.singletonList(new SubscriptionMessage(response.getCommitContext(), Collections.emptyMap())));
            throw new SubscriptionRuntimeNonCriticalException(e.getMessage(), (Throwable)e);
        }
    }

    private Optional<SubscriptionMessage> pollTabletsInternal(SubscriptionPollResponse initialResponse, PollTimer timer) {
        String errorMessage;
        short responseType;
        Map tablets = ((TabletsPayload)initialResponse.getPayload()).getTabletsWithDBInfo();
        SubscriptionCommitContext commitContext = initialResponse.getCommitContext();
        int nextOffset = ((TabletsPayload)initialResponse.getPayload()).getNextOffset();
        block4: while (true) {
            if (nextOffset <= 0) {
                int tabletsSize = tablets.values().stream().mapToInt(List::size).sum();
                if (!Objects.equals(tabletsSize, -nextOffset)) {
                    String errorMessage2 = String.format("inconsistent tablet size, current is %s, incoming is %s, consumer: %s", tabletsSize, -nextOffset, this);
                    LOGGER.warn(errorMessage2);
                    throw new SubscriptionRuntimeNonCriticalException(errorMessage2);
                }
                return Optional.of(new SubscriptionMessage(commitContext, tablets));
            }
            timer.update();
            if (timer.isExpired(250L)) {
                String errorMessage3 = String.format("timeout while poll tablets with commit context: %s, consumer: %s", commitContext, this);
                LOGGER.warn(errorMessage3);
                throw new SubscriptionRuntimeNonCriticalException(errorMessage3);
            }
            List<SubscriptionPollResponse> responses = this.pollTabletsInternal(commitContext, nextOffset, timer.remainingMs());
            if (responses.isEmpty()) {
                return Optional.empty();
            }
            SubscriptionPollResponse response = responses.get(0);
            SubscriptionPollPayload payload = response.getPayload();
            responseType = response.getResponseType();
            if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
                errorMessage = String.format("unexpected response type: %s", responseType);
                LOGGER.warn(errorMessage);
                throw new SubscriptionRuntimeNonCriticalException(errorMessage);
            }
            switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
                case TABLETS: {
                    SubscriptionCommitContext incomingCommitContext = response.getCommitContext();
                    if (Objects.isNull(incomingCommitContext) || !Objects.equals(commitContext, incomingCommitContext)) {
                        String errorMessage4 = String.format("inconsistent commit context, current is %s, incoming is %s, consumer: %s", commitContext, incomingCommitContext, this);
                        LOGGER.warn(errorMessage4);
                        throw new SubscriptionRuntimeNonCriticalException(errorMessage4);
                    }
                    for (Map.Entry entry : ((TabletsPayload)response.getPayload()).getTabletsWithDBInfo().entrySet()) {
                        tablets.computeIfAbsent((String)entry.getKey(), databaseName -> new ArrayList()).addAll((Collection)entry.getValue());
                    }
                    nextOffset = ((TabletsPayload)payload).getNextOffset();
                    continue block4;
                }
                case ERROR: {
                    errorMessage = ((ErrorPayload)payload).getErrorMessage();
                    boolean critical = ((ErrorPayload)payload).isCritical();
                    if (Objects.equals(payload, ErrorPayload.OUTDATED_ERROR_PAYLOAD)) {
                        return Optional.empty();
                    }
                    LOGGER.warn("Error occurred when SubscriptionConsumer {} polling tablets with commit context {}: {}, critical: {}", new Object[]{this, commitContext, errorMessage, critical});
                    if (critical) {
                        throw new SubscriptionRuntimeCriticalException(errorMessage);
                    }
                    throw new SubscriptionRuntimeNonCriticalException(errorMessage);
                }
            }
            break;
        }
        errorMessage = String.format("unexpected response type: %s", responseType);
        LOGGER.warn(errorMessage);
        throw new SubscriptionRuntimeNonCriticalException(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriptionPollResponse> pollInternal(Set<String> topicNames, long timeoutMs) throws SubscriptionException {
        this.providers.acquireReadLock();
        try {
            AbstractSubscriptionProvider provider = this.providers.getNextAvailableProvider();
            if (Objects.isNull(provider) || !provider.isAvailable()) {
                if (this.isClosed()) {
                    List<SubscriptionPollResponse> list = Collections.emptyList();
                    return list;
                }
                throw new SubscriptionConnectionException(String.format("Cluster has no available subscription providers when %s poll topic %s", this, topicNames));
            }
            try {
                List<SubscriptionPollResponse> list = provider.poll(topicNames, timeoutMs);
                return list;
            }
            catch (SubscriptionConnectionException ignored) {
                List<SubscriptionPollResponse> list = Collections.emptyList();
                this.providers.releaseReadLock();
                return list;
            }
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriptionPollResponse> pollFileInternal(SubscriptionCommitContext commitContext, long writingOffset, long timeoutMs) throws SubscriptionException {
        int dataNodeId = commitContext.getDataNodeId();
        this.providers.acquireReadLock();
        try {
            AbstractSubscriptionProvider provider = this.providers.getProvider(dataNodeId);
            if (Objects.isNull(provider) || !provider.isAvailable()) {
                if (this.isClosed()) {
                    List<SubscriptionPollResponse> list = Collections.emptyList();
                    return list;
                }
                throw new SubscriptionConnectionException(String.format("something unexpected happened when %s poll file from subscription provider with data node id %s, the subscription provider may be unavailable or not existed", this, dataNodeId));
            }
            try {
                List<SubscriptionPollResponse> list = provider.pollFile(commitContext, writingOffset, timeoutMs);
                return list;
            }
            catch (SubscriptionConnectionException ignored) {
                List<SubscriptionPollResponse> list = Collections.emptyList();
                this.providers.releaseReadLock();
                return list;
            }
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriptionPollResponse> pollTabletsInternal(SubscriptionCommitContext commitContext, int offset, long timeoutMs) throws SubscriptionException {
        int dataNodeId = commitContext.getDataNodeId();
        this.providers.acquireReadLock();
        try {
            AbstractSubscriptionProvider provider = this.providers.getProvider(dataNodeId);
            if (Objects.isNull(provider) || !provider.isAvailable()) {
                if (this.isClosed()) {
                    List<SubscriptionPollResponse> list = Collections.emptyList();
                    return list;
                }
                throw new SubscriptionConnectionException(String.format("something unexpected happened when %s poll tablets from subscription provider with data node id %s, the subscription provider may be unavailable or not existed", this, dataNodeId));
            }
            try {
                List<SubscriptionPollResponse> list = provider.pollTablets(commitContext, offset, timeoutMs);
                return list;
            }
            catch (SubscriptionConnectionException ignored) {
                List<SubscriptionPollResponse> list = Collections.emptyList();
                this.providers.releaseReadLock();
                return list;
            }
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    protected void ack(Iterable<SubscriptionMessage> messages) throws SubscriptionException {
        HashMap<Integer, List> dataNodeIdToSubscriptionCommitContexts = new HashMap<Integer, List>();
        for (SubscriptionMessage subscriptionMessage : messages) {
            dataNodeIdToSubscriptionCommitContexts.computeIfAbsent(subscriptionMessage.getCommitContext().getDataNodeId(), id -> new ArrayList()).add(subscriptionMessage.getCommitContext());
        }
        for (Map.Entry entry : dataNodeIdToSubscriptionCommitContexts.entrySet()) {
            this.commitInternal((Integer)entry.getKey(), (List)entry.getValue(), false);
        }
    }

    protected void nack(Iterable<SubscriptionMessage> messages) throws SubscriptionException {
        HashMap<Integer, List> dataNodeIdToSubscriptionCommitContexts = new HashMap<Integer, List>();
        for (SubscriptionMessage subscriptionMessage : messages) {
            if (Objects.equals(SubscriptionMessageType.TS_FILE_HANDLER.getType(), subscriptionMessage.getMessageType()) && !this.inFlightFilesCommitContextSet.contains(subscriptionMessage.getCommitContext())) {
                try {
                    subscriptionMessage.getTsFileHandler().deleteFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dataNodeIdToSubscriptionCommitContexts.computeIfAbsent(subscriptionMessage.getCommitContext().getDataNodeId(), id -> new ArrayList()).add(subscriptionMessage.getCommitContext());
        }
        for (Map.Entry entry : dataNodeIdToSubscriptionCommitContexts.entrySet()) {
            this.commitInternal((Integer)entry.getKey(), (List)entry.getValue(), true);
        }
    }

    private void nack(List<SubscriptionPollResponse> responses) throws SubscriptionException {
        HashMap<Integer, List> dataNodeIdToSubscriptionCommitContexts = new HashMap<Integer, List>();
        for (SubscriptionPollResponse subscriptionPollResponse : responses) {
            dataNodeIdToSubscriptionCommitContexts.computeIfAbsent(subscriptionPollResponse.getCommitContext().getDataNodeId(), id -> new ArrayList()).add(subscriptionPollResponse.getCommitContext());
        }
        for (Map.Entry entry : dataNodeIdToSubscriptionCommitContexts.entrySet()) {
            this.commitInternal((Integer)entry.getKey(), (List)entry.getValue(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitInternal(int dataNodeId, List<SubscriptionCommitContext> subscriptionCommitContexts, boolean nack) throws SubscriptionException {
        this.providers.acquireReadLock();
        try {
            AbstractSubscriptionProvider provider = this.providers.getProvider(dataNodeId);
            if (Objects.isNull(provider) || !provider.isAvailable()) {
                if (this.isClosed()) {
                    return;
                }
                throw new SubscriptionConnectionException(String.format("something unexpected happened when %s commit (nack: %s) messages to subscription provider with data node id %s, the subscription provider may be unavailable or not existed", this, nack, dataNodeId));
            }
            provider.commit(subscriptionCommitContexts, nack);
        }
        finally {
            this.providers.releaseReadLock();
        }
    }

    private void submitHeartbeatWorker() {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{SubscriptionExecutorServiceManager.submitHeartbeatWorker(() -> {
            if (this.isClosed()) {
                if (Objects.nonNull(future[0])) {
                    future[0].cancel(false);
                    LOGGER.info("SubscriptionConsumer {} cancel heartbeat worker", (Object)this);
                }
                return;
            }
            this.providers.heartbeat(this);
        }, this.heartbeatIntervalMs)};
        LOGGER.info("SubscriptionConsumer {} submit heartbeat worker", (Object)this);
    }

    private void submitEndpointsSyncer() {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{SubscriptionExecutorServiceManager.submitEndpointsSyncer(() -> {
            if (this.isClosed()) {
                if (Objects.nonNull(future[0])) {
                    future[0].cancel(false);
                    LOGGER.info("SubscriptionConsumer {} cancel endpoints syncer", (Object)this);
                }
                return;
            }
            this.providers.sync(this);
        }, this.endpointsSyncIntervalMs)};
        LOGGER.info("SubscriptionConsumer {} submit endpoints syncer", (Object)this);
    }

    protected void commitAsync(Iterable<SubscriptionMessage> messages, AsyncCommitCallback callback) {
        SubscriptionExecutorServiceManager.submitAsyncCommitWorker(new AsyncCommitWorker(messages, callback));
    }

    protected CompletableFuture<Void> commitAsync(Iterable<SubscriptionMessage> messages) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        SubscriptionExecutorServiceManager.submitAsyncCommitWorker(() -> {
            if (this.isClosed()) {
                return;
            }
            try {
                this.ack(messages);
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void subscribeWithRedirection(Set<String> topicNames) throws SubscriptionException {
        List<AbstractSubscriptionProvider> providers = this.providers.getAllAvailableProviders();
        if (providers.isEmpty()) {
            throw new SubscriptionConnectionException(String.format("Cluster has no available subscription providers when %s subscribe topic %s", this, topicNames));
        }
        for (AbstractSubscriptionProvider provider : providers) {
            try {
                this.subscribedTopics = provider.subscribe(topicNames);
                return;
            }
            catch (Exception e) {
                if (e instanceof SubscriptionPipeTimeoutException) {
                    LOGGER.warn(e.getMessage());
                    return;
                }
                LOGGER.warn("{} failed to subscribe topics {} from subscription provider {}, try next subscription provider...", new Object[]{this, topicNames, provider, e});
            }
        }
        String errorMessage = String.format("%s failed to subscribe topics %s from all available subscription providers %s", this, topicNames, providers);
        LOGGER.warn(errorMessage);
        throw new SubscriptionRuntimeCriticalException(errorMessage);
    }

    private void unsubscribeWithRedirection(Set<String> topicNames) throws SubscriptionException {
        List<AbstractSubscriptionProvider> providers = this.providers.getAllAvailableProviders();
        if (providers.isEmpty()) {
            throw new SubscriptionConnectionException(String.format("Cluster has no available subscription providers when %s unsubscribe topic %s", this, topicNames));
        }
        for (AbstractSubscriptionProvider provider : providers) {
            try {
                this.subscribedTopics = provider.unsubscribe(topicNames);
                return;
            }
            catch (Exception e) {
                if (e instanceof SubscriptionPipeTimeoutException) {
                    LOGGER.warn(e.getMessage());
                    return;
                }
                LOGGER.warn("{} failed to unsubscribe topics {} from subscription provider {}, try next subscription provider...", new Object[]{this, topicNames, provider, e});
            }
        }
        String errorMessage = String.format("%s failed to unsubscribe topics %s from all available subscription providers %s", this, topicNames, providers);
        LOGGER.warn(errorMessage);
        throw new SubscriptionRuntimeCriticalException(errorMessage);
    }

    Map<Integer, TEndPoint> fetchAllEndPointsWithRedirection() throws SubscriptionException {
        List<AbstractSubscriptionProvider> providers = this.providers.getAllAvailableProviders();
        if (providers.isEmpty()) {
            throw new SubscriptionConnectionException(String.format("Cluster has no available subscription providers when %s fetch all endpoints", this));
        }
        for (AbstractSubscriptionProvider provider : providers) {
            try {
                return provider.heartbeat().getEndPoints();
            }
            catch (Exception e) {
                LOGGER.warn("{} failed to fetch all endpoints from subscription provider {}, try next subscription provider...", new Object[]{this, provider, e});
            }
        }
        String errorMessage = String.format("%s failed to fetch all endpoints from all available subscription providers %s", this, providers);
        LOGGER.warn(errorMessage);
        throw new SubscriptionRuntimeCriticalException(errorMessage);
    }

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("consumerId", this.consumerId);
        result.put("consumerGroupId", this.consumerGroupId);
        result.put("isClosed", this.isClosed.toString());
        result.put("fileSaveDir", this.fileSaveDir);
        result.put("inFlightFilesCommitContextSet", CollectionUtils.getLimitedString(this.inFlightFilesCommitContextSet, 32));
        result.put("subscribedTopicNames", CollectionUtils.getLimitedString(this.subscribedTopics.keySet(), 32));
        return result;
    }

    protected Map<String, String> allReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("consumerId", this.consumerId);
        result.put("consumerGroupId", this.consumerGroupId);
        result.put("heartbeatIntervalMs", String.valueOf(this.heartbeatIntervalMs));
        result.put("endpointsSyncIntervalMs", String.valueOf(this.endpointsSyncIntervalMs));
        result.put("providers", this.providers.toString());
        result.put("isClosed", this.isClosed.toString());
        result.put("isReleased", this.isReleased.toString());
        result.put("fileSaveDir", this.fileSaveDir);
        result.put("fileSaveFsync", String.valueOf(this.fileSaveFsync));
        result.put("inFlightFilesCommitContextSet", this.inFlightFilesCommitContextSet.toString());
        result.put("thriftMaxFrameSize", String.valueOf(this.thriftMaxFrameSize));
        result.put("maxPollParallelism", String.valueOf(this.maxPollParallelism));
        result.put("subscribedTopics", this.subscribedTopics.toString());
        return result;
    }

    private static /* synthetic */ Optional lambda$singlePoll$0(short responseType, SubscriptionPollResponse resp, PollTimer ignored) {
        LOGGER.warn("unexpected response type: {}", (Object)responseType);
        return Optional.empty();
    }

    private class PollTask
    implements Callable<List<SubscriptionMessage>> {
        private final Set<String> topicNames;
        private final long timeoutMs;

        public PollTask(Set<String> topicNames, long timeoutMs) {
            this.topicNames = topicNames;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public List<SubscriptionMessage> call() {
            return AbstractSubscriptionConsumer.this.singlePoll(this.topicNames, this.timeoutMs);
        }
    }

    private class AsyncCommitWorker
    implements Runnable {
        private final Iterable<SubscriptionMessage> messages;
        private final AsyncCommitCallback callback;

        public AsyncCommitWorker(Iterable<SubscriptionMessage> messages, AsyncCommitCallback callback) {
            this.messages = messages;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (AbstractSubscriptionConsumer.this.isClosed()) {
                return;
            }
            try {
                AbstractSubscriptionConsumer.this.ack(this.messages);
                this.callback.onComplete();
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }
}

