/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.warnings;

import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCode;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCodeSupplier;

public final class IoTDBWarning {
    private final WarningCode warningCode;
    private final String message;

    public IoTDBWarning(WarningCode warningCode, String message) {
        this.warningCode = Objects.requireNonNull(warningCode, "warningCode is null");
        this.message = Objects.requireNonNull(message, "message is null");
    }

    public IoTDBWarning(WarningCodeSupplier warningCodeSupplier, String message) {
        this(warningCodeSupplier.toWarningCode(), message);
    }

    public WarningCode getWarningCode() {
        return this.warningCode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoTDBWarning that = (IoTDBWarning)o;
        return Objects.equals(this.warningCode, that.warningCode) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.warningCode, this.message);
    }

    public String toString() {
        return String.format("%s, %s", this.warningCode, this.message);
    }
}

