/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.LogicalIndexNavigation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternPartitionExecutor;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternVariableRecognizer;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.PatternExpressionComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Matcher;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractTableScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.RowsPerMatch;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SkipToPosition;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class PatternRecognitionOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PatternRecognitionOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    private final List<TSDataType> inputDataTypes;
    private final List<Integer> outputChannels;
    private final TsBlockBuilder tsBlockBuilder;
    private final MemoryReservationManager memoryReservationManager;
    private final List<Integer> partitionChannels;
    private final RowComparator partitionComparator;
    private final List<TsBlock> cachedTsBlocks;
    private int startIndexInFirstBlock;
    private final List<Integer> sortChannels;
    private LinkedList<PatternPartitionExecutor> cachedPartitionExecutors;
    private final RowsPerMatch rowsPerMatch;
    private final SkipToPosition skipToPosition;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final Matcher matcher;
    private final List<PatternVariableRecognizer.PatternVariableComputation> labelPatternVariableComputations;
    private final List<PatternAggregator> patternAggregators;
    private final List<PatternExpressionComputation> measureComputations;
    private final List<String> labelNames;
    private long totalMemorySize;
    private long maxUsedMemory;
    private final long maxRuntime;

    public PatternRecognitionOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputDataTypes, List<TSDataType> outputDataTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Integer> sortChannels, RowsPerMatch rowsPerMatch, SkipToPosition skipToPosition, Optional<LogicalIndexNavigation> skipToNavigation, Matcher matcher, List<PatternVariableRecognizer.PatternVariableComputation> labelPatternVariableComputations, List<PatternAggregator> patternAggregators, List<PatternExpressionComputation> measureComputations, List<String> labelNames) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.inputDataTypes = ImmutableList.copyOf(inputDataTypes);
        this.outputChannels = ImmutableList.copyOf(outputChannels);
        this.tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        this.partitionChannels = ImmutableList.copyOf(partitionChannels);
        ArrayList<TSDataType> partitionDataTypes = new ArrayList<TSDataType>();
        for (Integer channel : partitionChannels) {
            partitionDataTypes.add(inputDataTypes.get(channel));
        }
        this.partitionComparator = new RowComparator(partitionDataTypes);
        this.sortChannels = ImmutableList.copyOf(sortChannels);
        this.cachedPartitionExecutors = new LinkedList();
        this.rowsPerMatch = rowsPerMatch;
        this.skipToPosition = skipToPosition;
        this.skipToNavigation = skipToNavigation;
        this.matcher = matcher;
        this.labelPatternVariableComputations = ImmutableList.copyOf(labelPatternVariableComputations);
        this.patternAggregators = ImmutableList.copyOf(patternAggregators);
        this.measureComputations = ImmutableList.copyOf(measureComputations);
        this.labelNames = ImmutableList.copyOf(labelNames);
        this.cachedTsBlocks = new ArrayList<TsBlock>();
        this.startIndexInFirstBlock = -1;
        this.maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        this.totalMemorySize = 0L;
        this.maxUsedMemory = 0L;
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock tsBlock;
        long startTime = System.nanoTime();
        if (!this.cachedPartitionExecutors.isEmpty() && (tsBlock = this.transform(startTime)) != null) {
            return tsBlock;
        }
        if (this.child.hasNextWithTimer()) {
            TsBlock preSortedBlock = this.child.nextWithTimer();
            if (preSortedBlock == null || preSortedBlock.isEmpty()) {
                return null;
            }
            this.cachedPartitionExecutors = this.partition(preSortedBlock);
            if (this.cachedPartitionExecutors.isEmpty()) {
                return null;
            }
            return this.transform(startTime);
        }
        if (!this.cachedTsBlocks.isEmpty()) {
            TsBlock lastTsBlock = this.cachedTsBlocks.get(this.cachedTsBlocks.size() - 1);
            int endIndexOfLastTsBlock = lastTsBlock.getPositionCount();
            PatternPartitionExecutor partitionExecutor = new PatternPartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, endIndexOfLastTsBlock, this.outputChannels, this.sortChannels, this.rowsPerMatch, this.skipToPosition, this.skipToNavigation, this.matcher, this.labelPatternVariableComputations, this.patternAggregators, this.measureComputations, this.labelNames);
            this.cachedPartitionExecutors.addLast(partitionExecutor);
            this.cachedTsBlocks.clear();
            this.releaseAllCachedTsBlockMemory();
            TsBlock tsBlock2 = this.transform(startTime);
            if (tsBlock2 == null) {
                tsBlock2 = this.tsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)AbstractTableScanOperator.TIME_COLUMN_TEMPLATE, this.tsBlockBuilder.getPositionCount()));
                this.tsBlockBuilder.reset();
            }
            return tsBlock2;
        }
        if (!this.tsBlockBuilder.isEmpty()) {
            return this.getTsBlockFromTsBlockBuilder();
        }
        return null;
    }

    private LinkedList<PatternPartitionExecutor> partition(TsBlock tsBlock) {
        LinkedList<PatternPartitionExecutor> partitionExecutors = new LinkedList<PatternPartitionExecutor>();
        int partitionStartInCurrentBlock = 0;
        int partitionEndInCurrentBlock = partitionStartInCurrentBlock + 1;
        List<Column> partitionColumns = this.extractPartitionColumns(tsBlock);
        if (!this.cachedTsBlocks.isEmpty()) {
            TsBlock lastTsBlock = this.cachedTsBlocks.get(this.cachedTsBlocks.size() - 1);
            int endIndexOfLastTsBlock = lastTsBlock.getPositionCount();
            List<Column> lastPartitionColumns = this.extractPartitionColumns(lastTsBlock);
            if (!this.partitionComparator.equal(partitionColumns, 0, lastPartitionColumns, endIndexOfLastTsBlock - 1)) {
                PatternPartitionExecutor partitionExecutor = new PatternPartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, endIndexOfLastTsBlock, this.outputChannels, this.sortChannels, this.rowsPerMatch, this.skipToPosition, this.skipToNavigation, this.matcher, this.labelPatternVariableComputations, this.patternAggregators, this.measureComputations, this.labelNames);
                partitionExecutors.addLast(partitionExecutor);
                this.cachedTsBlocks.clear();
                this.releaseAllCachedTsBlockMemory();
                this.startIndexInFirstBlock = -1;
            }
        }
        int count = tsBlock.getPositionCount();
        while (count == 1 || partitionEndInCurrentBlock < count) {
            while (partitionEndInCurrentBlock < count && this.partitionComparator.equalColumns(partitionColumns, partitionStartInCurrentBlock, partitionEndInCurrentBlock)) {
                ++partitionEndInCurrentBlock;
            }
            if (partitionEndInCurrentBlock != count) {
                PatternPartitionExecutor partitionExecutor;
                if (partitionStartInCurrentBlock != 0 || this.startIndexInFirstBlock == -1) {
                    partitionExecutor = new PatternPartitionExecutor(Collections.singletonList(tsBlock), this.inputDataTypes, partitionStartInCurrentBlock, partitionEndInCurrentBlock, this.outputChannels, this.sortChannels, this.rowsPerMatch, this.skipToPosition, this.skipToNavigation, this.matcher, this.labelPatternVariableComputations, this.patternAggregators, this.measureComputations, this.labelNames);
                } else {
                    this.reserveOneTsBlockMemory(tsBlock);
                    this.cachedTsBlocks.add(tsBlock);
                    partitionExecutor = new PatternPartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, partitionEndInCurrentBlock, this.outputChannels, this.sortChannels, this.rowsPerMatch, this.skipToPosition, this.skipToNavigation, this.matcher, this.labelPatternVariableComputations, this.patternAggregators, this.measureComputations, this.labelNames);
                    this.cachedTsBlocks.clear();
                    this.releaseAllCachedTsBlockMemory();
                }
                partitionExecutors.addLast(partitionExecutor);
                partitionStartInCurrentBlock = partitionEndInCurrentBlock;
                partitionEndInCurrentBlock = partitionStartInCurrentBlock + 1;
                continue;
            }
            if (this.startIndexInFirstBlock == -1) {
                this.startIndexInFirstBlock = partitionStartInCurrentBlock;
            }
            this.reserveOneTsBlockMemory(tsBlock);
            this.cachedTsBlocks.add(tsBlock);
            break;
        }
        return partitionExecutors;
    }

    private TsBlock transform(long startTime) {
        while (!this.cachedPartitionExecutors.isEmpty()) {
            PatternPartitionExecutor partitionExecutor = this.cachedPartitionExecutors.getFirst();
            while (System.nanoTime() - startTime < this.maxRuntime && !this.tsBlockBuilder.isFull() && partitionExecutor.hasNext()) {
                partitionExecutor.processNextRow(this.tsBlockBuilder);
            }
            if (!partitionExecutor.hasNext()) {
                this.cachedPartitionExecutors.removeFirst();
            }
            if (System.nanoTime() - startTime < this.maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            return this.getTsBlockFromTsBlockBuilder();
        }
        return null;
    }

    private List<Column> extractPartitionColumns(TsBlock tsBlock) {
        ArrayList<Column> partitionColumns = new ArrayList<Column>(this.partitionChannels.size());
        for (int channel : this.partitionChannels) {
            Column partitionColumn = tsBlock.getColumn(channel);
            partitionColumns.add(partitionColumn);
        }
        return partitionColumns;
    }

    private TsBlock getTsBlockFromTsBlockBuilder() {
        TsBlock result = this.tsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)AbstractTableScanOperator.TIME_COLUMN_TEMPLATE, this.tsBlockBuilder.getPositionCount()));
        this.tsBlockBuilder.reset();
        return result;
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.cachedPartitionExecutors.isEmpty() || this.child.hasNext() || !this.cachedTsBlocks.isEmpty() || !this.tsBlockBuilder.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        if (this.totalMemorySize != 0L) {
            this.memoryReservationManager.releaseMemoryCumulatively(this.totalMemorySize);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    private void reserveOneTsBlockMemory(TsBlock tsBlock) {
        long reserved = tsBlock.getTotalInstanceSize();
        this.memoryReservationManager.reserveMemoryCumulatively(reserved);
        this.totalMemorySize += reserved;
        this.maxUsedMemory = Math.max(this.maxUsedMemory, this.totalMemorySize);
        this.operatorContext.recordSpecifiedInfo("MaxReservedMemory", Long.toString(this.maxUsedMemory));
    }

    private void releaseAllCachedTsBlockMemory() {
        long released = this.cachedTsBlocks.stream().mapToInt(TsBlock::getTotalInstanceSize).sum();
        this.memoryReservationManager.releaseMemoryCumulatively(released);
        this.totalMemorySize -= released;
        this.operatorContext.recordSpecifiedInfo("MaxReservedMemory", Long.toString(this.maxUsedMemory));
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemoryFromInput = this.child.calculateMaxPeekMemoryWithCounter();
        long maxPeekMemoryFromCurrent = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
        return Math.max(maxPeekMemoryFromInput, maxPeekMemoryFromCurrent) + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

