/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compatibility.BufferDeserializer;
import org.apache.tsfile.compatibility.CompatibilityUtils;
import org.apache.tsfile.compatibility.DeserializeConfig;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotCompatibleTsFileException;
import org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.tsfile.exception.TsFileRuntimeException;
import org.apache.tsfile.exception.TsFileStatisticsMistakesException;
import org.apache.tsfile.exception.read.FileVersionTooOldException;
import org.apache.tsfile.file.IMetadataIndexEntry;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.AbstractAlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.MeasurementMetadataIndexEntry;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TableDeviceTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.TsFileMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSequenceReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSequenceReader.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final String METADATA_INDEX_NODE_DESERIALIZE_ERROR = "Something error happened while deserializing MetadataIndexNode of file {}";
    private static final int MAX_READ_BUFFER_SIZE = 0x400000;
    protected String file;
    protected TsFileInput tsFileInput;
    protected long fileMetadataPos;
    protected int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    protected volatile TsFileMetadata tsFileMetaData;
    private Map<IDeviceID, Map<String, TimeseriesMetadata>> cachedDeviceMetadata = new ConcurrentHashMap<IDeviceID, Map<String, TimeseriesMetadata>>();
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private boolean cacheDeviceMetadata;
    private long minPlanIndex = Long.MAX_VALUE;
    private long maxPlanIndex = Long.MIN_VALUE;
    private byte fileVersion;
    private DeserializeConfig deserializeConfig = new DeserializeConfig();
    private volatile boolean cacheTableSchemaMap = false;

    public TsFileSequenceReader(String file) throws IOException {
        this(file, null);
    }

    public TsFileSequenceReader(String file, LongConsumer ioSizeRecorder) throws IOException {
        this(file, true, ioSizeRecorder);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize) throws IOException {
        this(file, loadMetadataSize, null);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize, LongConsumer ioSizeRecorder) throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is opened. {}", (Object)file, (Object)this.getClass().getName());
        }
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        try {
            this.loadFileVersion(ioSizeRecorder);
            if (loadMetadataSize) {
                this.loadMetadataSize(ioSizeRecorder);
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(String file, boolean loadMetadata, boolean cacheDeviceMetadata) throws IOException {
        this(file, loadMetadata);
        this.cacheDeviceMetadata = cacheDeviceMetadata;
    }

    public TsFileSequenceReader(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReader(TsFileInput input, boolean loadMetadataSize) throws IOException {
        this.tsFileInput = input;
        this.file = input.getFilePath();
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        this.tsFileInput = input;
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    private void loadFileVersion(LongConsumer ioSizeRecorder) throws IOException {
        try {
            this.tsFileInput.position("TsFile".getBytes(TSFileConfig.STRING_CHARSET).length);
            ByteBuffer buffer = ByteBuffer.allocate(1);
            if (ioSizeRecorder != null) {
                ioSizeRecorder.accept(1L);
            }
            this.tsFileInput.read(buffer);
            buffer.flip();
            this.fileVersion = buffer.get();
            this.checkFileVersion();
            this.configDeserializer();
            this.tsFileInput.position(0L);
        }
        catch (Exception e) {
            this.tsFileInput.close();
            throw new NotCompatibleTsFileException(e);
        }
    }

    private void configDeserializer() {
        if (this.fileVersion == 3) {
            this.deserializeConfig = CompatibilityUtils.v3DeserializeConfig;
        }
    }

    private void checkFileVersion() throws FileVersionTooOldException {
        if (this.fileVersion < 3 || this.fileVersion > 4) {
            throw new FileVersionTooOldException(this.fileVersion, 3, 4);
        }
    }

    public void setEnableCacheTableSchemaMap() {
        this.cacheTableSchemaMap = true;
    }

    public void loadMetadataSize() throws IOException {
        this.loadMetadataSize(null);
    }

    public void loadMetadataSize(LongConsumer ioSizeRecorder) throws IOException {
        int readSize = 4;
        ByteBuffer metadataSize = ByteBuffer.allocate(readSize);
        if (this.readTailMagic().equals("TsFile")) {
            if (ioSizeRecorder != null) {
                ioSizeRecorder.accept(readSize);
            }
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public long getFileMetadataPos() {
        return this.fileMetadataPos;
    }

    public int getTsFileMetadataSize() {
        return this.fileMetadataSize;
    }

    public long getFileMetadataSize() throws IOException {
        return this.tsFileInput.size() - this.getFileMetadataPos();
    }

    public long getAllMetadataSize() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        return this.tsFileInput.size() - this.tsFileMetaData.getMetaOffset();
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".getBytes().length);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        long size = this.tsFileInput.size();
        if (size >= (long)("TsFile".getBytes().length * 2 + 1)) {
            String tailMagic = this.readTailMagic();
            String headMagic = this.readHeadMagic();
            return tailMagic.equals(headMagic);
        }
        return false;
    }

    public String readHeadMagic() throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, 0L);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public byte readVersionNumber() throws IOException {
        ByteBuffer versionNumberByte = ByteBuffer.allocate(1);
        this.tsFileInput.read(versionNumberByte, "TsFile".getBytes(TSFileConfig.STRING_CHARSET).length);
        versionNumberByte.flip();
        return versionNumberByte.get();
    }

    public TsFileMetadata readFileMetadata() throws IOException {
        return this.readFileMetadata(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileMetadata readFileMetadata(LongConsumer ioSizeRecorder) throws IOException {
        block7: {
            try {
                if (this.tsFileMetaData != null) break block7;
                TsFileSequenceReader tsFileSequenceReader = this;
                synchronized (tsFileSequenceReader) {
                    if (this.tsFileMetaData == null) {
                        this.tsFileMetaData = this.forceReadFileMetadata(this.cacheTableSchemaMap, ioSizeRecorder);
                    }
                }
            }
            catch (StopReadTsFileByInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Something error happened while reading file metadata of file {}", (Object)this.file, (Object)e);
                throw e;
            }
        }
        return this.tsFileMetaData;
    }

    public Map<String, TableSchema> getTableSchemaMap() throws IOException {
        return this.getTableSchemaMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TableSchema> getTableSchemaMap(LongConsumer ioSizeRecorder) throws IOException {
        if (this.tsFileMetaData != null && this.tsFileMetaData.hasTableSchemaMapCache()) {
            return this.tsFileMetaData.getTableSchemaMap();
        }
        TsFileMetadata tempTsFileMetadata = this.forceReadFileMetadata(true, ioSizeRecorder);
        if (this.cacheTableSchemaMap) {
            TsFileSequenceReader tsFileSequenceReader = this;
            synchronized (tsFileSequenceReader) {
                this.tsFileMetaData = tempTsFileMetadata;
            }
        }
        return tempTsFileMetadata.getTableSchemaMap();
    }

    private TsFileMetadata forceReadFileMetadata(boolean needTableSchemaMap, LongConsumer ioSizeRecorder) throws IOException {
        ByteBuffer buffer = this.readData(this.fileMetadataPos, this.fileMetadataSize, ioSizeRecorder);
        BufferDeserializer<TsFileMetadata> deserializer = needTableSchemaMap ? this.deserializeConfig.cacheTableSchemaMapTsFileMetadataBufferDeserializer : this.deserializeConfig.tsFileMetadataBufferDeserializer;
        return deserializer.deserialize(buffer, this.deserializeConfig);
    }

    public BloomFilter readBloomFilter() throws IOException {
        return this.readBloomFilter(null);
    }

    public BloomFilter readBloomFilter(LongConsumer ioSizeRecorder) throws IOException {
        this.readFileMetadata(ioSizeRecorder);
        return this.tsFileMetaData.getBloomFilter();
    }

    public EncryptParameter getEncryptParam() throws IOException {
        return this.getEncryptParam(null);
    }

    public EncryptParameter getEncryptParam(LongConsumer ioSizeRecorder) throws IOException {
        if (this.fileMetadataSize != 0) {
            this.readFileMetadata(ioSizeRecorder);
            return this.tsFileMetaData.getEncryptParam();
        }
        return EncryptUtils.getEncryptParameter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimeseriesMetadata> readDeviceMetadata(IDeviceID device) throws IOException {
        if (!this.cacheDeviceMetadata) {
            return this.readDeviceMetadataFromDisk(device);
        }
        cacheLock.readLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        cacheLock.writeLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
            this.readFileMetadata();
            Map<String, TimeseriesMetadata> deviceMetadata = this.readDeviceMetadataFromDisk(device);
            this.cachedDeviceMetadata.put(device, deviceMetadata);
            Map<String, TimeseriesMetadata> map = deviceMetadata;
            return map;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void clearCachedDeviceMetadata() {
        this.cachedDeviceMetadata.clear();
    }

    private Map<String, TimeseriesMetadata> readDeviceMetadataFromDisk(IDeviceID device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataList = this.getDeviceTimeseriesMetadataWithoutChunkMetadata(device);
        HashMap<String, TimeseriesMetadata> deviceMetadata = new HashMap<String, TimeseriesMetadata>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
            deviceMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata);
        }
        return deviceMetadata;
    }

    public TimeseriesMetadata readTimeseriesMetadata(IDeviceID device, String measurement, boolean ignoreNotExists) throws IOException {
        return this.readTimeseriesMetadata(device, measurement, ignoreNotExists, null);
    }

    public TimeseriesMetadata readTimeseriesMetadata(IDeviceID device, String measurement, boolean ignoreNotExistDevice, LongConsumer ioSizeConsumer) throws IOException {
        int searchResult;
        this.readFileMetadata(ioSizeConsumer);
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(device.getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(deviceMetadataIndexNode, device, true, ioSizeConsumer);
        if (metadataIndexPair == null) {
            if (ignoreNotExistDevice) {
                return null;
            }
            throw new IOException("Device {" + device + "} is not in tsFileMetaData of " + this.file);
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right, ioSizeConsumer);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
            }
            catch (Exception e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffsetOfMeasurementNode(metadataIndexNode, measurement, false, ioSizeConsumer);
        }
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        if ((Long)metadataIndexPair.right - ((IMetadataIndexEntry)metadataIndexPair.left).getOffset() < Integer.MAX_VALUE) {
            buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right, ioSizeConsumer);
            while (buffer.hasRemaining()) {
                try {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
                }
                catch (Exception e) {
                    logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                    throw e;
                }
            }
        } else {
            if (ioSizeConsumer != null) {
                ioSizeConsumer.accept((Long)metadataIndexPair.right - ((IMetadataIndexEntry)metadataIndexPair.left).getOffset());
            }
            this.tsFileInput.position(((IMetadataIndexEntry)metadataIndexPair.left).getOffset());
            while (this.tsFileInput.position() < (Long)metadataIndexPair.right) {
                try {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.tsFileInput, true));
                }
                catch (Exception e1) {
                    logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                    throw e1;
                }
            }
        }
        return (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, measurement)) >= 0 ? (TimeseriesMetadata)timeseriesMetadataList.get(searchResult) : null;
    }

    public ITimeSeriesMetadata readITimeseriesMetadata(Path path, boolean ignoreNotExistDevice) throws IOException {
        MetadataIndexNode metadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(path.getIDeviceID().getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(deviceMetadataIndexNode, path.getIDeviceID(), true);
        if (metadataIndexPair == null) {
            if (ignoreNotExistDevice) {
                return null;
            }
            throw new IOException("Device {" + path.getDeviceString() + "} is not in tsFileMetaData of " + this.file);
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        try {
            metadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
        }
        catch (Exception e) {
            logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
            throw e;
        }
        TimeseriesMetadata firstTimeseriesMetadata = this.getTimeColumnMetadata(metadataIndexNode);
        metadataIndexPair = this.getMetadataAndEndOffsetOfMeasurementNode(metadataIndexNode, path.getMeasurement(), false, null);
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            try {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
            }
            catch (Exception e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        if (searchResult >= 0) {
            if (firstTimeseriesMetadata != null) {
                ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                valueTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(searchResult));
                return new AlignedTimeSeriesMetadata(firstTimeseriesMetadata, valueTimeseriesMetadataList);
            }
            return (ITimeSeriesMetadata)timeseriesMetadataList.get(searchResult);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeseriesMetadata> readTimeseriesMetadata(IDeviceID device, String measurement, Set<String> allSensors, boolean ignoreNotExistDevice, LongConsumer ioSizeRecorder) throws IOException {
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getLeafMetadataIndexPair(device, measurement, ioSizeRecorder);
        if (metadataIndexPair == null) {
            if (ignoreNotExistDevice) {
                return Collections.emptyList();
            }
            throw new IOException("Device {" + device + "} is not in tsFileMetaData of " + this.file);
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        if ((Long)metadataIndexPair.right - ((IMetadataIndexEntry)metadataIndexPair.left).getOffset() < Integer.MAX_VALUE) {
            ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right, ioSizeRecorder);
            while (buffer.hasRemaining()) {
                TimeseriesMetadata timeseriesMetadata;
                try {
                    timeseriesMetadata = TimeseriesMetadata.deserializeFrom(buffer, true);
                }
                catch (Exception e) {
                    logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                    throw e;
                }
                if (!allSensors.contains(timeseriesMetadata.getMeasurementId())) continue;
                timeseriesMetadataList.add(timeseriesMetadata);
            }
        } else {
            TsFileSequenceReader tsFileSequenceReader = this;
            synchronized (tsFileSequenceReader) {
                if (ioSizeRecorder != null) {
                    ioSizeRecorder.accept((Long)metadataIndexPair.right - ((IMetadataIndexEntry)metadataIndexPair.left).getOffset());
                }
                this.tsFileInput.position(((IMetadataIndexEntry)metadataIndexPair.left).getOffset());
                while (this.tsFileInput.position() < (Long)metadataIndexPair.right) {
                    TimeseriesMetadata timeseriesMetadata;
                    try {
                        timeseriesMetadata = TimeseriesMetadata.deserializeFrom(this.tsFileInput, true);
                    }
                    catch (StopReadTsFileByInterruptException e) {
                        throw e;
                    }
                    catch (Exception e1) {
                        logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                        throw e1;
                    }
                    if (!allSensors.contains(timeseriesMetadata.getMeasurementId())) continue;
                    timeseriesMetadataList.add(timeseriesMetadata);
                }
            }
        }
        return timeseriesMetadataList;
    }

    private Pair<IMetadataIndexEntry, Long> getLeafMetadataIndexPair(IDeviceID device, String measurement, LongConsumer ioSizeRecorder) throws IOException {
        this.readFileMetadata(ioSizeRecorder);
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(device.getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(deviceMetadataIndexNode, device, true, ioSizeRecorder);
        if (metadataIndexPair == null) {
            return null;
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right, ioSizeRecorder);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
            }
            catch (Exception e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffsetOfMeasurementNode(metadataIndexNode, measurement, false, ioSizeRecorder);
        }
        return metadataIndexPair;
    }

    private MetadataIndexNode getTableRootNode(String tableName) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(tableName);
        if (metadataIndexNode == null && this.fileVersion < 4) {
            metadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode("");
        }
        return metadataIndexNode;
    }

    private MetadataIndexNode getDeviceRootNode(IDeviceID deviceID, MetadataIndexNode startNode) throws IOException {
        MetadataIndexNode measurementMetadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode metadataIndexNode = startNode = startNode != null ? startNode : this.getTableRootNode(deviceID.getTableName());
        if (startNode == null) {
            return null;
        }
        if (startNode.isDeviceLevel()) {
            Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(startNode, deviceID, true);
            if (metadataIndexPair == null) {
                return null;
            }
            ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
            try {
                measurementMetadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
            }
            catch (Exception e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
        } else {
            measurementMetadataIndexNode = startNode;
        }
        return measurementMetadataIndexNode;
    }

    public boolean readITimeseriesMetadata(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNode node, String measurement) throws IOException {
        Pair<IMetadataIndexEntry, Long> measurementMetadataIndexPair = this.getMetadataAndEndOffsetOfMeasurementNode(node, measurement, false, null);
        if (measurementMetadataIndexPair == null) {
            return false;
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)measurementMetadataIndexPair.left).getOffset(), (Long)measurementMetadataIndexPair.right);
        while (buffer.hasRemaining()) {
            try {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
            }
            catch (Exception e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
        }
        return true;
    }

    public List<ITimeSeriesMetadata> readITimeseriesMetadata(IDeviceID device, Set<String> measurements, MetadataIndexNode root, boolean mergeAlignedSeries) throws IOException {
        MetadataIndexNode measurementMetadataIndexNode = this.getDeviceRootNode(device, root);
        if (measurementMetadataIndexNode == null) {
            return Collections.emptyList();
        }
        TimeseriesMetadata timeColumnMetadata = this.getTimeColumnMetadata(measurementMetadataIndexNode);
        ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = timeColumnMetadata != null ? new ArrayList<TimeseriesMetadata>() : null;
        ArrayList<ITimeSeriesMetadata> resultTimeseriesMetadataList = new ArrayList<ITimeSeriesMetadata>();
        ArrayList<String> measurementList = new ArrayList<String>(measurements);
        measurementList.sort(null);
        boolean[] measurementFound = new boolean[measurements.size()];
        int measurementFoundCnt = 0;
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (int i = 0; i < measurementList.size() && measurementFoundCnt < measurementList.size(); ++i) {
            String measurementName = (String)measurementList.get(i);
            timeseriesMetadataList.clear();
            if (measurementFound[i] || !this.readITimeseriesMetadata(timeseriesMetadataList, measurementMetadataIndexNode, measurementName)) continue;
            measurementFoundCnt += this.searchInTimeseriesList(measurementList, i, measurementFound, timeseriesMetadataList, resultTimeseriesMetadataList, timeColumnMetadata, valueTimeseriesMetadataList, mergeAlignedSeries);
        }
        if (valueTimeseriesMetadataList != null && !valueTimeseriesMetadataList.isEmpty()) {
            if (this.tsFileMetaData.getTableSchemaMap().containsKey(device.getTableName())) {
                resultTimeseriesMetadataList.add(new TableDeviceTimeSeriesMetadata(timeColumnMetadata, valueTimeseriesMetadataList));
            } else {
                resultTimeseriesMetadataList.add(new AlignedTimeSeriesMetadata(timeColumnMetadata, valueTimeseriesMetadataList));
            }
        }
        return resultTimeseriesMetadataList;
    }

    private int searchInTimeseriesList(List<String> measurementList, int startIndex, boolean[] measurementFound, List<TimeseriesMetadata> timeseriesMetadataList, List<ITimeSeriesMetadata> resultTimeseriesMetadataList, TimeseriesMetadata timeColumnMetadata, List<TimeseriesMetadata> valueTimeseriesMetadataList, boolean mergeAlignedSeries) {
        int numOfFoundMeasurements = 0;
        for (int j = startIndex; j < measurementList.size(); ++j) {
            int searchResult;
            if (measurementFound[j] || (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, measurementList.get(j))) < 0) continue;
            TimeseriesMetadata valueColumnMetadata = timeseriesMetadataList.get(searchResult);
            if (timeColumnMetadata != null) {
                if (!mergeAlignedSeries) {
                    resultTimeseriesMetadataList.add(new AlignedTimeSeriesMetadata(timeColumnMetadata, Collections.singletonList(valueColumnMetadata)));
                } else if (valueTimeseriesMetadataList != null) {
                    valueTimeseriesMetadataList.add(valueColumnMetadata);
                }
            } else {
                resultTimeseriesMetadataList.add(valueColumnMetadata);
            }
            measurementFound[j] = true;
            ++numOfFoundMeasurements;
        }
        return numOfFoundMeasurements;
    }

    protected int binarySearchInTimeseriesMetadataList(List<TimeseriesMetadata> timeseriesMetadataList, String key) {
        int low = 0;
        int high = timeseriesMetadataList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TimeseriesMetadata midVal = timeseriesMetadataList.get(mid);
            int cmp = midVal.getMeasurementId().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public List<IDeviceID> getAllDevices() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        ArrayList<IDeviceID> deviceIDS = new ArrayList<IDeviceID>();
        for (Map.Entry<String, MetadataIndexNode> entry : this.tsFileMetaData.getTableMetadataIndexNodeMap().entrySet()) {
            deviceIDS.addAll(this.getAllDevices(entry.getValue()));
        }
        return deviceIDS;
    }

    public List<IDeviceID> getAllDevices(MetadataIndexNode metadataIndexNode) throws IOException {
        ArrayList<IDeviceID> deviceList = new ArrayList<IDeviceID>();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            deviceList.addAll(metadataIndexNode.getChildren().stream().map(entry -> ((DeviceMetadataIndexEntry)entry).getDeviceID()).collect(Collectors.toList()));
            return deviceList;
        }
        int metadataIndexListSize = metadataIndexNode.getChildren().size();
        for (int i = 0; i < metadataIndexListSize; ++i) {
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexListSize - 1) {
                endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
            MetadataIndexNode node = this.deserializeConfig.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
            deviceList.addAll(this.getAllDevices(node));
        }
        return deviceList;
    }

    public TsFileDeviceIterator getAllDevicesIteratorWithIsAligned() throws IOException {
        return new TsFileDeviceIterator(this);
    }

    public Map<String, List<ChunkMetadata>> readChunkMetadataInDevice(IDeviceID device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataMap = this.getDeviceTimeseriesMetadata(device);
        if (timeseriesMetadataMap.isEmpty()) {
            return new HashMap<String, List<ChunkMetadata>>();
        }
        LinkedHashMap<String, List<ChunkMetadata>> seriesMetadata = new LinkedHashMap<String, List<ChunkMetadata>>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap) {
            seriesMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getChunkMetadataList().stream().map(chunkMetadata -> (ChunkMetadata)chunkMetadata).collect(Collectors.toList()));
        }
        return seriesMetadata;
    }

    public List<Path> getAllPaths() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (IDeviceID device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (String measurementId : timeseriesMetadataMap.keySet()) {
                paths.add(new Path(device, measurementId, true));
            }
        }
        return paths;
    }

    public Iterator<List<Path>> getPathsIterator() throws IOException {
        this.readFileMetadata();
        final LinkedList<Pair<IDeviceID, Pair<Long, Long>>> queue = new LinkedList<Pair<IDeviceID, Pair<Long, Long>>>();
        for (MetadataIndexNode metadataIndexNode : this.tsFileMetaData.getTableMetadataIndexNodeMap().values()) {
            List<IMetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                IMetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = metadataIndexEntryList.get(i + 1).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.getAllPaths(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), queue);
            }
        }
        return new Iterator<List<Path>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public List<Path> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair startEndPair = (Pair)queue.remove();
                ArrayList<Path> paths = new ArrayList<Path>();
                try {
                    ByteBuffer nextBuffer = TsFileSequenceReader.this.readData((long)((Long)((Pair)startEndPair.right).left), (Long)((Pair)startEndPair.right).right);
                    while (nextBuffer.hasRemaining()) {
                        paths.add(new Path((IDeviceID)startEndPair.left, TimeseriesMetadata.deserializeFrom(nextBuffer, false).getMeasurementId(), true));
                    }
                    return paths;
                }
                catch (IOException e) {
                    throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
                }
            }
        };
    }

    private void getAllPaths(IMetadataIndexEntry metadataIndex, ByteBuffer buffer, IDeviceID deviceId, MetadataIndexNodeType type, Queue<Pair<IDeviceID, Pair<Long, Long>>> queue) throws IOException {
        try {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                deviceId = ((DeviceMetadataIndexEntry)metadataIndex).getDeviceID();
            }
            boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
            MetadataIndexNode metadataIndexNode = this.deserializeConfig.deserializeMetadataIndexNode(buffer, currentChildLevelIsDevice);
            int metadataIndexListSize = metadataIndexNode.getChildren().size();
            for (int i = 0; i < metadataIndexListSize; ++i) {
                long startOffset = metadataIndexNode.getChildren().get(i).getOffset();
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                    queue.add(new Pair<IDeviceID, Pair<Long, Long>>(deviceId, new Pair<Long, Long>(startOffset, endOffset)));
                    continue;
                }
                ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                this.getAllPaths(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), queue);
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while getting all paths of file {}", (Object)this.file);
            throw e;
        }
    }

    public boolean isAlignedDevice(MetadataIndexNode measurementNode) {
        IMetadataIndexEntry entry = measurementNode.getChildren().get(0);
        return "".equals(((MeasurementMetadataIndexEntry)entry).getName());
    }

    TimeseriesMetadata getTimeColumnMetadata(MetadataIndexNode measurementNode) throws IOException {
        if (!this.isAlignedDevice(measurementNode)) {
            return null;
        }
        if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            ByteBuffer buffer = measurementNode.getChildren().size() > 1 ? this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getChildren().get(1).getOffset()) : this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getEndOffset());
            return TimeseriesMetadata.deserializeFrom(buffer, true);
        }
        if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
            ByteBuffer buffer = this.readData(measurementNode.getChildren().get(0).getOffset(), measurementNode.getChildren().get(1).getOffset());
            MetadataIndexNode metadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
            return this.getTimeColumnMetadata(metadataIndexNode);
        }
        return null;
    }

    public Map<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> getTimeseriesMetadataOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        LinkedHashMap<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>>();
        List<IMetadataIndexEntry> childrenEntryList = measurementNode.getChildren();
        for (int i = 0; i < childrenEntryList.size(); ++i) {
            long startOffset = childrenEntryList.get(i).getOffset();
            long endOffset = i == childrenEntryList.size() - 1 ? measurementNode.getEndOffset() : childrenEntryList.get(i + 1).getOffset();
            ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    int metadataStartOffset = nextBuffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(nextBuffer, excludedMeasurementIds, needChunkMetadata);
                    timeseriesMetadataOffsetMap.put(timeseriesMetadata.getMeasurementId(), new Pair<List<IChunkMetadata>, Pair<Long, Long>>(timeseriesMetadata.getChunkMetadataList(), new Pair<Long, Long>(startOffset + (long)metadataStartOffset, startOffset + (long)nextBuffer.position())));
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(nextBuffer, this.deserializeConfig);
            timeseriesMetadataOffsetMap.putAll(this.getTimeseriesMetadataOffsetByDevice(nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata));
        }
        return timeseriesMetadataOffsetMap;
    }

    public List<IChunkMetadata> getChunkMetadataListByTimeseriesMetadataOffset(long startOffset, long endOffset) throws IOException {
        ByteBuffer timeseriesMetadataBuffer = this.readData(startOffset, endOffset);
        TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(timeseriesMetadataBuffer, true);
        return timeseriesMetadata.getChunkMetadataList();
    }

    public void getDeviceTimeseriesMetadata(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        int metadataIndexListSize = measurementNode.getChildren().size();
        for (int i = 0; i < metadataIndexListSize; ++i) {
            long endOffset = measurementNode.getEndOffset();
            if (i != metadataIndexListSize - 1) {
                endOffset = measurementNode.getChildren().get(i + 1).getOffset();
            }
            ByteBuffer nextBuffer = this.readData(measurementNode.getChildren().get(i).getOffset(), endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(nextBuffer, excludedMeasurementIds, needChunkMetadata);
                    if (excludedMeasurementIds.contains(timeseriesMetadata.getMeasurementId())) continue;
                    timeseriesMetadataList.add(timeseriesMetadata);
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(nextBuffer, this.deserializeConfig);
            this.getDeviceTimeseriesMetadata(timeseriesMetadataList, nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata);
        }
    }

    private void generateMetadataIndex(IMetadataIndexEntry metadataIndex, ByteBuffer buffer, IDeviceID deviceId, MetadataIndexNodeType type, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
        this.generateMetadataIndex(metadataIndex, buffer, deviceId, type, timeseriesMetadataMap, needChunkMetadata, needChunkMetadata);
    }

    private void generateMetadataIndex(IMetadataIndexEntry metadataIndex, ByteBuffer buffer, IDeviceID deviceId, MetadataIndexNodeType type, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) throws IOException {
        try {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, needChunkMetadataForNonBlob, needChunkMetadataForBlob));
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = ((DeviceMetadataIndexEntry)metadataIndex).getDeviceID();
                }
                boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
                MetadataIndexNode metadataIndexNode = this.deserializeConfig.deserializeMetadataIndexNode(buffer, currentChildLevelIsDevice);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    if (endOffset - metadataIndexNode.getChildren().get(i).getOffset() < Integer.MAX_VALUE) {
                        ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                        this.generateMetadataIndex(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadataForNonBlob, needChunkMetadataForBlob);
                        continue;
                    }
                    this.generateMetadataIndexUsingTsFileInput(metadataIndexNode.getChildren().get(i), metadataIndexNode.getChildren().get(i).getOffset(), endOffset, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadataForNonBlob, needChunkMetadataForBlob);
                }
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while generating MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    private void generateMetadataIndexUsingTsFileInput(IMetadataIndexEntry metadataIndex, long start, long end, IDeviceID deviceId, MetadataIndexNodeType type, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
        this.generateMetadataIndexUsingTsFileInput(metadataIndex, start, end, deviceId, type, timeseriesMetadataMap, needChunkMetadata, needChunkMetadata);
    }

    private void generateMetadataIndexUsingTsFileInput(IMetadataIndexEntry metadataIndex, long start, long end, IDeviceID deviceId, MetadataIndexNodeType type, Map<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) throws IOException {
        try {
            this.tsFileInput.position(start);
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (this.tsFileInput.position() < end) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.tsFileInput, needChunkMetadataForNonBlob, needChunkMetadataForBlob));
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = ((DeviceMetadataIndexEntry)metadataIndex).getDeviceID();
                }
                boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
                MetadataIndexNode metadataIndexNode = this.deserializeConfig.deserializeMetadataIndexNode(this.tsFileInput.wrapAsInputStream(), currentChildLevelIsDevice);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    this.generateMetadataIndexUsingTsFileInput(metadataIndexNode.getChildren().get(i), metadataIndexNode.getChildren().get(i).getOffset(), endOffset, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadataForNonBlob, needChunkMetadataForBlob);
                }
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while generating MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public Map<IDeviceID, List<TimeseriesMetadata>> getAllTimeseriesMetadata(boolean needChunkMetadata) throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        HashMap<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<IDeviceID, List<TimeseriesMetadata>>();
        for (MetadataIndexNode metadataIndexNode : this.tsFileMetaData.getTableMetadataIndexNodeMap().values()) {
            List<IMetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                IMetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = metadataIndexEntryList.get(i + 1).getOffset();
                }
                if (endOffset - metadataIndexEntry.getOffset() < Integer.MAX_VALUE) {
                    ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                    this.generateMetadataIndex(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                    continue;
                }
                this.generateMetadataIndexUsingTsFileInput(metadataIndexNode.getChildren().get(i), metadataIndexNode.getChildren().get(i).getOffset(), endOffset, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
            }
        }
        return timeseriesMetadataMap;
    }

    public Iterator<Pair<IDeviceID, List<TimeseriesMetadata>>> iterAllTimeseriesMetadata(boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) throws IOException {
        return new TimeseriesMetadataIterator(needChunkMetadataForNonBlob, needChunkMetadataForBlob);
    }

    public List<TimeseriesMetadata> getDeviceTimeseriesMetadataWithoutChunkMetadata(IDeviceID device) throws IOException {
        return this.getDeviceTimeseriesMetadata(device, false);
    }

    public List<TimeseriesMetadata> getDeviceTimeseriesMetadata(IDeviceID device) throws IOException {
        return this.getDeviceTimeseriesMetadata(device, true);
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadata(IDeviceID device, boolean needChunkMetadata) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(device.getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(metadataIndexNode, device, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<IDeviceID, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((IMetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap, needChunkMetadata);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    protected Pair<IMetadataIndexEntry, Long> getMetadataAndEndOffsetOfDeviceNode(MetadataIndexNode metadataIndex, IDeviceID deviceID, boolean exactSearch) throws IOException {
        return this.getMetadataAndEndOffsetOfDeviceNode(metadataIndex, deviceID, exactSearch, null);
    }

    protected Pair<IMetadataIndexEntry, Long> getMetadataAndEndOffsetOfDeviceNode(MetadataIndexNode metadataIndex, IDeviceID deviceID, boolean exactSearch, LongConsumer ioSizeRecorder) throws IOException {
        if (metadataIndex == null) {
            return null;
        }
        if (MetadataIndexNodeType.INTERNAL_MEASUREMENT.equals((Object)metadataIndex.getNodeType()) || MetadataIndexNodeType.LEAF_MEASUREMENT.equals((Object)metadataIndex.getNodeType())) {
            throw new IllegalArgumentException();
        }
        try {
            if (MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)metadataIndex.getNodeType())) {
                Pair<IMetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry(deviceID, false);
                ByteBuffer buffer = this.readData(((IMetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right, ioSizeRecorder);
                return this.getMetadataAndEndOffsetOfDeviceNode(this.deserializeConfig.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig), deviceID, exactSearch, ioSizeRecorder);
            }
            return metadataIndex.getChildIndexEntry(deviceID, exactSearch);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while deserializing MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    protected Pair<IMetadataIndexEntry, Long> getMetadataAndEndOffsetOfMeasurementNode(MetadataIndexNode metadataIndex, String measurement, boolean exactSearch, LongConsumer ioSizeRecorder) throws IOException {
        if (MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)metadataIndex.getNodeType()) || MetadataIndexNodeType.LEAF_DEVICE.equals((Object)metadataIndex.getNodeType())) {
            throw new IllegalArgumentException();
        }
        try {
            if (MetadataIndexNodeType.INTERNAL_MEASUREMENT.equals((Object)metadataIndex.getNodeType())) {
                Pair<IMetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry((Comparable)((Object)measurement), false);
                ByteBuffer buffer = this.readData(((IMetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right, ioSizeRecorder);
                return this.getMetadataAndEndOffsetOfMeasurementNode(this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig), measurement, exactSearch, ioSizeRecorder);
            }
            return metadataIndex.getChildIndexEntry((Comparable)((Object)measurement), exactSearch);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Something error happened while deserializing MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public ChunkGroupHeader readChunkGroupHeader() throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true, this.deserializeConfig.versionNumber);
    }

    public ChunkGroupHeader readChunkGroupHeader(long position, boolean markerRead) throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput, position, markerRead, this.deserializeConfig.versionNumber);
    }

    public void readPlanIndex() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.minPlanIndex = buffer.getLong();
        buffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.maxPlanIndex = buffer.getLong();
    }

    public ChunkHeader readChunkHeader(byte chunkType) throws IOException {
        try {
            return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), chunkType);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    private ChunkHeader readChunkHeader(long position, LongConsumer ioSizeRecorder) throws IOException {
        try {
            return ChunkHeader.deserializeFrom(this.tsFileInput, position, ioSizeRecorder);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public ByteBuffer readChunk(long position, int dataSize) throws IOException {
        return this.readChunk(position, dataSize, null);
    }

    public ByteBuffer readChunk(long position, int dataSize, LongConsumer ioSizeRecorder) throws IOException {
        try {
            return this.readData(position, dataSize, ioSizeRecorder);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public Chunk readMemChunk(long offset) throws IOException {
        return this.readMemChunk(offset, null);
    }

    public Chunk readMemChunk(long offset, LongConsumer ioSizeRecorder) throws IOException {
        try {
            ChunkHeader header = this.readChunkHeader(offset, ioSizeRecorder);
            ByteBuffer buffer = this.readChunk(offset + (long)header.getSerializedSize(), header.getDataSize(), ioSizeRecorder);
            return new Chunk(header, buffer, this.getEncryptParam(ioSizeRecorder));
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        try {
            ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), null);
            ByteBuffer buffer = this.readChunk(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
            return new Chunk(header, buffer, metaData.getDeleteIntervalList(), metaData.getStatistics(), this.getEncryptParam());
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading chunk of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public Chunk readMemChunk(CachedChunkLoaderImpl.ChunkCacheKey chunkCacheKey) throws IOException {
        ChunkHeader header = this.readChunkHeader(chunkCacheKey.getOffsetOfChunkHeader(), null);
        ByteBuffer buffer = this.readChunk(chunkCacheKey.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        return new Chunk(header, buffer, chunkCacheKey.getDeleteIntervalList(), chunkCacheKey.getStatistics(), this.getEncryptParam());
    }

    public Pair<CompressionType, TSEncoding> readTimeseriesCompressionTypeAndEncoding(TimeseriesMetadata timeseriesMetadata) throws IOException {
        String measurementId = timeseriesMetadata.getMeasurementId();
        int measurementIdLength = measurementId.getBytes(TSFileConfig.STRING_CHARSET).length;
        this.position(timeseriesMetadata.getChunkMetadataList().get(0).getOffsetOfChunkHeader() + 1L + (long)ReadWriteForEncodingUtils.varIntSize(measurementIdLength) + (long)measurementIdLength);
        return ChunkHeader.deserializeCompressionTypeAndEncoding(this.tsFileInput.wrapAsInputStream());
    }

    public MeasurementSchema getMeasurementSchema(List<IChunkMetadata> chunkMetadataList) throws IOException {
        if (chunkMetadataList.isEmpty()) {
            return null;
        }
        IChunkMetadata lastChunkMetadata = chunkMetadataList.get(chunkMetadataList.size() - 1);
        ChunkHeader header = this.readChunkHeader(lastChunkMetadata.getOffsetOfChunkHeader(), null);
        return new MeasurementSchema(lastChunkMetadata.getMeasurementUid(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
    }

    public PageHeader readPageHeader(TSDataType type, boolean hasStatistic) throws IOException {
        try {
            return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type, hasStatistic);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading page header of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public void skipPageData(PageHeader header) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() + (long)header.getCompressedSize());
    }

    public ByteBuffer readCompressedPage(PageHeader header) throws IOException {
        return this.readData(-1L, header.getCompressedSize());
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        ByteBuffer buffer = this.readData(-1L, header.getCompressedSize());
        IDecryptor decryptor = IDecryptor.getDecryptor(this.getEncryptParam());
        if (header.getUncompressedSize() == 0) {
            return buffer;
        }
        ByteBuffer finalBuffer = TsFileSequenceReader.decrypt(decryptor, buffer);
        finalBuffer = TsFileSequenceReader.uncompress(type, finalBuffer, header.getUncompressedSize());
        return finalBuffer;
    }

    private static ByteBuffer decrypt(IDecryptor decryptor, ByteBuffer buffer) {
        if (decryptor == null || decryptor.getEncryptionType() == EncryptionType.UNENCRYPTED) {
            return buffer;
        }
        return ByteBuffer.wrap(decryptor.decrypt(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining()));
    }

    private static ByteBuffer uncompress(CompressionType compressionType, ByteBuffer buffer, int uncompressedSize) throws IOException {
        if (compressionType == CompressionType.UNCOMPRESSED) {
            return buffer;
        }
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(compressionType);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(uncompressedSize);
        try {
            unCompressor.uncompress(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + uncompressedSize + "compressed size: " + buffer.remaining() + e.getMessage(), e);
        }
        return uncompressedBuffer;
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    @Override
    public void close() throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is closed.", (Object)this.file);
        }
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    public long fileSize() throws IOException {
        return this.tsFileInput.size();
    }

    protected final ByteBuffer readData(long position, int totalSize) throws IOException {
        return this.readData(position, totalSize, (LongConsumer)null);
    }

    protected ByteBuffer readData(long position, int totalSize, LongConsumer ioSizeRecorder) throws IOException {
        if (ioSizeRecorder != null) {
            ioSizeRecorder.accept(totalSize);
        }
        int allocateSize = Math.min(0x400000, totalSize);
        int allocateNum = (int)Math.ceil((double)totalSize / (double)allocateSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        int bufferLimit = 0;
        for (int i = 0; i < allocateNum; ++i) {
            if (i == allocateNum - 1) {
                allocateSize = totalSize - allocateSize * (allocateNum - 1);
            }
            buffer.limit(bufferLimit += allocateSize);
            if (position < 0L) {
                if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == allocateSize) continue;
                throw new IOException("reach the end of the data");
            }
            long actualReadSize = ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, allocateSize);
            if (actualReadSize != (long)allocateSize) {
                throw new IOException(String.format("reach the end of the data. Size of data that want to read: %s,actual read size: %s, position: %s", allocateSize, actualReadSize, position));
            }
            position += (long)allocateSize;
        }
        buffer.flip();
        return buffer;
    }

    protected final ByteBuffer readData(long start, long end) throws IOException {
        return this.readData(start, end, null);
    }

    protected final ByteBuffer readData(long start, long end, LongConsumer ioSizeRecorder) throws IOException {
        try {
            return this.readData(start, (int)(end - start), ioSizeRecorder);
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Exception {} happened while reading data of {}", (Object)t.getMessage(), (Object)this.file);
            throw t;
        }
    }

    public int readRaw(long position, int length, ByteBuffer target) throws IOException {
        return ReadWriteIOUtils.readAsPossible(this.tsFileInput, target, position, length);
    }

    public long selfCheck(Schema schema, List<ChunkGroupMetadata> chunkGroupMetadataList, boolean fastFinish) throws IOException {
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            return -3L;
        }
        long fileSize = checkFile.length();
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        int headerLength = "TsFile".getBytes().length + 1;
        if (fileSize < (long)headerLength) {
            return -2L;
        }
        if (!"TsFile".equals(this.readHeadMagic())) {
            return -2L;
        }
        this.fileVersion = this.readVersionNumber();
        this.checkFileVersion();
        this.tsFileInput.position(headerLength);
        boolean isComplete = this.isComplete();
        if (fileSize == (long)headerLength) {
            return headerLength;
        }
        if (isComplete) {
            this.loadMetadataSize();
            if (fastFinish) {
                return 0L;
            }
        }
        long truncatedSize = headerLength;
        ArrayList<long[]> timeBatch = new ArrayList<long[]>();
        IDeviceID lastDeviceId = null;
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        HashMap<String, Integer> valueColumn2TimeBatchIndex = new HashMap<String, Integer>();
        try {
            byte marker;
            block23: while ((marker = this.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader chunkHeader = this.readChunkHeader(marker);
                        String measurementID = chunkHeader.getMeasurementID();
                        MeasurementSchema measurementSchema = new MeasurementSchema(measurementID, chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = chunkHeader.getDataType();
                        Statistics<Serializable> chunkStatistics = Statistics.getStatsByType(dataType);
                        int dataSize = chunkHeader.getDataSize();
                        if (dataSize > 0) {
                            if (marker == -127) {
                                timeBatch.add(null);
                            }
                            if ((byte)(chunkHeader.getChunkType() & 0x3F) == 1) {
                                if (marker == 65) {
                                    int timeBatchIndex = valueColumn2TimeBatchIndex.getOrDefault(chunkHeader.getMeasurementID(), 0);
                                    valueColumn2TimeBatchIndex.put(chunkHeader.getMeasurementID(), timeBatchIndex + 1);
                                }
                                while (dataSize > 0) {
                                    PageHeader pageHeader = this.readPageHeader(chunkHeader.getDataType(), true);
                                    if (pageHeader.getUncompressedSize() != 0) {
                                        chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                                    }
                                    this.skipPageData(pageHeader);
                                    dataSize -= pageHeader.getSerializedPageSize();
                                    chunkHeader.increasePageNums(1);
                                }
                            } else {
                                PageHeader pageHeader = this.readPageHeader(chunkHeader.getDataType(), false);
                                Decoder decoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
                                ByteBuffer byteBuffer = this.readPage(pageHeader, chunkHeader.getCompressionType());
                                Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
                                if ((chunkHeader.getChunkType() & 0xFFFFFF80) == -128) {
                                    TimePageReader timePageReader = new TimePageReader(pageHeader, byteBuffer, timeDecoder);
                                    long[] currentTimeBatch = timePageReader.getNextTimeBatch();
                                    timeBatch.add(currentTimeBatch);
                                    for (long currentTime : currentTimeBatch) {
                                        chunkStatistics.update(currentTime);
                                    }
                                } else if ((chunkHeader.getChunkType() & 0x40) == 64) {
                                    ValuePageReader valuePageReader = new ValuePageReader(pageHeader, byteBuffer, chunkHeader.getDataType(), decoder);
                                    int timeBatchIndex = valueColumn2TimeBatchIndex.getOrDefault(chunkHeader.getMeasurementID(), 0);
                                    valueColumn2TimeBatchIndex.put(chunkHeader.getMeasurementID(), timeBatchIndex + 1);
                                    TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch((long[])timeBatch.get(timeBatchIndex));
                                    if (valueBatch != null && valueBatch.length != 0) {
                                        block26: for (int i = 0; i < valueBatch.length; ++i) {
                                            TsPrimitiveType value = valueBatch[i];
                                            if (value == null) continue;
                                            long timeStamp = ((long[])timeBatch.get(timeBatchIndex))[i];
                                            switch (dataType) {
                                                case INT32: 
                                                case DATE: {
                                                    chunkStatistics.update(timeStamp, value.getInt());
                                                    continue block26;
                                                }
                                                case INT64: 
                                                case TIMESTAMP: {
                                                    chunkStatistics.update(timeStamp, value.getLong());
                                                    continue block26;
                                                }
                                                case FLOAT: {
                                                    chunkStatistics.update(timeStamp, value.getFloat());
                                                    continue block26;
                                                }
                                                case DOUBLE: {
                                                    chunkStatistics.update(timeStamp, value.getDouble());
                                                    continue block26;
                                                }
                                                case BOOLEAN: {
                                                    chunkStatistics.update(timeStamp, value.getBoolean());
                                                    continue block26;
                                                }
                                                case TEXT: 
                                                case BLOB: 
                                                case STRING: {
                                                    chunkStatistics.update(timeStamp, value.getBinary());
                                                    continue block26;
                                                }
                                                default: {
                                                    throw new IOException("Unexpected type " + (Object)((Object)dataType));
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    PageReader reader = new PageReader(pageHeader, byteBuffer, chunkHeader.getDataType(), decoder, timeDecoder);
                                    BatchData batchData = reader.getAllSatisfiedPageData();
                                    while (batchData.hasCurrent()) {
                                        switch (dataType) {
                                            case INT32: 
                                            case DATE: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getInt());
                                                break;
                                            }
                                            case INT64: 
                                            case TIMESTAMP: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getLong());
                                                break;
                                            }
                                            case FLOAT: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getFloat());
                                                break;
                                            }
                                            case DOUBLE: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getDouble());
                                                break;
                                            }
                                            case BOOLEAN: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getBoolean());
                                                break;
                                            }
                                            case TEXT: 
                                            case BLOB: 
                                            case STRING: {
                                                chunkStatistics.update(batchData.currentTime(), batchData.getBinary());
                                                break;
                                            }
                                            default: {
                                                throw new IOException("Unexpected type " + (Object)((Object)dataType));
                                            }
                                        }
                                        batchData.next();
                                    }
                                }
                                chunkHeader.increasePageNums(1);
                            }
                        } else if (marker == 69 || marker == 65) {
                            int timeBatchIndex = valueColumn2TimeBatchIndex.getOrDefault(chunkHeader.getMeasurementID(), 0);
                            valueColumn2TimeBatchIndex.put(chunkHeader.getMeasurementID(), timeBatchIndex + 1);
                        }
                        ChunkMetadata currentChunk = new ChunkMetadata(measurementID, dataType, chunkHeader.getEncodingType(), chunkHeader.getCompressionType(), fileOffsetOfChunk, chunkStatistics);
                        chunkMetadataList.add(currentChunk);
                        continue block23;
                    }
                    case 0: {
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (schema != null) {
                                for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                                    schema.registerTimeseries(lastDeviceId, iMeasurementSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                        }
                        chunkMetadataList = new ArrayList();
                        ChunkGroupHeader chunkGroupHeader = this.readChunkGroupHeader();
                        lastDeviceId = chunkGroupHeader.getDeviceID();
                        timeBatch.clear();
                        valueColumn2TimeBatchIndex.clear();
                        continue block23;
                    }
                    case 4: {
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (schema != null) {
                                for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                                    schema.registerTimeseries(lastDeviceId, iMeasurementSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                            lastDeviceId = null;
                        }
                        this.readPlanIndex();
                        truncatedSize = this.position();
                        continue block23;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
            if (lastDeviceId != null) {
                if (schema != null) {
                    for (IMeasurementSchema iMeasurementSchema : measurementSchemaList) {
                        schema.registerTimeseries(lastDeviceId, iMeasurementSchema);
                    }
                }
                chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
            }
            truncatedSize = isComplete ? 0L : this.position() - 1L;
        }
        catch (Exception e) {
            logger.warn("TsFile {} self-check cannot proceed at position {} recovered, because : {}", new Object[]{this.file, this.position(), e.getMessage()});
        }
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            schema.updateTableSchema(chunkGroupMetadata);
        }
        return truncatedSize;
    }

    public long selfCheckWithInfo(String filename, boolean fastFinish, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap) throws IOException, TsFileStatisticsMistakesException {
        String message = " exists statistics mistakes at position ";
        File checkFile = FSFactoryProducer.getFSFactory().getFile(filename);
        if (!checkFile.exists()) {
            return -3L;
        }
        long fileSize = checkFile.length();
        logger.info("file length: " + fileSize);
        int headerLength = "TsFile".getBytes().length + 1;
        if (fileSize < (long)headerLength) {
            return -2L;
        }
        try {
            if (!"TsFile".equals(this.readHeadMagic()) || 4 != this.readVersionNumber()) {
                return -2L;
            }
            this.tsFileInput.position(headerLength);
            if (this.isComplete()) {
                this.loadMetadataSize();
                if (fastFinish) {
                    return 0L;
                }
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error("Error occurred while fast checking TsFile.");
            throw e;
        }
        for (Map.Entry<Long, Pair<Path, TimeseriesMetadata>> entry : timeseriesMetadataMap.entrySet()) {
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)entry.getValue().right;
            TSDataType dataType = timeseriesMetadata.getTsDataType();
            Statistics<? extends Serializable> timeseriesMetadataSta = timeseriesMetadata.getStatistics();
            Statistics<Serializable> chunkMetadatasSta = Statistics.getStatsByType(dataType);
            for (IChunkMetadata iChunkMetadata : this.getChunkMetadataList((Path)entry.getValue().left)) {
                long tscheckStatus = 0L;
                try {
                    tscheckStatus = this.checkChunkAndPagesStatistics(iChunkMetadata);
                }
                catch (StopReadTsFileByInterruptException e) {
                    throw e;
                }
                catch (IOException e) {
                    logger.error("Error occurred while checking the statistics of chunk and its pages");
                    throw e;
                }
                if (tscheckStatus == -1L) {
                    throw new TsFileStatisticsMistakesException("Chunk" + message + iChunkMetadata.getOffsetOfChunkHeader());
                }
                chunkMetadatasSta.mergeStatistics(iChunkMetadata.getStatistics());
            }
            if (timeseriesMetadataSta.equals(chunkMetadatasSta)) continue;
            long timeseriesMetadataPos = entry.getKey();
            throw new TsFileStatisticsMistakesException("TimeseriesMetadata" + message + timeseriesMetadataPos);
        }
        return 0L;
    }

    public long checkChunkAndPagesStatistics(IChunkMetadata chunkMetadata) throws IOException {
        long offsetOfChunkHeader = chunkMetadata.getOffsetOfChunkHeader();
        this.tsFileInput.position(offsetOfChunkHeader);
        byte marker = this.readMarker();
        ChunkHeader chunkHeader = this.readChunkHeader(marker);
        TSDataType dataType = chunkHeader.getDataType();
        Statistics<Serializable> chunkStatistics = Statistics.getStatsByType(dataType);
        if ((byte)(chunkHeader.getChunkType() & 0x3F) == 1) {
            PageHeader pageHeader;
            for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                pageHeader = this.readPageHeader(chunkHeader.getDataType(), true);
                chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                this.skipPageData(pageHeader);
                chunkHeader.increasePageNums(1);
            }
        } else {
            PageHeader pageHeader = this.readPageHeader(chunkHeader.getDataType(), false);
            Decoder valueDecoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
            ByteBuffer pageData = this.readPage(pageHeader, chunkHeader.getCompressionType());
            Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
            PageReader reader = new PageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder);
            BatchData batchData = reader.getAllSatisfiedPageData();
            while (batchData.hasCurrent()) {
                switch (dataType) {
                    case INT32: 
                    case DATE: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getInt());
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getLong());
                        break;
                    }
                    case FLOAT: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getFloat());
                        break;
                    }
                    case DOUBLE: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getDouble());
                        break;
                    }
                    case BOOLEAN: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getBoolean());
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        chunkStatistics.update(batchData.currentTime(), batchData.getBinary());
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected type " + (Object)((Object)dataType));
                    }
                }
                batchData.next();
            }
            chunkHeader.increasePageNums(1);
        }
        if (chunkMetadata.getStatistics().equals(chunkStatistics)) {
            return 0L;
        }
        return -1L;
    }

    public List<ChunkMetadata> getChunkMetadataList(IDeviceID deviceID, String measurement, boolean ignoreNotExists) throws IOException {
        TimeseriesMetadata timeseriesMetaData = this.readTimeseriesMetadata(deviceID, measurement, ignoreNotExists);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<ChunkMetadata> chunkMetadataList = this.readChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    @Deprecated
    public List<ChunkMetadata> getChunkMetadataList(Path path, boolean ignoreNotExists) throws IOException {
        return this.getChunkMetadataList(path.getIDeviceID(), path.getMeasurement(), ignoreNotExists);
    }

    public List<IChunkMetadata> getIChunkMetadataList(Path path) throws IOException {
        ITimeSeriesMetadata timeseriesMetaData = this.readITimeseriesMetadata(path, true);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<IChunkMetadata> chunkMetadataList = this.readIChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<IChunkMetadata> getIChunkMetadataList(IDeviceID deviceID, String measurementName) throws IOException {
        List<ITimeSeriesMetadata> timeseriesMetaData = this.readITimeseriesMetadata(deviceID, Collections.singleton(measurementName), null, false);
        if (timeseriesMetaData == null || timeseriesMetaData.isEmpty()) {
            return Collections.emptyList();
        }
        List<IChunkMetadata> chunkMetadataList = this.readIChunkMetaDataList(timeseriesMetaData.get(0));
        chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<List<IChunkMetadata>> getIChunkMetadataList(IDeviceID deviceID, Set<String> measurementNames, MetadataIndexNode root) throws IOException {
        List<ITimeSeriesMetadata> timeseriesMetaData = this.readITimeseriesMetadata(deviceID, measurementNames, root, true);
        if (timeseriesMetaData == null || timeseriesMetaData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<IChunkMetadata>> results = new ArrayList<List<IChunkMetadata>>(timeseriesMetaData.size());
        for (ITimeSeriesMetadata timeseriesMetaDatum : timeseriesMetaData) {
            List<IChunkMetadata> chunkMetadataList = this.readIChunkMetaDataList(timeseriesMetaDatum);
            chunkMetadataList.sort(Comparator.comparingLong(IChunkMetadata::getStartTime));
            results.add(chunkMetadataList);
        }
        return results;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path) throws IOException {
        return this.getChunkMetadataList(path, true);
    }

    public List<AbstractAlignedChunkMetadata> getAlignedChunkMetadata(IDeviceID device, boolean ignoreAllNullRows) throws IOException {
        MetadataIndexNode metadataIndexNode;
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(device.getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(deviceMetadataIndexNode, device, true);
        if (metadataIndexPair == null) {
            throw new IOException("Device {" + device + "} is not in tsFileMetaData");
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        try {
            metadataIndexNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
        }
        catch (Exception e) {
            logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
            throw e;
        }
        return this.getAlignedChunkMetadataByMetadataIndexNode(device, metadataIndexNode, ignoreAllNullRows);
    }

    public List<AbstractAlignedChunkMetadata> getAlignedChunkMetadataByMetadataIndexNode(IDeviceID device, MetadataIndexNode metadataIndexNode, boolean ignoreAllNullRows) throws IOException {
        TimeseriesMetadata firstTimeseriesMetadata = this.getTimeColumnMetadata(metadataIndexNode);
        if (firstTimeseriesMetadata == null) {
            throw new IOException("Timeseries of device {" + device + "} are not aligned");
        }
        TreeMap<IDeviceID, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<IDeviceID, List<TimeseriesMetadata>>();
        List<IMetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            IMetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
                }
                timeseriesMetadataMap.computeIfAbsent(device, k -> new ArrayList()).addAll(timeseriesMetadataList);
                continue;
            }
            this.generateMetadataIndex(metadataIndexEntry, buffer, device, metadataIndexNode.getNodeType(), timeseriesMetadataMap, true);
        }
        if (timeseriesMetadataMap.values().size() != 1) {
            throw new IOException(String.format("Error when reading timeseriesMetadata of device %s in file %s: should only one timeseriesMetadataList in one device, actual: %d", device, this.file, timeseriesMetadataMap.values().size()));
        }
        List timeseriesMetadataList = (List)timeseriesMetadataMap.values().iterator().next();
        TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeseriesMetadataList.get(0);
        ArrayList<TimeseriesMetadata> valueTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (int i = 1; i < timeseriesMetadataList.size(); ++i) {
            valueTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(i));
        }
        AbstractAlignedTimeSeriesMetadata alignedTimeSeriesMetadata = ignoreAllNullRows ? new AlignedTimeSeriesMetadata(timeseriesMetadata, valueTimeseriesMetadataList) : new TableDeviceTimeSeriesMetadata(timeseriesMetadata, valueTimeseriesMetadataList);
        ArrayList<AbstractAlignedChunkMetadata> chunkMetadataList = new ArrayList<AbstractAlignedChunkMetadata>();
        for (IChunkMetadata chunkMetadata : this.readIChunkMetaDataList(alignedTimeSeriesMetadata)) {
            chunkMetadataList.add((AbstractAlignedChunkMetadata)chunkMetadata);
        }
        return chunkMetadataList;
    }

    public List<ChunkMetadata> readChunkMetaDataList(TimeseriesMetadata timeseriesMetaData) throws IOException {
        return timeseriesMetaData.getChunkMetadataList().stream().map(chunkMetadata -> (ChunkMetadata)chunkMetadata).collect(Collectors.toList());
    }

    public List<IChunkMetadata> readIChunkMetaDataList(ITimeSeriesMetadata timeseriesMetaData) {
        if (timeseriesMetaData instanceof AbstractAlignedTimeSeriesMetadata) {
            return new ArrayList<IChunkMetadata>(((AbstractAlignedTimeSeriesMetadata)timeseriesMetaData).getChunkMetadataList());
        }
        return new ArrayList<IChunkMetadata>(((TimeseriesMetadata)timeseriesMetaData).getChunkMetadataList());
    }

    public Map<String, TSDataType> getAllMeasurements() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (IDeviceID device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTsDataType());
            }
        }
        return result;
    }

    public Map<String, TSDataType> getFullPathDataTypeMap() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (IDeviceID device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(device.toString() + "." + timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTsDataType());
            }
        }
        return result;
    }

    public Map<IDeviceID, List<String>> getDeviceMeasurementsMap() throws IOException {
        HashMap<IDeviceID, List<String>> result = new HashMap<IDeviceID, List<String>>();
        for (IDeviceID device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.computeIfAbsent(device, d -> new ArrayList()).add(timeseriesMetadata.getMeasurementId());
            }
        }
        return result;
    }

    public List<IDeviceID> getDeviceNameInRange(long start, long end) throws IOException {
        ArrayList<IDeviceID> res = new ArrayList<IDeviceID>();
        for (IDeviceID device : this.getAllDevices()) {
            Map<String, List<ChunkMetadata>> seriesMetadataMap = this.readChunkMetadataInDevice(device);
            if (!this.hasDataInPartition(seriesMetadataMap, start, end)) continue;
            res.add(device);
        }
        return res;
    }

    public MetadataIndexNode readMetadataIndexNode(long startOffset, long endOffset, boolean isDeviceLevel) throws IOException {
        ByteBuffer buffer = this.readData(startOffset, endOffset);
        MetadataIndexNode metadataIndexNode = isDeviceLevel ? this.deserializeConfig.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig) : this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
        return metadataIndexNode;
    }

    private boolean hasDataInPartition(Map<String, List<ChunkMetadata>> seriesMetadataMap, long start, long end) {
        for (List<ChunkMetadata> chunkMetadataList : seriesMetadataMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                LocateStatus location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata, start, end);
                if (location != LocateStatus.IN) continue;
                return true;
            }
        }
        return false;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public Iterator<Map<String, List<ChunkMetadata>>> getMeasurementChunkMetadataListMapIterator(IDeviceID device) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getTableMetadataIndexNode(device.getTableName());
        Pair<IMetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffsetOfDeviceNode(metadataIndexNode, device, true);
        if (metadataIndexPair == null) {
            return new Iterator<Map<String, List<ChunkMetadata>>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LinkedHashMap<String, List<ChunkMetadata>> next() {
                    throw new NoSuchElementException();
                }
            };
        }
        ByteBuffer buffer = this.readData(((IMetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode firstMeasurementNode = this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(buffer, this.deserializeConfig);
        return this.getMeasurementChunkMetadataListMapIterator(firstMeasurementNode);
    }

    public Iterator<Map<String, List<ChunkMetadata>>> getMeasurementChunkMetadataListMapIterator(MetadataIndexNode firstMeasurementMetadataIndexNodeOfDevice) throws IOException {
        final LinkedList<Pair<Long, Long>> queue = new LinkedList<Pair<Long, Long>>();
        this.collectEachLeafMeasurementNodeOffsetRange(firstMeasurementMetadataIndexNodeOfDevice, queue);
        return new Iterator<Map<String, List<ChunkMetadata>>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public LinkedHashMap<String, List<ChunkMetadata>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair startEndPair = (Pair)queue.remove();
                LinkedHashMap<String, List<ChunkMetadata>> measurementChunkMetadataList = new LinkedHashMap<String, List<ChunkMetadata>>();
                try {
                    ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                    ByteBuffer nextBuffer = TsFileSequenceReader.this.readData((long)((Long)startEndPair.left), (Long)startEndPair.right);
                    while (nextBuffer.hasRemaining()) {
                        timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(nextBuffer, true));
                    }
                    for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                        List list = measurementChunkMetadataList.computeIfAbsent(timeseriesMetadata.getMeasurementId(), m -> new ArrayList());
                        for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                            list.add((ChunkMetadata)chunkMetadata);
                        }
                    }
                    return measurementChunkMetadataList;
                }
                catch (IOException e) {
                    throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
                }
            }
        };
    }

    private void collectEachLeafMeasurementNodeOffsetRange(MetadataIndexNode metadataIndexNode, Queue<Pair<Long, Long>> queue) throws IOException {
        try {
            MetadataIndexNodeType metadataIndexNodeType = metadataIndexNode.getNodeType();
            int metadataIndexListSize = metadataIndexNode.getChildren().size();
            for (int i = 0; i < metadataIndexListSize; ++i) {
                long startOffset = metadataIndexNode.getChildren().get(i).getOffset();
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if (metadataIndexNodeType.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                    queue.add(new Pair<Long, Long>(startOffset, endOffset));
                    continue;
                }
                this.collectEachLeafMeasurementNodeOffsetRange(this.deserializeConfig.measurementMetadataIndexNodeBufferDeserializer.deserialize(this.readData(startOffset, endOffset), this.deserializeConfig), queue);
            }
        }
        catch (StopReadTsFileByInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error occurred while collecting offset ranges of measurement nodes of file {}", (Object)this.file);
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileSequenceReader reader = (TsFileSequenceReader)o;
        return this.file.equals(reader.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public DeserializeConfig getDeserializeContext() {
        return this.deserializeConfig;
    }

    private class TimeseriesMetadataIterator
    implements Iterator<Pair<IDeviceID, List<TimeseriesMetadata>>> {
        private final Deque<MetadataIndexNode> nodeStack = new ArrayDeque<MetadataIndexNode>();
        private final boolean needChunkMetadataForNonBlob;
        private final boolean needCHunkMetadataForBlob;
        private Pair<IDeviceID, List<TimeseriesMetadata>> nextValue;
        private MetadataIndexNode currentLeafDeviceNode;
        private int currentLeafDeviceNodeIndex;

        public TimeseriesMetadataIterator(boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) throws IOException {
            this.needChunkMetadataForNonBlob = needChunkMetadataForNonBlob;
            this.needCHunkMetadataForBlob = needChunkMetadataForBlob;
            if (TsFileSequenceReader.this.tsFileMetaData == null) {
                TsFileSequenceReader.this.readFileMetadata();
            }
            this.nodeStack.addAll(TsFileSequenceReader.this.tsFileMetaData.getTableMetadataIndexNodeMap().values());
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            try {
                this.loadNextValue();
            }
            catch (IOException e) {
                logger.warn("Cannot read timeseries metadata from {},", (Object)TsFileSequenceReader.this.file, (Object)e);
                return false;
            }
            return this.nextValue != null;
        }

        @Override
        public Pair<IDeviceID, List<TimeseriesMetadata>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair<IDeviceID, List<TimeseriesMetadata>> ret = this.nextValue;
            this.nextValue = null;
            return ret;
        }

        private void loadNextLeafDeviceNode() throws IOException {
            while (!this.nodeStack.isEmpty()) {
                MetadataIndexNode node = this.nodeStack.pop();
                MetadataIndexNodeType nodeType = node.getNodeType();
                if (nodeType.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    this.currentLeafDeviceNode = node;
                    this.currentLeafDeviceNodeIndex = 0;
                    return;
                }
                List<IMetadataIndexEntry> childrenIndex = node.getChildren();
                for (int i = 0; i < childrenIndex.size(); ++i) {
                    MetadataIndexNode child;
                    IMetadataIndexEntry childIndex = childrenIndex.get(i);
                    long endOffset = node.getEndOffset();
                    if (i != childrenIndex.size() - 1) {
                        endOffset = childrenIndex.get(i + 1).getOffset();
                    }
                    if (endOffset - childIndex.getOffset() < Integer.MAX_VALUE) {
                        ByteBuffer buffer = TsFileSequenceReader.this.readData(childIndex.getOffset(), endOffset);
                        child = TsFileSequenceReader.this.deserializeConfig.deserializeMetadataIndexNode(buffer, true);
                    } else {
                        TsFileSequenceReader.this.tsFileInput.position(childIndex.getOffset());
                        child = TsFileSequenceReader.this.deserializeConfig.deserializeMetadataIndexNode(TsFileSequenceReader.this.tsFileInput.wrapAsInputStream(), true);
                    }
                    this.nodeStack.push(child);
                }
            }
        }

        private void loadNextValue() throws IOException {
            if (this.currentLeafDeviceNode == null || this.currentLeafDeviceNodeIndex >= this.currentLeafDeviceNode.getChildren().size()) {
                this.currentLeafDeviceNode = null;
                this.loadNextLeafDeviceNode();
            }
            if (this.currentLeafDeviceNode == null) {
                return;
            }
            IMetadataIndexEntry childIndex = this.currentLeafDeviceNode.getChildren().get(this.currentLeafDeviceNodeIndex);
            int childNum = this.currentLeafDeviceNode.getChildren().size();
            IDeviceID deviceId = ((DeviceMetadataIndexEntry)childIndex).getDeviceID();
            HashMap nextValueMap = new HashMap(1);
            long endOffset = this.currentLeafDeviceNode.getEndOffset();
            if (this.currentLeafDeviceNodeIndex != childNum - 1) {
                endOffset = this.currentLeafDeviceNode.getChildren().get(this.currentLeafDeviceNodeIndex + 1).getOffset();
            }
            if (endOffset - childIndex.getOffset() < Integer.MAX_VALUE) {
                ByteBuffer nextBuffer = TsFileSequenceReader.this.readData(childIndex.getOffset(), endOffset);
                TsFileSequenceReader.this.generateMetadataIndex(childIndex, nextBuffer, deviceId, this.currentLeafDeviceNode.getNodeType(), nextValueMap, this.needChunkMetadataForNonBlob, this.needCHunkMetadataForBlob);
            } else {
                TsFileSequenceReader.this.generateMetadataIndexUsingTsFileInput(childIndex, childIndex.getOffset(), endOffset, deviceId, this.currentLeafDeviceNode.getNodeType(), nextValueMap, this.needChunkMetadataForNonBlob, this.needCHunkMetadataForBlob);
            }
            ++this.currentLeafDeviceNodeIndex;
            Map.Entry entry = nextValueMap.entrySet().iterator().next();
            this.nextValue = new Pair<IDeviceID, List>((IDeviceID)entry.getKey(), (List)entry.getValue());
        }
    }

    public static enum LocateStatus {
        IN,
        BEFORE,
        AFTER;

    }
}

