/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.trigger;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@NotThreadSafe
public class TriggerTable {
    private final Map<String, TriggerInformation> triggerTable;

    public TriggerTable() {
        this.triggerTable = new ConcurrentHashMap<String, TriggerInformation>();
    }

    public TriggerTable(Map<String, TriggerInformation> triggerTable) {
        this.triggerTable = triggerTable;
    }

    public void addTriggerInformation(String triggerName, TriggerInformation triggerInformation) {
        this.triggerTable.put(triggerName, triggerInformation);
    }

    public TriggerInformation getTriggerInformation(String triggerName) {
        return this.triggerTable.get(triggerName);
    }

    public TriggerInformation removeTriggerInformation(String triggerName) {
        return this.triggerTable.remove(triggerName);
    }

    public void deleteTriggerInformation(String triggerName) {
        this.triggerTable.remove(triggerName);
    }

    public boolean containsTrigger(String triggerName) {
        return this.triggerTable.containsKey(triggerName);
    }

    public void setTriggerState(String triggerName, TTriggerState triggerState) {
        this.triggerTable.get(triggerName).setTriggerState(triggerState);
    }

    public List<TriggerInformation> getAllTriggerInformation() {
        return new ArrayList<TriggerInformation>(this.triggerTable.values());
    }

    public List<TriggerInformation> getAllStatefulTriggerInformation() {
        return this.triggerTable.values().stream().filter(TriggerInformation::isStateful).collect(Collectors.toList());
    }

    public TDataNodeLocation getTriggerLocation(String triggerName) {
        TriggerInformation triggerInformation = this.triggerTable.get(triggerName);
        return triggerInformation == null ? null : triggerInformation.getDataNodeLocation();
    }

    public List<String> getTransferringTriggers() {
        return this.triggerTable.values().stream().filter(triggerInformation -> triggerInformation.getTriggerState() == TTriggerState.TRANSFERRING).map(TriggerInformation::getTriggerName).collect(Collectors.toList());
    }

    public void updateTriggersOnTransferNodes(List<TDataNodeLocation> transferNodes) {
        HashSet<TDataNodeLocation> dataNodeLocationSet = new HashSet<TDataNodeLocation>(transferNodes);
        this.triggerTable.values().forEach(triggerInformation -> {
            if (triggerInformation.isStateful() && dataNodeLocationSet.contains(triggerInformation.getDataNodeLocation())) {
                triggerInformation.setTriggerState(TTriggerState.TRANSFERRING);
            }
        });
    }

    public void updateTriggerLocation(String triggerName, TDataNodeLocation dataNodeLocation) {
        TriggerInformation triggerInformation = this.triggerTable.get(triggerName);
        triggerInformation.setDataNodeLocation(dataNodeLocation);
        this.triggerTable.put(triggerName, triggerInformation);
    }

    public boolean isEmpty() {
        return this.triggerTable.isEmpty();
    }

    @TestOnly
    public Map<String, TriggerInformation> getTable() {
        return this.triggerTable;
    }

    public void serializeTriggerTable(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.triggerTable.size(), (OutputStream)outputStream);
        for (TriggerInformation triggerInformation : this.triggerTable.values()) {
            ReadWriteIOUtils.write((ByteBuffer)triggerInformation.serialize(), (OutputStream)outputStream);
        }
    }

    public void deserializeTriggerTable(InputStream inputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            TriggerInformation triggerInformation = TriggerInformation.deserialize(inputStream);
            this.triggerTable.put(triggerInformation.getTriggerName(), triggerInformation);
        }
    }

    public void clear() {
        this.triggerTable.clear();
    }
}

