/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RelationalAuthorStatement;

public class RelationalAuthorizerTask
implements IConfigTask {
    private final RelationalAuthorStatement statement;

    public RelationalAuthorizerTask(RelationalAuthorStatement statement) {
        this.statement = statement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        if (this.statement.getQueryType() == QueryType.WRITE) {
            return AuthorityChecker.operatePermission(this.statement);
        }
        return AuthorityChecker.queryPermission(this.statement);
    }
}

