/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSavingStateFactory;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;

public abstract class AbstractApproxMostFrequentAccumulator<T>
implements TableAccumulator {
    protected SpaceSavingStateFactory.SingleSpaceSavingState<T> state = SpaceSavingStateFactory.createSingleState();

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        columnBuilder.writeBinary(new Binary(this.state.getSpaceSaving().serialize()));
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeBinary(new Binary(new Gson().toJson(this.state.getSpaceSaving().getBuckets()), StandardCharsets.UTF_8));
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException("ApproxMostFrequentAccumulator does not support statistics");
    }

    @Override
    public void reset() {
        this.state.getSpaceSaving().reset();
    }
}

