/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.chunk.AbstractChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.page.AbstractAlignedPageReader;
import org.apache.tsfile.read.reader.page.LazyLoadPageData;

public abstract class AbstractAlignedChunkReader
extends AbstractChunkReader {
    private final ChunkHeader timeChunkHeader;
    private final ByteBuffer timeChunkDataBuffer;
    private final List<ChunkHeader> valueChunkHeaderList = new ArrayList<ChunkHeader>();
    private final List<ByteBuffer> valueChunkDataBufferList = new ArrayList<ByteBuffer>();
    private final List<List<TimeRange>> valueDeleteIntervalsList = new ArrayList<List<TimeRange>>();
    protected final List<TimeRange> timeDeleteIntervalList;
    private final EncryptParameter encryptParam;

    AbstractAlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, long readStopTime, Filter queryFilter) throws IOException {
        super(readStopTime, queryFilter);
        this.timeChunkHeader = timeChunk.getHeader();
        this.timeChunkDataBuffer = timeChunk.getData();
        this.timeDeleteIntervalList = timeChunk.getDeleteIntervalList();
        ArrayList<Statistics<? extends Serializable>> valueChunkStatisticsList = new ArrayList<Statistics<? extends Serializable>>();
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueChunkDataBufferList.add(chunk == null ? null : chunk.getData());
            this.valueDeleteIntervalsList.add(chunk == null ? null : chunk.getDeleteIntervalList());
            valueChunkStatisticsList.add(chunk == null ? null : chunk.getChunkStatistic());
        });
        this.encryptParam = timeChunk.getEncryptParam();
        this.initAllPageReaders(timeChunk.getChunkStatistic(), valueChunkStatisticsList);
    }

    private void initAllPageReaders(Statistics<? extends Serializable> timeChunkStatistics, List<Statistics<? extends Serializable>> valueChunkStatisticsList) throws IOException {
        while (this.timeChunkDataBuffer.remaining() > 0) {
            AbstractAlignedPageReader alignedPageReader = this.isSinglePageChunk() ? this.deserializeFromSinglePageChunk(timeChunkStatistics, valueChunkStatisticsList) : this.deserializeFromMultiPageChunk();
            if (alignedPageReader == null) continue;
            this.pageReaderList.add(alignedPageReader);
        }
    }

    private boolean isSinglePageChunk() {
        return (this.timeChunkHeader.getChunkType() & 0x3F) == 5;
    }

    private AbstractAlignedPageReader deserializeFromSinglePageChunk(Statistics<? extends Serializable> timeChunkStatistics, List<Statistics<? extends Serializable>> valueChunkStatisticsList) throws IOException {
        PageHeader timePageHeader = PageHeader.deserializeFrom(this.timeChunkDataBuffer, timeChunkStatistics);
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        boolean isAllNull = true;
        for (int i = 0; i < this.valueChunkDataBufferList.size(); ++i) {
            if (this.valueChunkDataBufferList.get(i) != null) {
                isAllNull = false;
                valuePageHeaderList.add(PageHeader.deserializeFrom(this.valueChunkDataBufferList.get(i), valueChunkStatisticsList.get(i)));
                continue;
            }
            valuePageHeaderList.add(null);
        }
        if (this.needSkipForSinglePageChunk(isAllNull, timePageHeader)) {
            this.skipCurrentPage(timePageHeader, valuePageHeaderList);
            return null;
        }
        return this.constructAlignedPageReader(timePageHeader, valuePageHeaderList);
    }

    abstract boolean needSkipForSinglePageChunk(boolean var1, PageHeader var2);

    private AbstractAlignedPageReader deserializeFromMultiPageChunk() throws IOException {
        PageHeader timePageHeader = PageHeader.deserializeFrom(this.timeChunkDataBuffer, this.timeChunkHeader.getDataType());
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        boolean isAllNull = true;
        for (int i = 0; i < this.valueChunkDataBufferList.size(); ++i) {
            if (this.valueChunkDataBufferList.get(i) != null) {
                isAllNull = false;
                valuePageHeaderList.add(PageHeader.deserializeFrom(this.valueChunkDataBufferList.get(i), this.valueChunkHeaderList.get(i).getDataType()));
                continue;
            }
            valuePageHeaderList.add(null);
        }
        if (this.needSkipForMultiPageChunk(isAllNull, timePageHeader)) {
            this.skipCurrentPage(timePageHeader, valuePageHeaderList);
            return null;
        }
        return this.constructAlignedPageReader(timePageHeader, valuePageHeaderList);
    }

    abstract boolean needSkipForMultiPageChunk(boolean var1, PageHeader var2);

    protected boolean isEarlierThanReadStopTime(PageHeader timePageHeader) {
        return timePageHeader.getEndTime() < this.readStopTime;
    }

    protected boolean pageCanSkip(PageHeader pageHeader) {
        return this.queryFilter != null && !this.queryFilter.satisfyStartEndTime(pageHeader.getStartTime(), pageHeader.getEndTime());
    }

    private void skipCurrentPage(PageHeader timePageHeader, List<PageHeader> valuePageHeader) {
        this.timeChunkDataBuffer.position(this.timeChunkDataBuffer.position() + timePageHeader.getCompressedSize());
        for (int i = 0; i < valuePageHeader.size(); ++i) {
            if (valuePageHeader.get(i) == null) continue;
            this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.get(i).getCompressedSize());
        }
    }

    private AbstractAlignedPageReader constructAlignedPageReader(PageHeader timePageHeader, List<PageHeader> rawValuePageHeaderList) throws IOException {
        IDecryptor decrytor = IDecryptor.getDecryptor(this.encryptParam);
        ByteBuffer timePageData = ChunkReader.deserializePageData(timePageHeader, this.timeChunkDataBuffer, this.timeChunkHeader, decrytor);
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        LazyLoadPageData[] lazyLoadPageDataArray = new LazyLoadPageData[rawValuePageHeaderList.size()];
        ArrayList<TSDataType> valueDataTypeList = new ArrayList<TSDataType>();
        ArrayList<Decoder> valueDecoderList = new ArrayList<Decoder>();
        boolean isAllNull = true;
        for (int i = 0; i < rawValuePageHeaderList.size(); ++i) {
            PageHeader valuePageHeader = rawValuePageHeaderList.get(i);
            if (valuePageHeader == null || valuePageHeader.getUncompressedSize() == 0) {
                valuePageHeaderList.add(null);
                lazyLoadPageDataArray[i] = null;
                valueDataTypeList.add(null);
                valueDecoderList.add(null);
                continue;
            }
            if (this.pageDeleted(valuePageHeader, this.valueDeleteIntervalsList.get(i))) {
                this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.getCompressedSize());
                valuePageHeaderList.add(null);
                lazyLoadPageDataArray[i] = null;
                valueDataTypeList.add(null);
                valueDecoderList.add(null);
                continue;
            }
            ChunkHeader valueChunkHeader = this.valueChunkHeaderList.get(i);
            int currentPagePosition = this.valueChunkDataBufferList.get(i).position();
            this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.getCompressedSize());
            valuePageHeaderList.add(valuePageHeader);
            lazyLoadPageDataArray[i] = new LazyLoadPageData(this.valueChunkDataBufferList.get(i).array(), currentPagePosition, IUnCompressor.getUnCompressor(valueChunkHeader.getCompressionType()), this.encryptParam);
            valueDataTypeList.add(valueChunkHeader.getDataType());
            valueDecoderList.add(Decoder.getDecoderByType(valueChunkHeader.getEncodingType(), valueChunkHeader.getDataType()));
            isAllNull = false;
        }
        if (this.canSkip(isAllNull, timePageHeader)) {
            return null;
        }
        return this.constructPageReader(timePageHeader, timePageData, this.defaultTimeDecoder, valuePageHeaderList, lazyLoadPageDataArray, valueDataTypeList, valueDecoderList, this.queryFilter, this.valueDeleteIntervalsList);
    }

    abstract boolean canSkip(boolean var1, PageHeader var2);

    abstract AbstractAlignedPageReader constructPageReader(PageHeader var1, ByteBuffer var2, Decoder var3, List<PageHeader> var4, LazyLoadPageData[] var5, List<TSDataType> var6, List<Decoder> var7, Filter var8, List<List<TimeRange>> var9);

    protected boolean pageDeleted(PageHeader pageHeader, List<TimeRange> deleteIntervals) {
        if (pageHeader.getEndTime() < this.readStopTime) {
            return true;
        }
        if (deleteIntervals != null) {
            for (TimeRange range : deleteIntervals) {
                if (range.contains(pageHeader.getStartTime(), pageHeader.getEndTime())) {
                    return true;
                }
                if (!range.overlaps(new TimeRange(pageHeader.getStartTime(), pageHeader.getEndTime()))) continue;
                pageHeader.setModified(true);
            }
        }
        return false;
    }
}

