/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.persistence.PropertyDataType;
import io.netty.handler.codec.mqtt.MqttProperties;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.Function;
import org.h2.mvstore.type.StringDataType;

final class SerdesUtils {
    SerdesUtils() {
    }

    static boolean containsProperties(ByteBuffer buff) {
        return buff.get() == 1;
    }

    public static MqttProperties.MqttProperty[] readProperties(ByteBuffer buff, Function<ByteBuffer, MqttProperties.MqttProperty> propertyDecoder) {
        int numProperties = buff.getInt();
        ArrayList<MqttProperties.MqttProperty> properties = new ArrayList<MqttProperties.MqttProperty>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            MqttProperties.MqttProperty property = propertyDecoder.apply(buff);
            properties.add(property);
        }
        return properties.toArray(new MqttProperties.MqttProperty[0]);
    }

    static MqttProperties.MqttProperty<? extends Serializable> readSingleProperty(ByteBuffer buff, Function<ByteBuffer, byte[]> bytearrayDecoder) {
        byte propTypeValue = buff.get();
        if (propTypeValue >= PropertyDataType.MqttPropertyEnum.values().length) {
            throw new IllegalStateException("Unrecognized property type value: " + propTypeValue);
        }
        PropertyDataType.MqttPropertyEnum type = PropertyDataType.MqttPropertyEnum.values()[propTypeValue];
        int propertyId = buff.getInt();
        switch (type) {
            case STRING: {
                String value = StringDataType.INSTANCE.read(buff);
                return new MqttProperties.StringProperty(propertyId, value);
            }
            case INTEGER: {
                return new MqttProperties.IntegerProperty(propertyId, Integer.valueOf(buff.getInt()));
            }
            case BINARY: {
                return new MqttProperties.BinaryProperty(propertyId, bytearrayDecoder.apply(buff));
            }
        }
        throw new IllegalStateException("Unrecognized property type value: " + propTypeValue);
    }
}

