/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.headers;

import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;

public final class SecureMessageHeader {
    public static final int SECURE_MESSAGE_HEADER_SIZE = 12;
    private final MessageType messageType;
    private final char finalFlag;
    private final long messageSize;
    private final long secureChannelId;

    public SecureMessageHeader(MessageType messageType, char finalFlag, long messageSize, long secureChannelId) {
        this.messageType = messageType;
        this.finalFlag = finalFlag;
        this.messageSize = messageSize;
        this.secureChannelId = secureChannelId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public char getChunkType() {
        return this.finalFlag;
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    public static void encode(SecureMessageHeader header, ByteBuf buffer) throws UaException {
        buffer.writeMediumLE(MessageType.toMediumInt(header.getMessageType()));
        buffer.writeByte((int)header.getChunkType());
        buffer.writeIntLE((int)header.getMessageSize());
        buffer.writeIntLE((int)header.getSecureChannelId());
    }

    public static SecureMessageHeader decode(ByteBuf buffer) throws UaException {
        return new SecureMessageHeader(MessageType.fromMediumInt(buffer.readMediumLE()), (char)buffer.readByte(), buffer.readUnsignedIntLE(), buffer.readUnsignedIntLE());
    }
}

