/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.batch;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.connector.util.PipeTabletEventSorter;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.metric.sink.PipeDataRegionConnectorMetrics;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.session.util.RetryUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTabletEventTsFileBatch
extends PipeTabletEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTabletEventTsFileBatch.class);
    private static final AtomicReference<FolderManager> FOLDER_MANAGER = new AtomicReference();
    private static final AtomicLong BATCH_ID_GENERATOR = new AtomicLong(0L);
    private final AtomicLong currentBatchId = new AtomicLong(BATCH_ID_GENERATOR.incrementAndGet());
    private final File batchFileBaseDir;
    private static final String TS_FILE_PREFIX = "tb";
    private final AtomicLong tsFileIdGenerator = new AtomicLong(0L);
    private final Map<Pair<String, Long>, Double> pipeName2WeightMap = new HashMap<Pair<String, Long>, Double>();
    private final List<Tablet> tabletList = new ArrayList<Tablet>();
    private final List<Boolean> isTabletAlignedList = new ArrayList<Boolean>();
    private volatile TsFileWriter fileWriter;
    private static final PlanNodeId PLACEHOLDER_PLAN_NODE_ID = new PlanNodeId("PipeTreeModelTsFileBuilderV2");

    public PipeTabletEventTsFileBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes) {
        super(maxDelayInMs, requestMaxBatchSizeInBytes);
        try {
            this.batchFileBaseDir = this.getNextBaseDir();
        }
        catch (Exception e) {
            throw new PipeException(String.format("Failed to create file dir for batch: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getNextBaseDir() throws DiskSpaceInsufficientException {
        File baseDir;
        if (FOLDER_MANAGER.get() == null) {
            AtomicReference<FolderManager> atomicReference = FOLDER_MANAGER;
            synchronized (atomicReference) {
                if (FOLDER_MANAGER.get() == null) {
                    FOLDER_MANAGER.set(new FolderManager(Arrays.stream(IoTDBDescriptor.getInstance().getConfig().getPipeReceiverFileDirs()).map(fileDir -> fileDir + File.separator + ".batch").collect(Collectors.toList()), DirectoryStrategyType.SEQUENCE_STRATEGY));
                }
            }
        }
        if ((baseDir = new File(FOLDER_MANAGER.get().getNextFolder(), Long.toString(this.currentBatchId.get()))).exists()) {
            FileUtils.deleteQuietly((File)baseDir);
        }
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            LOGGER.warn("Batch id = {}: Failed to create batch file dir {}.", (Object)this.currentBatchId.get(), (Object)baseDir.getPath());
            throw new PipeException(String.format("Failed to create batch file dir %s. (Batch id = %s)", baseDir.getPath(), this.currentBatchId.get()));
        }
        LOGGER.info("Batch id = {}: Create batch dir successfully, batch file dir = {}.", (Object)this.currentBatchId.get(), (Object)baseDir.getPath());
        return baseDir;
    }

    @Override
    protected boolean constructBatch(TabletInsertionEvent event) {
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent insertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            List<Tablet> tablets = insertNodeTabletInsertionEvent.convertToTablets();
            for (int i = 0; i < tablets.size(); ++i) {
                Tablet tablet = tablets.get(i);
                if (tablet.rowSize == 0) continue;
                this.bufferTablet(insertNodeTabletInsertionEvent.getPipeName(), insertNodeTabletInsertionEvent.getCreationTime(), tablet, insertNodeTabletInsertionEvent.isAligned(i));
            }
        } else if (event instanceof PipeRawTabletInsertionEvent) {
            PipeRawTabletInsertionEvent rawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            Tablet tablet = rawTabletInsertionEvent.convertToTablet();
            if (tablet.rowSize == 0) {
                return true;
            }
            this.bufferTablet(rawTabletInsertionEvent.getPipeName(), rawTabletInsertionEvent.getCreationTime(), tablet, rawTabletInsertionEvent.isAligned());
        } else {
            LOGGER.warn("Batch id = {}: Unsupported event {} type {} when constructing tsfile batch", new Object[]{this.currentBatchId.get(), event, event.getClass()});
        }
        return true;
    }

    @Override
    protected void recordMetric(long timeInterval, long bufferSize) {
        PipeDataRegionConnectorMetrics.tsFileBatchTimeIntervalHistogram.update(timeInterval);
        PipeDataRegionConnectorMetrics.tsFileBatchSizeHistogram.update(bufferSize);
    }

    private void bufferTablet(String pipeName, long creationTime, Tablet tablet, boolean isAligned) {
        new PipeTabletEventSorter(tablet).deduplicateAndSortTimestampsIfNecessary();
        this.totalBufferSize += PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet) * 2L;
        this.pipeName2WeightMap.compute((Pair<String, Long>)new Pair((Object)pipeName, (Object)creationTime), (pipe, weight) -> {
            double d;
            if (Objects.nonNull(weight)) {
                weight = weight + 1.0;
                d = weight;
            } else {
                d = 1.0;
            }
            return d;
        });
        this.tabletList.add(tablet);
        this.isTabletAlignedList.add(isAligned);
    }

    public Map<Pair<String, Long>, Double> deepCopyPipe2WeightMap() {
        double sum = this.pipeName2WeightMap.values().stream().reduce(Double::sum).orElse(0.0);
        if (sum == 0.0) {
            return Collections.emptyMap();
        }
        this.pipeName2WeightMap.entrySet().forEach(entry -> entry.setValue((Double)entry.getValue() / sum));
        return new HashMap<Pair<String, Long>, Double>(this.pipeName2WeightMap);
    }

    public synchronized List<File> sealTsFiles() throws IOException, org.apache.tsfile.exception.write.WriteProcessException {
        if (this.isClosed) {
            return Collections.emptyList();
        }
        try {
            return new PipeTsFileBuilderV2().writeTabletsToTsFiles();
        }
        catch (WriteProcessException e) {
            LOGGER.warn("Exception occurred when PipeTsFileBuilderV2 writing tablets to tsfile, use fallback tsfile builder: {}", (Object)e.getMessage(), (Object)e);
            return this.writeTabletsToTsFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> writeTabletsToTsFiles() throws IOException, org.apache.tsfile.exception.write.WriteProcessException {
        HashMap<String, List> device2Tablets = new HashMap<String, List>();
        HashMap<String, Boolean> device2Aligned = new HashMap<String, Boolean>();
        int size = this.tabletList.size();
        for (int i = 0; i < size; ++i) {
            Tablet tablet2 = this.tabletList.get(i);
            String deviceId = tablet2.deviceId;
            device2Tablets.computeIfAbsent(deviceId, k -> new ArrayList()).add(tablet2);
            device2Aligned.put(deviceId, this.isTabletAlignedList.get(i));
        }
        for (List tablets : device2Tablets.values()) {
            tablets.sort(Comparator.comparingLong(tablet -> tablet.timestamps[0]));
        }
        ArrayList devices = new ArrayList(device2Tablets.keySet());
        devices.sort(Comparator.naturalOrder());
        LinkedHashMap<String, LinkedList<Tablet>> device2TabletsLinkedList = new LinkedHashMap<String, LinkedList<Tablet>>();
        for (String device : devices) {
            device2TabletsLinkedList.put(device, new LinkedList((Collection)device2Tablets.get(device)));
        }
        devices.clear();
        device2Tablets.clear();
        ArrayList<File> sealedFiles = new ArrayList<File>();
        while (!device2TabletsLinkedList.isEmpty()) {
            if (Objects.isNull(this.fileWriter)) {
                this.fileWriter = new TsFileWriter(this.createFile());
            }
            try {
                this.tryBestToWriteTabletsIntoOneFile(device2TabletsLinkedList, device2Aligned);
            }
            catch (Exception e) {
                LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{this.currentBatchId.get(), e.getMessage(), e});
                try {
                    this.fileWriter.close();
                }
                catch (Exception closeException) {
                    LOGGER.warn("Batch id = {}: Failed to close the tsfile {} after failed to write tablets into, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), closeException.getMessage(), closeException});
                }
                finally {
                    sealedFiles.add(this.fileWriter.getIOWriter().getFile());
                }
                for (File sealedFile : sealedFiles) {
                    boolean deleteSuccess = FileUtils.deleteQuietly((File)sealedFile);
                    LOGGER.warn("Batch id = {}: {} delete the tsfile {} after failed to write tablets into {}. {}", new Object[]{this.currentBatchId.get(), deleteSuccess ? "Successfully" : "Failed to", sealedFile.getPath(), this.fileWriter.getIOWriter().getFile().getPath(), deleteSuccess ? "" : "Maybe the tsfile needs to be deleted manually."});
                }
                sealedFiles.clear();
                this.fileWriter = null;
                throw e;
            }
            this.fileWriter.close();
            File sealedFile = this.fileWriter.getIOWriter().getFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Batch id = {}: Seal tsfile {} successfully.", (Object)this.currentBatchId.get(), (Object)sealedFile.getPath());
            }
            sealedFiles.add(sealedFile);
            this.fileWriter = null;
        }
        return sealedFiles;
    }

    private Tablet tryBestToAggregateTablets(String deviceId, LinkedList<Tablet> tablets) {
        if (tablets.isEmpty()) {
            return null;
        }
        Tablet firstTablet = tablets.peekFirst();
        long[] aggregationTimestamps = firstTablet.timestamps;
        int aggregationRow = firstTablet.rowSize;
        int aggregationMaxRow = firstTablet.getMaxRowNumber();
        ArrayList aggregatedSchemas = new ArrayList();
        ArrayList<Object> aggregatedValues = new ArrayList<Object>();
        ArrayList<BitMap> aggregatedBitMaps = new ArrayList<BitMap>();
        while (!tablets.isEmpty()) {
            Tablet tablet = tablets.peekFirst();
            if (!Arrays.equals(tablet.timestamps, aggregationTimestamps) || tablet.rowSize != aggregationRow || tablet.getMaxRowNumber() != aggregationMaxRow) break;
            aggregatedSchemas.addAll(tablet.getSchemas());
            aggregatedValues.addAll(Arrays.asList(tablet.values));
            aggregatedBitMaps.addAll(Arrays.asList(tablet.bitMaps));
            tablets.pollFirst();
        }
        HashSet seen = new HashSet();
        List distinctIndices = IntStream.range(0, aggregatedSchemas.size()).filter(i -> seen.add((MeasurementSchema)aggregatedSchemas.get(i))).boxed().collect(Collectors.toList());
        return new Tablet(deviceId, distinctIndices.stream().map(aggregatedSchemas::get).collect(Collectors.toList()), aggregationTimestamps, distinctIndices.stream().map(aggregatedValues::get).toArray(), (BitMap[])distinctIndices.stream().map(aggregatedBitMaps::get).toArray(BitMap[]::new), aggregationRow);
    }

    private void tryBestToWriteTabletsIntoOneFile(LinkedHashMap<String, LinkedList<Tablet>> device2TabletsLinkedList, Map<String, Boolean> device2Aligned) throws IOException, org.apache.tsfile.exception.write.WriteProcessException {
        Iterator<Map.Entry<String, LinkedList<Tablet>>> iterator = device2TabletsLinkedList.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isAligned;
            Map.Entry<String, LinkedList<Tablet>> entry = iterator.next();
            String deviceId = entry.getKey();
            LinkedList<Tablet> tablets = entry.getValue();
            ArrayList<Tablet> tabletsToWrite = new ArrayList<Tablet>();
            Tablet lastTablet = null;
            while (!tablets.isEmpty()) {
                Tablet tablet2 = this.tryBestToAggregateTablets(deviceId, tablets);
                if (Objects.isNull(lastTablet) || lastTablet.timestamps[lastTablet.rowSize - 1] < tablet2.timestamps[0]) {
                    tabletsToWrite.add(tablet2);
                    lastTablet = tablet2;
                    continue;
                }
                tablets.addFirst(tablet2);
                break;
            }
            if (tablets.isEmpty()) {
                iterator.remove();
            }
            if (isAligned = device2Aligned.get(deviceId).booleanValue()) {
                HashMap deviceId2MeasurementSchemas = new HashMap();
                tabletsToWrite.forEach(tablet -> deviceId2MeasurementSchemas.compute(tablet.deviceId, (k, v) -> {
                    if (Objects.isNull(v)) {
                        return new ArrayList(tablet.getSchemas());
                    }
                    v.addAll(tablet.getSchemas());
                    return v;
                }));
                for (Map.Entry deviceIdWithMeasurementSchemas : deviceId2MeasurementSchemas.entrySet()) {
                    this.fileWriter.registerAlignedTimeseries(new Path((String)deviceIdWithMeasurementSchemas.getKey()), (List)deviceIdWithMeasurementSchemas.getValue());
                }
                for (Tablet tablet3 : tabletsToWrite) {
                    this.fileWriter.writeAligned(tablet3);
                }
                continue;
            }
            for (Tablet tablet4 : tabletsToWrite) {
                for (MeasurementSchema schema : tablet4.getSchemas()) {
                    try {
                        this.fileWriter.registerTimeseries(new Path(tablet4.deviceId), schema);
                    }
                    catch (org.apache.tsfile.exception.write.WriteProcessException writeProcessException) {}
                }
                this.fileWriter.write(tablet4);
            }
        }
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.pipeName2WeightMap.clear();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
        this.fileWriter = null;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.pipeName2WeightMap.clear();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
        if (Objects.nonNull(this.fileWriter)) {
            try {
                this.fileWriter.close();
            }
            catch (Exception e) {
                LOGGER.info("Batch id = {}: Failed to close the tsfile {} when trying to close batch, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), e.getMessage(), e});
            }
            try {
                RetryUtils.retryOnException(() -> FileUtils.delete((File)this.fileWriter.getIOWriter().getFile()));
            }
            catch (Exception e) {
                LOGGER.info("Batch id = {}: Failed to delete the tsfile {} when trying to close batch, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), e.getMessage(), e});
            }
            this.fileWriter = null;
        }
    }

    protected File createFile() throws IOException {
        return new File(this.batchFileBaseDir, "tb_" + IoTDBDescriptor.getInstance().getConfig().getDataNodeId() + "_" + this.currentBatchId.get() + "_" + this.tsFileIdGenerator.getAndIncrement() + ".tsfile");
    }

    private class PipeTsFileBuilderV2 {
        private PipeTsFileBuilderV2() {
        }

        private List<File> writeTabletsToTsFiles() throws WriteProcessException {
            PrimitiveMemTable memTable = new PrimitiveMemTable(null, null);
            ArrayList<File> sealedFiles = new ArrayList<File>();
            try (RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(PipeTabletEventTsFileBatch.this.createFile());){
                this.writeTabletsIntoOneFile(memTable, writer);
                sealedFiles.add(writer.getFile());
            }
            catch (Exception e) {
                LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{PipeTabletEventTsFileBatch.this.currentBatchId.get(), e.getMessage(), e});
                throw new WriteProcessException(e);
            }
            finally {
                memTable.release();
            }
            return sealedFiles;
        }

        private void writeTabletsIntoOneFile(IMemTable memTable, RestorableTsFileIOWriter writer) throws Exception {
            int size = PipeTabletEventTsFileBatch.this.tabletList.size();
            for (int i = 0; i < size; ++i) {
                Tablet tablet = (Tablet)PipeTabletEventTsFileBatch.this.tabletList.get(i);
                Object[] values = Arrays.copyOf(tablet.values, tablet.values.length);
                for (int j = 0; j < tablet.getSchemas().size(); ++j) {
                    MeasurementSchema schema = (MeasurementSchema)tablet.getSchemas().get(j);
                    if (!Objects.nonNull(schema) || !Objects.equals(TSDataType.DATE, schema.getType()) || !(values[j] instanceof LocalDate[])) continue;
                    LocalDate[] dates = (LocalDate[])values[j];
                    int[] dateValues = new int[dates.length];
                    for (int k = 0; k < Math.min(dates.length, tablet.rowSize); ++k) {
                        dateValues[k] = DateUtils.parseDateExpressionToInt((LocalDate)dates[k]);
                    }
                    values[j] = dateValues;
                }
                InsertTabletNode insertTabletNode = new InsertTabletNode(PLACEHOLDER_PLAN_NODE_ID, new PartialPath(tablet.deviceId), (Boolean)PipeTabletEventTsFileBatch.this.isTabletAlignedList.get(i), (String[])tablet.getSchemas().stream().map(m -> Objects.nonNull(m) ? m.getMeasurementId() : null).toArray(String[]::new), (TSDataType[])tablet.getSchemas().stream().map(m -> Objects.nonNull(m) ? m.getType() : null).toArray(TSDataType[]::new), tablet.getSchemas().toArray(new MeasurementSchema[0]), tablet.timestamps, tablet.bitMaps, values, tablet.rowSize);
                boolean start = false;
                int end = insertTabletNode.getRowCount();
                try {
                    if (insertTabletNode.isAligned()) {
                        memTable.insertAlignedTablet(insertTabletNode, 0, end);
                        continue;
                    }
                    memTable.insertTablet(insertTabletNode, 0, end);
                    continue;
                }
                catch (WriteProcessException e) {
                    throw new WriteProcessException((Exception)((Object)e));
                }
            }
            MemTableFlushTask memTableFlushTask = new MemTableFlushTask(memTable, writer, null, null);
            memTableFlushTask.syncFlushMemTable();
            writer.endFile();
        }
    }
}

