/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.plugin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.manager.pipe.coordinator.plugin.PipePluginCoordinator;
import org.apache.iotdb.confignode.manager.pipe.coordinator.task.PipeTaskCoordinator;
import org.apache.iotdb.confignode.manager.subscription.SubscriptionCoordinator;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.pipe.plugin.DropPipePluginState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropPipePluginProcedure
extends AbstractNodeProcedure<DropPipePluginState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropPipePluginProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private String pluginName;
    private boolean isSetIfExistsCondition;

    public DropPipePluginProcedure() {
    }

    public DropPipePluginProcedure(String pluginName, boolean isSetIfExistsCondition) {
        this.pluginName = pluginName;
        this.isSetIfExistsCondition = isSetIfExistsCondition;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropPipePluginState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block10: {
            if (this.pluginName == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case LOCK: {
                        return this.executeFromLock(env);
                    }
                    case DROP_ON_DATA_NODES: {
                        return this.executeFromDropOnDataNodes(env);
                    }
                    case DROP_ON_CONFIG_NODES: {
                        return this.executeFromDropOnConfigNodes(env);
                    }
                    case UNLOCK: {
                        return this.executeFromUnlock(env);
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.warn("DropPipePluginProcedure failed in state {}, will rollback", (Object)state, (Object)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to drop pipe plugin [{}], state: {}", new Object[]{this.pluginName, state, e});
                if (this.getCycles() <= 5) break block10;
                LOGGER.error("Fail to drop pipe plugin [{}] after {} retries", (Object)this.pluginName, (Object)this.getCycles());
                this.setFailure(new ProcedureException(e.getMessage()));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow executeFromLock(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: executeFromLock({})", (Object)this.pluginName);
        PipeTaskCoordinator pipeTaskCoordinator = env.getConfigManager().getPipeManager().getPipeTaskCoordinator();
        PipePluginCoordinator pipePluginCoordinator = env.getConfigManager().getPipeManager().getPipePluginCoordinator();
        SubscriptionCoordinator subscriptionCoordinator = env.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator();
        AtomicReference<PipeTaskInfo> pipeTaskInfo = pipeTaskCoordinator.lock();
        pipePluginCoordinator.lock();
        SubscriptionInfo subscriptionInfo = subscriptionCoordinator.getSubscriptionInfo();
        try {
            if (pipePluginCoordinator.getPipePluginInfo().validateBeforeDroppingPipePlugin(this.pluginName, this.isSetIfExistsCondition)) {
                LOGGER.info("Pipe plugin {} is not exist, end the DropPipePluginProcedure({})", (Object)this.pluginName, (Object)this.pluginName);
                pipePluginCoordinator.unlock();
                pipeTaskCoordinator.unlock();
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            pipeTaskInfo.get().validatePipePluginUsageByPipe(this.pluginName);
            subscriptionInfo.validatePipePluginUsageByTopic(this.pluginName);
        }
        catch (PipeException e) {
            LOGGER.warn(e.getMessage());
            pipePluginCoordinator.unlock();
            pipeTaskCoordinator.unlock();
            this.setFailure(new ProcedureException(e.getMessage()));
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            env.getConfigManager().getConsensusManager().write(new DropPipePluginPlan(this.pluginName));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
        this.setNextState(DropPipePluginState.DROP_ON_DATA_NODES);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow executeFromDropOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: executeFromDropOnDataNodes({})", (Object)this.pluginName);
        if (RpcUtils.squashResponseStatusList(env.dropPipePluginOnDataNodes(this.pluginName, true)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(DropPipePluginState.DROP_ON_CONFIG_NODES);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        throw new PipeException(String.format("Failed to drop pipe plugin %s on data nodes", this.pluginName));
    }

    private StateMachineProcedure.Flow executeFromDropOnConfigNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: executeFromDropOnConfigNodes({})", (Object)this.pluginName);
        try {
            env.getConfigManager().getConsensusManager().write(new DropPipePluginPlan(this.pluginName));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
        this.setNextState(DropPipePluginState.UNLOCK);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow executeFromUnlock(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: executeFromUnlock({})", (Object)this.pluginName);
        env.getConfigManager().getPipeManager().getPipePluginCoordinator().unlock();
        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DropPipePluginState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case LOCK: {
                this.rollbackFromLock(env);
                break;
            }
            case DROP_ON_DATA_NODES: {
                this.rollbackFromDropOnDataNodes(env);
                break;
            }
            case DROP_ON_CONFIG_NODES: {
                this.rollbackFromDropOnConfigNodes(env);
            }
        }
    }

    private void rollbackFromLock(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: rollbackFromLock({})", (Object)this.pluginName);
        env.getConfigManager().getPipeManager().getPipePluginCoordinator().unlock();
        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
    }

    private void rollbackFromDropOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: rollbackFromDropOnDataNodes({})", (Object)this.pluginName);
    }

    private void rollbackFromDropOnConfigNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipePluginProcedure: rollbackFromDropOnConfigNodes({})", (Object)this.pluginName);
    }

    @Override
    protected boolean isRollbackSupported(DropPipePluginState state) {
        switch (state) {
            case LOCK: 
            case DROP_ON_DATA_NODES: 
            case DROP_ON_CONFIG_NODES: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected DropPipePluginState getState(int stateId) {
        return DropPipePluginState.values()[stateId];
    }

    @Override
    protected int getStateId(DropPipePluginState dropPipePluginState) {
        return dropPipePluginState.ordinal();
    }

    @Override
    protected DropPipePluginState getInitialState() {
        return DropPipePluginState.LOCK;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_PIPE_PLUGIN_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pluginName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pluginName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof DropPipePluginProcedure) {
            DropPipePluginProcedure thatProcedure = (DropPipePluginProcedure)that;
            return thatProcedure.getProcId() == this.getProcId() && ((DropPipePluginState)((Object)thatProcedure.getCurrentState())).equals(this.getCurrentState()) && thatProcedure.getCycles() == this.getCycles() && thatProcedure.pluginName.equals(this.pluginName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.pluginName);
    }
}

