/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.subscription;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.consensus.common.DataSet;

public class TopicTableResp
implements DataSet {
    private final TSStatus status;
    private final List<TopicMeta> allTopicMeta;

    public TopicTableResp(TSStatus status, List<TopicMeta> allTopicMeta) {
        this.status = status;
        this.allTopicMeta = allTopicMeta;
    }

    public TopicTableResp filter(String topicName) {
        if (topicName == null) {
            return this;
        }
        ArrayList<TopicMeta> filteredTopicMeta = new ArrayList<TopicMeta>();
        for (TopicMeta topicMeta : this.allTopicMeta) {
            if (!topicMeta.getTopicName().equals(topicName)) continue;
            filteredTopicMeta.add(topicMeta);
            break;
        }
        return new TopicTableResp(this.status, filteredTopicMeta);
    }

    public TShowTopicResp convertToTShowTopicResp() {
        ArrayList<TShowTopicInfo> showTopicInfoList = new ArrayList<TShowTopicInfo>();
        for (TopicMeta topicMeta : this.allTopicMeta) {
            showTopicInfoList.add(new TShowTopicInfo(topicMeta.getTopicName(), topicMeta.getCreationTime()).setTopicAttributes(topicMeta.getConfig().toString()));
        }
        return new TShowTopicResp(this.status).setTopicInfoList(showTopicInfoList);
    }

    public TGetAllTopicInfoResp convertToTGetAllTopicInfoResp() throws IOException {
        ArrayList<ByteBuffer> topicInfoByteBuffers = new ArrayList<ByteBuffer>();
        for (TopicMeta topicMeta : this.allTopicMeta) {
            topicInfoByteBuffers.add(topicMeta.serialize());
        }
        return new TGetAllTopicInfoResp(this.status, topicInfoByteBuffers);
    }
}

