## Description


### Content1 ...

### Content2 ...

### Content3 ...

<!--
In each section, please describe design decisions made, including:
 - Choice of algorithms
 - Behavioral aspects. What configuration values are acceptable? How are corner cases and error 
    conditions handled, such as when there are insufficient resources?
 - Class organization and design (how the logic is split between classes, inheritance, composition, 
    design patterns)
 - Method organization and design (how the logic is split between methods, parameters and return types)
 - Naming (class, method, API, configuration, HTTP endpoint, names of emitted metrics)
-->


<!-- It's good to describe an alternative design (or mention an alternative name) for every design 
(or naming) decision point and compare the alternatives with the designs that you've implemented 
(or the names you've chosen) to highlight the advantages of the chosen designs and names. -->

<!-- If there was a discussion of the design of the feature implemented in this PR elsewhere 
(e. g. a "Proposal" issue, any other issue, or a thread in the development mailing list), 
link to that discussion from this PR description and explain what have changed in your final design 
compared to your original proposal or the consensus version in the end of the discussion. 
If something hasn't changed since the original discussion, you can omit a detailed discussion of 
those aspects of the design here, perhaps apart from brief mentioning for the sake of readability 
of this PR description. -->

<!-- Some of the aspects mentioned above may be omitted for simple and small changes. -->

<hr>

This PR has:
- [ ] been self-reviewed.
    - [ ] concurrent read
    - [ ] concurrent write
    - [ ] concurrent read and write 
- [ ] added documentation for new or modified features or behaviors.
- [ ] added Javadocs for most classes and all non-trivial methods. 
- [ ] added or updated version, __license__, or notice information
- [ ] added comments explaining the "why" and the intent of the code wherever would not be obvious 
  for an unfamiliar reader.
- [ ] added unit tests or modified existing tests to cover new code paths, ensuring the threshold 
  for code coverage.
- [ ] added integration tests.
- [ ] been tested in a test IoTDB cluster.

<!-- Check the items by putting "x" in the brackets for the done things. Not all of these items 
apply to every PR. Remove the items which are not done or not relevant to the PR. None of the items 
from the checklist above are strictly necessary, but it would be very helpful if you at least 
self-review the PR. -->

<hr>

##### Key changed/added classes (or packages if there are too many classes) in this PR
