/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFileManager {
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private Map<Long, Map<TsFileResource, TsFileResource>> sealedFilePathsMap = new ConcurrentHashMap<Long, Map<TsFileResource, TsFileResource>>();
    private Map<Long, Map<TsFileResource, TsFileResource>> unsealedFilePathsMap = new ConcurrentHashMap<Long, Map<TsFileResource, TsFileResource>>();

    QueryFileManager() {
    }

    void addQueryId(long queryId) {
        this.sealedFilePathsMap.computeIfAbsent(queryId, x -> new ConcurrentHashMap());
        this.unsealedFilePathsMap.computeIfAbsent(queryId, x -> new ConcurrentHashMap());
    }

    public void addUsedFilesForQuery(long queryId, QueryDataSource dataSource) {
        this.addUsedFilesForQuery(queryId, dataSource.getSeqResources());
        this.addUsedFilesForQuery(queryId, dataSource.getUnseqResources());
    }

    private void addUsedFilesForQuery(long queryId, List<TsFileResource> resources) {
        Iterator<TsFileResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            Map<Long, Map<TsFileResource, TsFileResource>> pathMap;
            TsFileResource tsFileResource = iterator.next();
            boolean isClosed = tsFileResource.isClosed();
            this.addFilePathToMap(queryId, tsFileResource, isClosed);
            if (!tsFileResource.isDeleted()) continue;
            Map<Long, Map<TsFileResource, TsFileResource>> map = pathMap = !isClosed ? this.unsealedFilePathsMap : this.sealedFilePathsMap;
            if (pathMap.get(queryId).remove(tsFileResource) != null) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            iterator.remove();
        }
    }

    void removeUsedFilesForQuery(long queryId) {
        this.sealedFilePathsMap.computeIfPresent(queryId, (k, v) -> {
            for (TsFileResource tsFile : v.keySet()) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
            }
            return null;
        });
        this.unsealedFilePathsMap.computeIfPresent(queryId, (k, v) -> {
            for (TsFileResource tsFile : v.keySet()) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
            }
            return null;
        });
    }

    void addFilePathToMap(long queryId, TsFileResource tsFile, boolean isClosed) {
        Map<Long, Map<TsFileResource, TsFileResource>> pathMap = isClosed ? this.sealedFilePathsMap : this.unsealedFilePathsMap;
        pathMap.get(queryId).computeIfAbsent(tsFile, k -> {
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
            return k;
        });
    }

    public void writeQueryFileInfo() {
        Set<TsFileResource> tsFileResources;
        long queryId;
        DEBUG_LOGGER.info("[Query Sealed File Info]\n");
        for (Map.Entry<Long, Map<TsFileResource, TsFileResource>> entry : this.sealedFilePathsMap.entrySet()) {
            queryId = entry.getKey();
            tsFileResources = entry.getValue().keySet();
            DEBUG_LOGGER.info(String.format("\t[queryId: %d]\n", queryId));
            for (TsFileResource tsFileResource : tsFileResources) {
                DEBUG_LOGGER.info(String.format("\t\t%s\n", tsFileResource.getTsFile().getAbsolutePath()));
            }
        }
        DEBUG_LOGGER.info("[Query Unsealed File Info]\n");
        for (Map.Entry<Long, Map<TsFileResource, TsFileResource>> entry : this.unsealedFilePathsMap.entrySet()) {
            queryId = entry.getKey();
            tsFileResources = entry.getValue().keySet();
            DEBUG_LOGGER.info(String.format("\t[queryId: %d]\n", queryId));
            for (TsFileResource tsFileResource : tsFileResources) {
                DEBUG_LOGGER.info(String.format("\t\t%s\n", tsFileResource.getTsFile().getAbsolutePath()));
            }
        }
    }
}

