/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.engine.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.AlignedLastPointReader;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.AlignedSeriesReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedPath
extends PartialPath {
    private static final Logger logger = LoggerFactory.getLogger(AlignedPath.class);
    public static final String VECTOR_PLACEHOLDER = "";
    private List<String> measurementList;
    private List<IMeasurementSchema> schemaList;

    public AlignedPath() {
    }

    public AlignedPath(String vectorPath, List<String> subSensorsList) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = subSensorsList;
    }

    public AlignedPath(String vectorPath, List<String> measurementList, List<IMeasurementSchema> schemaList) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = measurementList;
        this.schemaList = schemaList;
    }

    public AlignedPath(String vectorPath, String subSensor) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = new ArrayList<String>();
        this.measurementList.add(subSensor);
    }

    public AlignedPath(PartialPath vectorPath, String subSensor) {
        super(vectorPath.getNodes());
        this.measurementList = new ArrayList<String>();
        this.measurementList.add(subSensor);
    }

    public AlignedPath(MeasurementPath path) {
        super(path.getDevicePath().getNodes());
        this.measurementList = new ArrayList<String>();
        this.measurementList.add(path.getMeasurement());
        this.schemaList = new ArrayList<IMeasurementSchema>();
        this.schemaList.add(path.getMeasurementSchema());
    }

    public AlignedPath(String vectorPath) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = new ArrayList<String>();
        this.schemaList = new ArrayList<IMeasurementSchema>();
    }

    @Override
    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length));
    }

    @Override
    public String getDevice() {
        return this.getFullPath();
    }

    @Override
    public String getMeasurement() {
        throw new UnsupportedOperationException("AlignedPath doesn't have measurement name!");
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public String getMeasurement(int index) {
        return this.measurementList.get(index);
    }

    public PartialPath getPathWithMeasurement(int index) {
        return new PartialPath(this.nodes).concatNode(this.measurementList.get(index));
    }

    public void setMeasurementList(List<String> measurementList) {
        this.measurementList = measurementList;
    }

    public void addMeasurements(List<String> measurements) {
        this.measurementList.addAll(measurements);
    }

    public void addSchemas(List<IMeasurementSchema> schemas) {
        this.schemaList.addAll(schemas);
    }

    public void addMeasurement(MeasurementPath measurementPath) {
        if (this.measurementList == null) {
            this.measurementList = new ArrayList<String>();
        }
        this.measurementList.add(measurementPath.getMeasurement());
        if (this.schemaList == null) {
            this.schemaList = new ArrayList<IMeasurementSchema>();
        }
        this.schemaList.add(measurementPath.getMeasurementSchema());
    }

    public void mergeAlignedPath(AlignedPath alignedPath) {
        if (this.measurementList == null) {
            this.measurementList = new ArrayList<String>();
        }
        this.measurementList.addAll(alignedPath.measurementList);
        if (this.schemaList == null) {
            this.schemaList = new ArrayList<IMeasurementSchema>();
        }
        this.schemaList.addAll(alignedPath.schemaList);
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList == null ? Collections.emptyList() : this.schemaList;
    }

    public VectorMeasurementSchema getMeasurementSchema() {
        TSDataType[] types = new TSDataType[this.measurementList.size()];
        TSEncoding[] encodings = new TSEncoding[this.measurementList.size()];
        for (int i = 0; i < this.measurementList.size(); ++i) {
            types[i] = this.schemaList.get(i).getType();
            encodings[i] = this.schemaList.get(i).getEncodingType();
        }
        String[] array = new String[this.measurementList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.measurementList.get(i);
        }
        return new VectorMeasurementSchema(VECTOR_PLACEHOLDER, array, types, encodings, this.schemaList.get(0).getCompressor());
    }

    @Override
    public TSDataType getSeriesType() {
        return TSDataType.VECTOR;
    }

    @Override
    public PartialPath copy() {
        AlignedPath result = new AlignedPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementList = new ArrayList<String>(this.measurementList);
        result.schemaList = new ArrayList<IMeasurementSchema>(this.schemaList);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedPath that = (AlignedPath)o;
        return Objects.equals(this.measurementList, that.measurementList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.measurementList);
    }

    @Override
    public AlignedLastPointReader createLastPointReader(TSDataType dataType, Set<String> deviceMeasurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        return new AlignedLastPointReader(this, dataType, deviceMeasurements, context, dataSource, queryTime, timeFilter);
    }

    @Override
    public AlignedSeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        return new AlignedSeriesReader((PartialPath)this, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    @Override
    public AlignedSeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        return new AlignedSeriesReader((PartialPath)this, allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, valueFilter, ascending);
    }

    @Override
    public TsFileResource createTsFileResource(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        TsFileResource tsFileResource = new TsFileResource(this, readOnlyMemChunk, chunkMetadataList, originTsFileResource);
        tsFileResource.setTimeSeriesMetadata(this, (ITimeSeriesMetadata)this.generateTimeSeriesMetadata(readOnlyMemChunk, chunkMetadataList));
        return tsFileResource;
    }

    /*
     * WARNING - void declaration
     */
    public AlignedTimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) throws IOException {
        void var7_11;
        int i;
        AlignedChunkMetadata alignedChunkMetadata;
        TimeseriesMetadata timeTimeSeriesMetadata = new TimeseriesMetadata();
        timeTimeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
        timeTimeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        timeTimeSeriesMetadata.setMeasurementId(VECTOR_PLACEHOLDER);
        timeTimeSeriesMetadata.setTSDataType(TSDataType.VECTOR);
        Statistics timeStatistics = Statistics.getStatsByType((TSDataType)timeTimeSeriesMetadata.getTSDataType());
        ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (IMeasurementSchema iMeasurementSchema : this.schemaList) {
            TimeseriesMetadata valueMetadata = new TimeseriesMetadata();
            valueMetadata.setOffsetOfChunkMetaDataList(-1L);
            valueMetadata.setDataSizeOfChunkMetaDataList(-1);
            valueMetadata.setMeasurementId(iMeasurementSchema.getMeasurementId());
            valueMetadata.setTSDataType(iMeasurementSchema.getType());
            valueMetadata.setStatistics(Statistics.getStatsByType((TSDataType)iMeasurementSchema.getType()));
            valueTimeSeriesMetadataList.add(valueMetadata);
        }
        boolean[] exist = new boolean[this.schemaList.size()];
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadata;
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            alignedChunkMetadata = (AlignedChunkMetadata)memChunk.getChunkMetaData();
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        timeTimeSeriesMetadata.setStatistics(timeStatistics);
        boolean bl = false;
        while (var7_11 < valueTimeSeriesMetadataList.size()) {
            if (!exist[var7_11]) {
                valueTimeSeriesMetadataList.set((int)var7_11, null);
            }
            ++var7_11;
        }
        return new AlignedTimeSeriesMetadata(timeTimeSeriesMetadata, valueTimeSeriesMetadataList);
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID(this))) {
            return null;
        }
        AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)memTableMap.get(deviceID)).getAlignedMemChunk();
        boolean containsMeasurement = false;
        for (String measurement : this.measurementList) {
            if (!alignedMemChunk.containsMeasurement(measurement)) continue;
            containsMeasurement = true;
            break;
        }
        if (!containsMeasurement) {
            return null;
        }
        TVList alignedTvListCopy = alignedMemChunk.getSortedTvListForQuery(this.schemaList);
        int curSize = alignedTvListCopy.rowCount();
        List<List<TimeRange>> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = this.constructDeletionList(memTable, modsToMemtable, timeLowerBound);
        }
        return new AlignedReadOnlyMemChunk((IMeasurementSchema)this.getMeasurementSchema(), alignedTvListCopy, curSize, deletionList);
    }

    private List<List<TimeRange>> constructDeletionList(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        for (String measurement : this.measurementList) {
            ArrayList<TimeRange> columnDeletionList = new ArrayList<TimeRange>();
            columnDeletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
            for (Modification modification : this.getModificationsForMemtable(memTable, modsToMemtable)) {
                if (!(modification instanceof Deletion)) continue;
                Deletion deletion = (Deletion)modification;
                PartialPath fullPath = this.concatNode(measurement);
                if (!deletion.getPath().matchFullPath(fullPath) || deletion.getEndTime() <= timeLowerBound) continue;
                long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
                columnDeletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
            }
            deletionList.add(TimeRange.sortAndMerge(columnDeletionList));
        }
        return deletionList;
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        int i;
        ModificationFile modificationFile = tsFileResource.getModFile();
        List<List<Modification>> modifications = context.getPathModifications(modificationFile, this);
        ArrayList<AlignedChunkMetadata> chunkMetadataList = new ArrayList<AlignedChunkMetadata>();
        List timeChunkMetadataList = writer.getVisibleMetadataList(this.getDevice(), VECTOR_PLACEHOLDER, this.getSeriesType());
        ArrayList<List> valueChunkMetadataList = new ArrayList<List>();
        for (i = 0; i < this.measurementList.size(); ++i) {
            valueChunkMetadataList.add(writer.getVisibleMetadataList(this.getDevice(), this.measurementList.get(i), this.schemaList.get(i).getType()));
        }
        for (i = 0; i < timeChunkMetadataList.size(); ++i) {
            ArrayList<IChunkMetadata> valueChunkMetadata = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List chunkMetadata : valueChunkMetadataList) {
                boolean currentExist = i < chunkMetadata.size();
                exits = exits || currentExist;
                valueChunkMetadata.add(currentExist ? (IChunkMetadata)chunkMetadata.get(i) : null);
            }
            if (!exits) continue;
            chunkMetadataList.add(new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), valueChunkMetadata));
        }
        QueryUtils.modifyAlignedChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(context::chunkNotSatisfy);
        return new ArrayList<AlignedChunkMetadata>(chunkMetadataList);
    }

    public int getColumnNum() {
        return this.measurementList.size();
    }

    @Override
    public AlignedPath clone() {
        AlignedPath alignedPath = null;
        try {
            alignedPath = new AlignedPath(this.getDevice(), new ArrayList<String>(this.measurementList), new ArrayList<IMeasurementSchema>(this.schemaList));
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return alignedPath;
    }
}

