/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression.binary;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.binary.AdditionExpression;
import org.apache.iotdb.db.query.expression.binary.DivisionExpression;
import org.apache.iotdb.db.query.expression.binary.ModuloExpression;
import org.apache.iotdb.db.query.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.query.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.ArithmeticBinaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class BinaryExpression
extends Expression {
    protected final Expression leftExpression;
    protected final Expression rightExpression;

    protected BinaryExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.leftExpression.isConstantOperand() && this.rightExpression.isConstantOperand();
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.leftExpression.isPlainAggregationFunctionExpression() || this.rightExpression.isPlainAggregationFunctionExpression() || this.leftExpression.isUserDefinedAggregationFunctionExpression() || this.rightExpression.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.leftExpression, this.rightExpression);
    }

    @Override
    public final void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        this.leftExpression.concat(prefixPaths, leftExpressions);
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        this.rightExpression.concat(prefixPaths, rightExpressions);
        this.reconstruct(leftExpressions, rightExpressions, resultExpressions);
    }

    @Override
    public final void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        this.leftExpression.removeWildcards(wildcardsRemover, leftExpressions);
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        this.rightExpression.removeWildcards(wildcardsRemover, rightExpressions);
        this.reconstruct(leftExpressions, rightExpressions, resultExpressions);
    }

    private void reconstruct(List<Expression> leftExpressions, List<Expression> rightExpressions, List<Expression> resultExpressions) {
        for (Expression le : leftExpressions) {
            block15: for (Expression re : rightExpressions) {
                switch (this.operator()) {
                    case "+": {
                        resultExpressions.add(new AdditionExpression(le, re));
                        continue block15;
                    }
                    case "-": {
                        resultExpressions.add(new SubtractionExpression(le, re));
                        continue block15;
                    }
                    case "*": {
                        resultExpressions.add(new MultiplicationExpression(le, re));
                        continue block15;
                    }
                    case "/": {
                        resultExpressions.add(new DivisionExpression(le, re));
                        continue block15;
                    }
                    case "%": {
                        resultExpressions.add(new ModuloExpression(le, re));
                        continue block15;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        this.leftExpression.collectPaths(pathSet);
        this.rightExpression.collectPaths(pathSet);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.leftExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.rightExpression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.leftExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.rightExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            IntermediateLayer leftParentIntermediateLayer = this.leftExpression.constructIntermediateLayer(queryId, udtfPlan, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
            IntermediateLayer rightParentIntermediateLayer = this.rightExpression.constructIntermediateLayer(queryId, udtfPlan, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
            ArithmeticBinaryTransformer transformer = this.constructTransformer(leftParentIntermediateLayer.constructPointReader(), rightParentIntermediateLayer.constructPointReader());
            expressionDataTypeMap.put(this, transformer.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 || this.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    protected abstract ArithmeticBinaryTransformer constructTransformer(LayerPointReader var1, LayerPointReader var2);

    @Override
    public final String getExpressionStringInternal() {
        StringBuilder builder = new StringBuilder();
        if (this.leftExpression instanceof BinaryExpression) {
            builder.append("(").append(this.leftExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.leftExpression.getExpressionString());
        }
        builder.append(" ").append(this.operator()).append(" ");
        if (this.rightExpression instanceof BinaryExpression) {
            builder.append("(").append(this.rightExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.rightExpression.getExpressionString());
        }
        return builder.toString();
    }

    protected abstract String operator();
}

