/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class AuthorOperator
extends Operator {
    private final AuthorType authorType;
    private String userName;
    private String roleName;
    private String password;
    private String newPassword;
    private String[] privilegeList;
    private PartialPath nodeName;

    public AuthorOperator(int tokenIntType, AuthorType type) {
        super(tokenIntType);
        this.authorType = type;
        this.operatorType = Operator.OperatorType.AUTHOR;
    }

    public AuthorOperator(int tokenIntType, Operator.OperatorType type) {
        super(tokenIntType);
        this.authorType = null;
        this.operatorType = type;
    }

    public AuthorType getAuthorType() {
        return this.authorType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPassWord() {
        return this.password;
    }

    public void setPassWord(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String[] getPrivilegeList() {
        return this.privilegeList;
    }

    public void setPrivilegeList(String[] authorizationList) {
        this.privilegeList = authorizationList;
    }

    public PartialPath getNodeName() {
        return this.nodeName;
    }

    public void setNodeNameList(PartialPath nodePath) {
        this.nodeName = nodePath;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        try {
            return new AuthorPlan(this.authorType, this.userName, this.roleName, this.password, this.newPassword, this.privilegeList, this.nodeName);
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    public static enum AuthorType {
        CREATE_USER,
        CREATE_ROLE,
        DROP_USER,
        DROP_ROLE,
        GRANT_ROLE,
        GRANT_USER,
        GRANT_USER_ROLE,
        REVOKE_USER,
        REVOKE_ROLE,
        REVOKE_USER_ROLE,
        UPDATE_USER,
        LIST_USER,
        LIST_ROLE,
        LIST_USER_PRIVILEGE,
        LIST_ROLE_PRIVILEGE,
        LIST_USER_ROLES,
        LIST_ROLE_USERS;


        public static AuthorType deserialize(short i) {
            switch (i) {
                case 0: {
                    return CREATE_USER;
                }
                case 1: {
                    return CREATE_ROLE;
                }
                case 2: {
                    return DROP_USER;
                }
                case 3: {
                    return DROP_ROLE;
                }
                case 4: {
                    return GRANT_ROLE;
                }
                case 5: {
                    return GRANT_USER;
                }
                case 6: {
                    return GRANT_USER_ROLE;
                }
                case 7: {
                    return REVOKE_USER;
                }
                case 8: {
                    return REVOKE_ROLE;
                }
                case 9: {
                    return REVOKE_USER_ROLE;
                }
                case 10: {
                    return UPDATE_USER;
                }
                case 11: {
                    return LIST_USER;
                }
                case 12: {
                    return LIST_ROLE;
                }
                case 13: {
                    return LIST_USER_PRIVILEGE;
                }
                case 14: {
                    return LIST_ROLE_PRIVILEGE;
                }
                case 15: {
                    return LIST_USER_ROLES;
                }
                case 16: {
                    return LIST_ROLE_USERS;
                }
            }
            return null;
        }

        public short serialize() {
            switch (this) {
                case CREATE_USER: {
                    return 0;
                }
                case CREATE_ROLE: {
                    return 1;
                }
                case DROP_USER: {
                    return 2;
                }
                case DROP_ROLE: {
                    return 3;
                }
                case GRANT_ROLE: {
                    return 4;
                }
                case GRANT_USER: {
                    return 5;
                }
                case GRANT_USER_ROLE: {
                    return 6;
                }
                case REVOKE_USER: {
                    return 7;
                }
                case REVOKE_ROLE: {
                    return 8;
                }
                case REVOKE_USER_ROLE: {
                    return 9;
                }
                case UPDATE_USER: {
                    return 10;
                }
                case LIST_USER: {
                    return 11;
                }
                case LIST_ROLE: {
                    return 12;
                }
                case LIST_USER_PRIVILEGE: {
                    return 13;
                }
                case LIST_ROLE_PRIVILEGE: {
                    return 14;
                }
                case LIST_USER_ROLES: {
                    return 15;
                }
                case LIST_ROLE_USERS: {
                    return 16;
                }
            }
            return -1;
        }
    }
}

