/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HashLock {
    private static final int DEFAULT_LOCK_NUM = 100;
    private ReentrantReadWriteLock[] locks;
    private int lockSize = 100;

    public HashLock() {
        this.init();
    }

    private void init() {
        this.locks = new ReentrantReadWriteLock[this.lockSize];
        for (int i = 0; i < this.lockSize; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    public void readLock(Object obj) {
        this.locks[Math.abs(obj.hashCode() % this.lockSize)].readLock().lock();
    }

    public void readUnlock(Object obj) {
        this.locks[Math.abs(obj.hashCode() % this.lockSize)].readLock().unlock();
    }

    public void writeLock(Object obj) {
        this.locks[Math.abs(obj.hashCode() % this.lockSize)].writeLock().lock();
    }

    public void writeUnlock(Object obj) {
        this.locks[Math.abs(obj.hashCode() % this.lockSize)].writeLock().unlock();
    }
}

