/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.AbstractModelConverter;
import io.swagger.jackson.JAXBAnnotationsHelper;
import io.swagger.jackson.TypeNameResolver;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.PrimitiveType;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)type;
            this.LOGGER.debug("Can't check class {}, {}", (Object)type, (Object)rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    public Property resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        this.LOGGER.debug("resolveProperty {}", (Object)propType);
        Property property = null;
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                property = new MapProperty().additionalProperties(context.resolveProperty((Type)valueType, new Annotation[0]));
            } else if (valueType != null) {
                Property items = context.resolveProperty((Type)valueType, new Annotation[0]);
                if (annotations != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        Xml xml = items.getXml() != null ? items.getXml() : new Xml();
                        xml.setName(xmlElement.name());
                        items.setXml(xml);
                    }
                }
                ArrayProperty arrayProperty = new ArrayProperty().items(items);
                if (this._isSetType(propType.getRawClass())) {
                    arrayProperty.setUniqueItems(Boolean.valueOf(true));
                }
                property = arrayProperty;
            }
        } else {
            property = PrimitiveType.createProperty((Type)propType);
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new StringProperty();
                this._addEnumProps(propType.getRawClass(), property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolveProperty((Type)propType.containedType(0), null);
            } else {
                Model innerModel = context.resolve((Type)propType);
                if (innerModel instanceof ComposedModel) {
                    innerModel = ((ComposedModel)innerModel).getChild();
                }
                if (innerModel instanceof ModelImpl) {
                    ModelImpl mi = (ModelImpl)innerModel;
                    property = new RefProperty(StringUtils.isNotEmpty((CharSequence)mi.getReference()) ? mi.getReference() : mi.getName());
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, Property property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringProperty)) continue;
            StringProperty sp = (StringProperty)property;
            sp._enum(n);
        }
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        Class parentClass;
        JsonTypeInfo typeInfo;
        String disc;
        XmlRootElement rootAnnotation;
        if (type.isEnumType() || PrimitiveType.fromType((Type)type) != null) {
            return null;
        }
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = this._typeName(type, beanDesc);
        if ("Object".equals(name)) {
            return new ModelImpl();
        }
        Model resolvedModel = context.resolve(type.getRawClass());
        if (resolvedModel != null) {
            Model childModel;
            if (!(resolvedModel instanceof ModelImpl) && !(resolvedModel instanceof ComposedModel) || resolvedModel instanceof ModelImpl && ((ModelImpl)resolvedModel).getName().equals(name)) {
                return resolvedModel;
            }
            if (resolvedModel instanceof ComposedModel && (childModel = ((ComposedModel)resolvedModel).getChild()) != null && (!(childModel instanceof ModelImpl) || ((ModelImpl)childModel).getName().equals(name))) {
                return resolvedModel;
            }
        }
        ModelImpl model = new ModelImpl().type("object").name(name).description(this._description((Annotated)beanDesc.getClassInfo()));
        if (!type.isContainerType()) {
            context.defineModel(name, (Model)model, (Type)type, null);
        }
        if (type.isContainerType()) {
            context.resolve((Type)type.getContentType());
            return null;
        }
        ApiModel apiModel = (ApiModel)beanDesc.getClassAnnotations().get(ApiModel.class);
        if (apiModel != null && StringUtils.isNotEmpty((CharSequence)apiModel.reference())) {
            model.setReference(apiModel.reference());
        }
        if ((rootAnnotation = (XmlRootElement)beanDesc.getClassAnnotations().get(XmlRootElement.class)) != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            this.LOGGER.debug("{}", (Object)rootAnnotation);
            Xml xml = new Xml().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            } else {
                XmlSchema xmlSchma;
                Package pkg = type.getRawClass().getPackage();
                if (pkg != null && (xmlSchma = pkg.getAnnotation(XmlSchema.class)) != null) {
                    xml.namespace(xmlSchma.namespace());
                }
            }
            model.xml(xml);
        }
        XmlAccessorType xmlAccessorTypeAnnotation = (XmlAccessorType)beanDesc.getClassAnnotations().get(XmlAccessorType.class);
        JsonSerialize jasonSerialize = (JsonSerialize)beanDesc.getClassAnnotations().get(JsonSerialize.class);
        if (jasonSerialize != null && jasonSerialize.as() != null) {
            JavaType asType = this._mapper.constructType((Type)jasonSerialize.as());
            beanDesc = this._mapper.getSerializationConfig().introspect(asType);
        }
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        String string = disc = apiModel == null ? "" : apiModel.discriminator();
        if (disc.isEmpty() && (typeInfo = (JsonTypeInfo)beanDesc.getClassAnnotations().get(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            model.setDiscriminator(disc);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        for (Object propDef : beanDesc.findProperties()) {
            AllowableValues allowableValues;
            Integer index;
            String description;
            Boolean required;
            JsonProperty pd;
            String altName;
            Member member;
            RefProperty property = null;
            String propName = propDef.getName();
            Annotation[] annotations = null;
            if (propDef.getPrimaryMember() != null && (member = propDef.getPrimaryMember().getMember()) != null && (altName = member.getName()) != null) {
                int length = altName.length();
                for (String prefix : Arrays.asList("get", "is")) {
                    int offset = prefix.length();
                    if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                    propName = altName;
                    break;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            boolean hasSetter = false;
            boolean hasGetter = false;
            try {
                hasSetter = propDef.getSetter() != null;
            }
            catch (IllegalArgumentException e) {
                hasSetter = true;
            }
            if (propDef.getGetter() != null && (pd = (JsonProperty)propDef.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = true;
            }
            Boolean isReadOnly = null;
            isReadOnly = !hasSetter & hasGetter ? Boolean.TRUE : Boolean.FALSE;
            AnnotatedMember member2 = propDef.getPrimaryMember();
            Boolean allowEmptyValue = null;
            if (member2 == null || this.ignore((Annotated)member2, xmlAccessorTypeAnnotation, propName, propertiesToIgnore)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member2.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            ApiModelProperty mp = (ApiModelProperty)member2.getAnnotation(ApiModelProperty.class);
            if (mp != null && mp.readOnly()) {
                isReadOnly = mp.readOnly();
            }
            allowEmptyValue = mp != null && mp.allowEmptyValue() ? Boolean.valueOf(mp.allowEmptyValue()) : null;
            JavaType propType = member2.getType(beanDesc.bindingsForBeanType());
            if (mp != null && !mp.name().isEmpty()) {
                propName = mp.name();
            }
            if (mp != null && !mp.dataType().isEmpty()) {
                String or = mp.dataType();
                JavaType innerJavaType = null;
                this.LOGGER.debug("overriding datatype from {} to {}", (Object)propType, (Object)or);
                if (or.toLowerCase().startsWith("list[")) {
                    String innerType = or.substring(5, or.length() - 1);
                    ArrayProperty p = new ArrayProperty();
                    Property primitiveProperty = PrimitiveType.createProperty(innerType);
                    if (primitiveProperty != null) {
                        p.setItems(primitiveProperty);
                    } else {
                        innerJavaType = this.getInnerType(innerType);
                        p.setItems(context.resolveProperty((Type)innerJavaType, annotations));
                    }
                    property = p;
                } else if (or.toLowerCase().startsWith("map[")) {
                    int pos = or.indexOf(",");
                    if (pos > 0) {
                        String innerType = or.substring(pos + 1, or.length() - 1);
                        MapProperty p = new MapProperty();
                        Property primitiveProperty = PrimitiveType.createProperty(innerType);
                        if (primitiveProperty != null) {
                            p.setAdditionalProperties(primitiveProperty);
                        } else {
                            innerJavaType = this.getInnerType(innerType);
                            p.setAdditionalProperties(context.resolveProperty((Type)innerJavaType, annotations));
                        }
                        property = p;
                    }
                } else {
                    Property primitiveProperty = PrimitiveType.createProperty(or);
                    if (primitiveProperty != null) {
                        property = primitiveProperty;
                    } else {
                        innerJavaType = this.getInnerType(or);
                        property = context.resolveProperty((Type)innerJavaType, annotations);
                    }
                }
                if (innerJavaType != null) {
                    context.resolve((Type)innerJavaType);
                }
            }
            if (property == null) {
                if (mp != null && StringUtils.isNotEmpty((CharSequence)mp.reference())) {
                    property = new RefProperty(mp.reference());
                } else if (member2.getAnnotation(JsonIdentityInfo.class) != null) {
                    property = GeneratorWrapper.processJsonIdentity(propType, context, this._mapper, (JsonIdentityInfo)member2.getAnnotation(JsonIdentityInfo.class), (JsonIdentityReference)member2.getAnnotation(JsonIdentityReference.class));
                }
                if (property == null) {
                    JsonUnwrapped uw = (JsonUnwrapped)member2.getAnnotation(JsonUnwrapped.class);
                    if (uw != null && uw.enabled()) {
                        this.handleUnwrapped(props, context.resolve((Type)propType), uw.prefix(), uw.suffix());
                    } else {
                        property = context.resolveProperty((Type)propType, annotations);
                    }
                }
            }
            if (property == null) continue;
            property.setName(propName);
            if (mp != null && !mp.access().isEmpty()) {
                property.setAccess(mp.access());
            }
            if ((required = md.getRequired()) != null) {
                property.setRequired(required.booleanValue());
            }
            if ((description = this._intr.findPropertyDescription((Annotated)member2)) != null && !"".equals(description)) {
                property.setDescription(description);
            }
            if ((index = this._intr.findPropertyIndex((Annotated)member2)) != null) {
                property.setPosition(index);
            }
            property.setDefault(this._findDefaultValue((Annotated)member2));
            property.setExample(this._findExampleValue((Annotated)member2));
            property.setReadOnly(this._findReadOnly((Annotated)member2));
            if (allowEmptyValue != null) {
                property.setAllowEmptyValue(allowEmptyValue);
            }
            if (property.getReadOnly() == null && isReadOnly.booleanValue()) {
                property.setReadOnly(isReadOnly);
            }
            if (mp != null && (allowableValues = AllowableValuesUtils.create(mp.allowableValues())) != null) {
                Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
                PropertyBuilder.merge((Property)property, args);
            }
            if (mp != null && mp.extensions() != null) {
                property.getVendorExtensions().clear();
                property.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions(mp.extensions()));
            }
            JAXBAnnotationsHelper.apply(member2, (Property)property);
            this.applyBeanValidatorAnnotations((Property)property, annotations);
            props.add((Property)property);
        }
        Collections.sort(props, ModelResolver.getPropertyComparator());
        LinkedHashMap<String, Property> modelProps = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        model.setProperties(modelProps);
        Class currentType = type.getRawClass();
        context.defineModel(name, (Model)model, currentType, null);
        if (!this.resolveSubtypes(model, beanDesc, context)) {
            model.setDiscriminator(null);
        }
        if (apiModel != null && (parentClass = apiModel.parent()) != null && !parentClass.equals(Void.class) && !this.shouldIgnoreClass(parentClass)) {
            Class[] apiModelSubTypes;
            JavaType parentType = this._mapper.constructType((Type)parentClass);
            BeanDescription parentBeanDesc = this._mapper.getSerializationConfig().introspect(parentType);
            boolean currentTypeIsParentSubType = false;
            List subTypes = this._intr.findSubtypes((Annotated)parentBeanDesc.getClassInfo());
            if (subTypes != null) {
                for (NamedType subType : subTypes) {
                    if (!subType.getType().equals(currentType)) continue;
                    currentTypeIsParentSubType = true;
                    break;
                }
            }
            boolean currentTypeIsParentApiModelSubType = false;
            ApiModel parentApiModel = (ApiModel)parentBeanDesc.getClassAnnotations().get(ApiModel.class);
            if (parentApiModel != null && (apiModelSubTypes = parentApiModel.subTypes()) != null) {
                for (Class subType : apiModelSubTypes) {
                    if (!subType.equals(currentType)) continue;
                    currentTypeIsParentApiModelSubType = true;
                    break;
                }
            }
            if (currentTypeIsParentSubType && currentTypeIsParentApiModelSubType) {
                context.resolve(parentClass);
                return context.resolve(currentType);
            }
        }
        return model;
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class) && !member.hasAnnotation(XmlAttribute.class);
    }

    private void handleUnwrapped(List<Property> props, Model innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix) && StringUtils.isBlank((CharSequence)prefix)) {
            Map innerProps;
            if (innerModel != null && (innerProps = innerModel.getProperties()) != null) {
                props.addAll(innerProps.values());
            }
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            for (Property prop : innerModel.getProperties().values()) {
                props.add(prop.rename(prefix + prop.getName() + suffix));
            }
        }
    }

    protected void applyBeanValidatorAnnotations(Property property, Annotation[] annotations) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (annos.containsKey("javax.validation.constraints.NotNull")) {
            property.setRequired(true);
        }
        if (annos.containsKey("javax.validation.constraints.Min") && property instanceof AbstractNumericProperty) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMinimum(new BigDecimal(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && property instanceof AbstractNumericProperty) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMaximum(new BigDecimal(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new BigDecimal(size.min()));
                ap.setMaximum(new BigDecimal(size.max()));
            } else if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            } else if (property instanceof ArrayProperty) {
                ArrayProperty sp = (ArrayProperty)property;
                sp.setMinItems(Integer.valueOf(size.min()));
                sp.setMaxItems(Integer.valueOf(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new BigDecimal(min.value()));
                ap.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMaximum(new BigDecimal(max.value()));
                ap.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.Pattern")) {
            Pattern pattern = (Pattern)annos.get("javax.validation.constraints.Pattern");
            if (property instanceof StringProperty) {
                StringProperty ap = (StringProperty)property;
                ap.setPattern(pattern.regexp());
            }
        }
    }

    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = ReflectionUtils.loadClassByName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveSubtypes(ModelImpl model, BeanDescription bean, ModelConverterContext context) {
        List types = this._intr.findSubtypes((Annotated)bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        int count = 0;
        Class beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Model subtypeModel;
            Class subtypeType = subtype.getType();
            if (!beanClass.isAssignableFrom(subtypeType) || !((subtypeModel = context.resolve(subtypeType)) instanceof ModelImpl)) continue;
            ModelImpl impl = (ModelImpl)subtypeModel;
            if (impl.getName().equals(model.getName())) {
                impl.setName(this._typeNameResolver.nameForType(this._mapper.constructType((Type)subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            Map baseProps = model.getProperties();
            Map subtypeProps = impl.getProperties();
            if (baseProps != null && subtypeProps != null) {
                for (Map.Entry entry : baseProps.entrySet()) {
                    if (!((Property)entry.getValue()).equals(subtypeProps.get(entry.getKey()))) continue;
                    subtypeProps.remove(entry.getKey());
                }
            }
            impl.setDiscriminator(null);
            ComposedModel child = new ComposedModel().parent((Model)new RefModel(model.getName())).child((Model)impl);
            context.defineModel(impl.getName(), (Model)child, subtypeType, null);
            ++count;
        }
        return count != 0;
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class beanClass = bean.getType().getRawClass();
        Class superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        BeanDescription superBean = this._mapper.getSerializationConfig().introspect(superType);
        List superTypes = this._intr.findSubtypes((Annotated)superBean.getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private static enum GeneratorWrapper {
        PROPERTY(ObjectIdGenerators.PropertyGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                BeanDescription beanDesc = mapper.getSerializationConfig().introspect(type);
                for (BeanPropertyDefinition def : beanDesc.findProperties()) {
                    String name = def.getName();
                    if (name == null || !name.equals(propertyName)) continue;
                    AnnotatedMember propMember = def.getPrimaryMember();
                    JavaType propType = propMember.getType(beanDesc.bindingsForBeanType());
                    if (PrimitiveType.fromType((Type)propType) != null) {
                        return PrimitiveType.createProperty((Type)propType);
                    }
                    return context.resolveProperty((Type)propType, (Annotation[])Iterables.toArray((Iterable)propMember.annotations(), Annotation.class));
                }
                return null;
            }
        }
        ,
        INT(ObjectIdGenerators.IntSequenceGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                IntegerProperty id = new IntegerProperty();
                return GeneratorWrapper.process((Property)id, propertyName, type, context);
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new IntegerProperty();
            }
        }
        ,
        UUID(ObjectIdGenerators.UUIDGenerator.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                UUIDProperty id = new UUIDProperty();
                return GeneratorWrapper.process((Property)id, propertyName, type, context);
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return new UUIDProperty();
            }
        }
        ,
        NONE(ObjectIdGenerators.None.class){

            @Override
            protected Property processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Property processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }
        };

        private final Class<? extends ObjectIdGenerator> generator;

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract Property processAsProperty(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract Property processAsId(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        public static Property processJsonIdentity(JavaType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static Property process(Property id, String propertyName, JavaType type, ModelConverterContext context) {
            id.setName(propertyName);
            Model model = context.resolve((Type)type);
            if (model instanceof ComposedModel) {
                model = ((ComposedModel)model).getChild();
            }
            if (model instanceof ModelImpl) {
                ModelImpl mi = (ModelImpl)model;
                mi.getProperties().put(propertyName, id);
                return new RefProperty(StringUtils.isNotEmpty((CharSequence)mi.getReference()) ? mi.getReference() : mi.getName());
            }
            return null;
        }
    }
}

