/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricNameTool;
import org.apache.iotdb.metrics.dropwizard.reporter.DropwizardMetricType;
import org.apache.iotdb.metrics.dropwizard.reporter.PrometheusTextWriter;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;

class DropwizardMetricsExporter {
    private final MetricRegistry metricRegistry;
    private final PrometheusTextWriter writer;

    public DropwizardMetricsExporter(MetricRegistry metricRegistry, PrometheusTextWriter writer) {
        this.metricRegistry = metricRegistry;
        this.writer = writer;
    }

    public void scrape() throws IOException {
        for (Map.Entry entry : this.metricRegistry.getGauges().entrySet()) {
            this.writeGauge((String)entry.getKey(), (Gauge)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getCounters().entrySet()) {
            this.writeCounter((String)entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getHistograms().entrySet()) {
            this.writeHistogram((String)entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getMeters().entrySet()) {
            this.writeMeter((String)entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getTimers().entrySet()) {
            this.writeTimer((String)entry.getKey(), (Timer)entry.getValue());
        }
    }

    public void writeGauge(String dropwizardName, Gauge<?> gauge) throws IOException {
        double value;
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.GAUGE, dropwizardName);
        String sanitizeName = metricInfo.getName();
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, gauge));
        this.writer.writeType(sanitizeName, DropwizardMetricType.GAUGE);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            return;
        }
        this.writer.writeSample(sanitizeName, metricInfo.getTags(), value);
    }

    public void writeCounter(String dropwizardName, Counter counter) throws IOException {
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.COUNTER, dropwizardName);
        String sanitizeName = metricInfo.getName() + "_total";
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)counter));
        this.writer.writeType(sanitizeName, DropwizardMetricType.GAUGE);
        this.writer.writeSample(sanitizeName, metricInfo.getTags(), counter.getCount());
    }

    public void writeHistogram(String dropwizardName, Histogram histogram) throws IOException {
        this.writeSnapshotAndCount(DropwizardMetricNameTool.transformFromString(MetricType.HISTOGRAM, dropwizardName), histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    private void writeSnapshotAndCount(MetricInfo metricInfo, Snapshot snapshot, long count, double factor, String helpMessage) throws IOException {
        String sanitizeName = metricInfo.getName() + "_seconds";
        this.writer.writeHelp(sanitizeName, helpMessage);
        this.writer.writeType(sanitizeName, DropwizardMetricType.SUMMARY);
        Map tags = metricInfo.getTags();
        this.writer.writeSample(sanitizeName + "_max", tags, (double)snapshot.getMax() * factor);
        this.writer.writeSample(sanitizeName + "_sum", tags, (double)Arrays.stream(snapshot.getValues()).sum() * factor);
        this.writer.writeSample(sanitizeName + "_count", tags, count);
    }

    public void writeTimer(String dropwizardName, Timer timer) throws IOException {
        this.writeSnapshotAndCount(DropwizardMetricNameTool.transformFromString(MetricType.TIMER, dropwizardName), timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)timer));
    }

    public void writeMeter(String dropwizardName, Meter meter) throws IOException {
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.COUNTER, dropwizardName);
        String sanitizeName = metricInfo.getName() + "_total";
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)meter));
        this.writer.writeType(sanitizeName, DropwizardMetricType.COUNTER);
        this.writer.writeSample(sanitizeName, metricInfo.getTags(), meter.getCount());
        this.writeMetered(metricInfo, (Metered)meter);
    }

    private void writeMetered(MetricInfo metricInfo, Metered metered) throws IOException {
        String sanitizeName = metricInfo.getName();
        Map tags = metricInfo.getTags();
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m1"), metered.getOneMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m5"), metered.getFiveMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m15"), metered.getFifteenMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "mean"), metered.getMeanRate());
    }

    private Map<String, String> addTags(Map<String, String> tags, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put(key, value);
        return result;
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }
}

