/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public abstract class BaseAsyncService
implements RaftService.AsyncIface {
    RaftMember member;
    String name;

    BaseAsyncService(RaftMember member) {
        this.member = member;
        this.name = member.getName();
    }

    public void sendHeartbeat(HeartBeatRequest request, AsyncMethodCallback<HeartBeatResponse> resultHandler) {
        resultHandler.onComplete((Object)this.member.processHeartbeatRequest(request));
    }

    public void startElection(ElectionRequest request, AsyncMethodCallback<Long> resultHandler) {
        resultHandler.onComplete((Object)this.member.processElectionRequest(request));
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback<Long> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.member.appendEntry(request));
        }
        catch (UnknownLogTypeException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void appendEntries(AppendEntriesRequest request, AsyncMethodCallback<Long> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.member.appendEntries(request));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCommitIndex(RaftNode header, AsyncMethodCallback<RequestCommitIndexResponse> resultHandler) {
        long curTerm;
        long commitTerm;
        long commitIndex;
        AtomicLong atomicLong = this.member.getTerm();
        synchronized (atomicLong) {
            commitIndex = this.member.getLogManager().getCommitLogIndex();
            commitTerm = this.member.getLogManager().getCommitLogTerm();
            curTerm = this.member.getTerm().get();
        }
        RequestCommitIndexResponse response = new RequestCommitIndexResponse(curTerm, commitIndex, commitTerm);
        if (commitIndex != Long.MIN_VALUE) {
            resultHandler.onComplete((Object)response);
            return;
        }
        this.member.waitLeader();
        RaftService.AsyncClient client = this.member.getAsyncClient(this.member.getLeader());
        if (client == null) {
            resultHandler.onError((Exception)new LeaderUnknownException(this.member.getAllNodes()));
            return;
        }
        try {
            client.requestCommitIndex(header, resultHandler);
        }
        catch (TException e) {
            resultHandler.onError((Exception)((Object)e));
        }
    }

    public void readFile(String filePath, long offset, int length, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)IOUtils.readFile(filePath, offset, length));
        }
        catch (IOException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void removeHardLink(String hardLinkPath, AsyncMethodCallback<Void> resultHandler) {
        try {
            Files.deleteIfExists(new File(hardLinkPath).toPath());
            resultHandler.onComplete(null);
        }
        catch (IOException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void matchTerm(long index, long term, RaftNode header, AsyncMethodCallback<Boolean> resultHandler) {
        resultHandler.onComplete((Object)this.member.matchLog(index, term));
    }

    public void executeNonQueryPlan(ExecutNonQueryReq request, AsyncMethodCallback<TSStatus> resultHandler) {
        if (this.member.getCharacter() != NodeCharacter.LEADER) {
            RaftService.AsyncClient client = this.member.getAsyncClient(this.member.getLeader());
            if (client != null) {
                try {
                    client.executeNonQueryPlan(request, resultHandler);
                }
                catch (TException e) {
                    resultHandler.onError((Exception)((Object)e));
                }
            } else {
                resultHandler.onComplete((Object)StatusUtils.NO_LEADER);
            }
            return;
        }
        try {
            TSStatus status = this.member.executeNonQueryPlan(request);
            resultHandler.onComplete((Object)StatusUtils.getStatus(status, new EndPoint(this.member.getThisNode().getClientIp(), this.member.getThisNode().getClientPort())));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }
}

