/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition.slot;

import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.tsfile.utils.Murmur128Hash;

public interface SlotStrategy {
    public int calculateSlotByTime(String var1, long var2, int var4);

    public int calculateSlotByPartitionNum(String var1, long var2, int var4);

    public static class DefaultStrategy
    implements SlotStrategy {
        @Override
        public int calculateSlotByTime(String storageGroupName, long timestamp, int maxSlotNum) {
            long partitionNum = StorageEngine.getTimePartition((long)timestamp);
            return this.calculateSlotByPartitionNum(storageGroupName, partitionNum, maxSlotNum);
        }

        @Override
        public int calculateSlotByPartitionNum(String storageGroupName, long partitionId, int maxSlotNum) {
            int hash = Murmur128Hash.hash((String)storageGroupName, (long)partitionId, (int)2333);
            return Math.abs(hash % maxSlotNum);
        }
    }
}

