/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;

public class MetaUtils {
    private MetaUtils() {
    }

    public static String[] splitPathToDetachedPath(String path) throws IllegalPathException {
        ArrayList<String> nodes = new ArrayList<String>();
        int startIndex = 0;
        for (int i = 0; i < path.length(); ++i) {
            String node;
            if (path.charAt(i) == '.') {
                String node2 = path.substring(startIndex, i);
                if (node2.isEmpty()) {
                    throw new IllegalPathException(path);
                }
                nodes.add(node2);
                startIndex = i + 1;
                if (startIndex != path.length()) continue;
                throw new IllegalPathException(path);
            }
            if (path.charAt(i) == '\"') {
                if (i > 0 && path.charAt(i - 1) == '\\') continue;
                int endIndex = path.indexOf(34, i + 1);
                while (endIndex != -1 && path.charAt(endIndex - 1) == '\\') {
                    endIndex = path.indexOf(34, endIndex + 1);
                }
                if (endIndex != -1 && (endIndex == path.length() - 1 || path.charAt(endIndex + 1) == '.')) {
                    node = path.substring(startIndex, endIndex + 1);
                    if (node.isEmpty()) {
                        throw new IllegalPathException(path);
                    }
                    nodes.add(node);
                    i = endIndex + 1;
                    startIndex = endIndex + 2;
                    continue;
                }
                throw new IllegalPathException(path);
            }
            if (path.charAt(i) != '\'' || i > 0 && path.charAt(i - 1) == '\\') continue;
            int endIndex = path.indexOf(39, i + 1);
            while (endIndex != -1 && path.charAt(endIndex - 1) == '\\') {
                endIndex = path.indexOf(39, endIndex + 1);
            }
            if (endIndex != -1 && (endIndex == path.length() - 1 || path.charAt(endIndex + 1) == '.')) {
                node = path.substring(startIndex, endIndex + 1);
                if (node.isEmpty()) {
                    throw new IllegalPathException(path);
                }
                nodes.add(node);
                i = endIndex + 1;
                startIndex = endIndex + 2;
                continue;
            }
            throw new IllegalPathException(path);
        }
        if (startIndex <= path.length() - 1) {
            String node = path.substring(startIndex);
            if (node.isEmpty()) {
                throw new IllegalPathException(path);
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    public static PartialPath getStorageGroupPathByLevel(PartialPath path, int level) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= level || !nodeNames[0].equals("root")) {
            throw new IllegalPathException(path.getFullPath());
        }
        String[] storageGroupNodes = new String[level + 1];
        System.arraycopy(nodeNames, 0, storageGroupNodes, 0, level + 1);
        return new PartialPath(storageGroupNodes);
    }

    public static List<PartialPath> groupAlignedPaths(List<PartialPath> fullPaths) {
        LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        PartialPath alignedPath = null;
        for (PartialPath path : fullPaths) {
            MeasurementPath measurementPath = (MeasurementPath)path;
            if (!measurementPath.isUnderAlignedEntity()) {
                result.add(measurementPath);
                alignedPath = null;
                continue;
            }
            if (alignedPath == null || !alignedPath.equals(measurementPath.getDevice())) {
                alignedPath = new AlignedPath(measurementPath);
                result.add(alignedPath);
                continue;
            }
            ((AlignedPath)alignedPath).addMeasurement(measurementPath);
        }
        return result;
    }

    public static List<String> getMultiFullPaths(IMNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<IMNode> lastNodeList = new ArrayList<IMNode>();
        MetaUtils.collectLastNode(node, lastNodeList);
        ArrayList<String> result = new ArrayList<String>();
        for (IMNode lastNode : lastNodeList) {
            result.add(lastNode.getFullPath());
        }
        return result;
    }

    public static void collectLastNode(IMNode node, List<IMNode> lastNodeList) {
        if (node != null) {
            Map<String, IMNode> children = node.getChildren();
            if (children.isEmpty()) {
                lastNodeList.add(node);
            }
            for (Map.Entry<String, IMNode> entry : children.entrySet()) {
                IMNode childNode = entry.getValue();
                MetaUtils.collectLastNode(childNode, lastNodeList);
            }
        }
    }

    public static Map<PartialPath, List<Integer>> groupAggregationsBySeries(List<? extends Path> selectedPaths) {
        HashMap<PartialPath, List<Integer>> pathToAggrIndexesMap = new HashMap<PartialPath, List<Integer>>();
        for (int i = 0; i < selectedPaths.size(); ++i) {
            PartialPath series = (PartialPath)selectedPaths.get(i);
            pathToAggrIndexesMap.computeIfAbsent(series, key -> new ArrayList()).add(i);
        }
        return pathToAggrIndexesMap;
    }

    public static Map<AlignedPath, List<List<Integer>>> groupAlignedSeriesWithAggregations(Map<PartialPath, List<Integer>> pathToAggrIndexesMap) {
        HashMap<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = new HashMap<AlignedPath, List<List<Integer>>>();
        HashMap<String, AlignedPath> temp = new HashMap<String, AlignedPath>();
        ArrayList<PartialPath> seriesPaths = new ArrayList<PartialPath>(pathToAggrIndexesMap.keySet());
        for (PartialPath seriesPath : seriesPaths) {
            List subIndexes;
            AlignedPath groupPath;
            List<Integer> indexes;
            if (seriesPath instanceof AlignedPath) {
                indexes = pathToAggrIndexesMap.remove(seriesPath);
                groupPath = (AlignedPath)temp.get(seriesPath.getFullPath());
                if (groupPath == null) {
                    groupPath = (AlignedPath)seriesPath.copy();
                    temp.put(groupPath.getFullPath(), groupPath);
                    alignedPathToAggrIndexesMap.computeIfAbsent(groupPath, key -> new ArrayList()).add(indexes);
                    continue;
                }
                subIndexes = (List)alignedPathToAggrIndexesMap.remove(groupPath);
                subIndexes.add(indexes);
                groupPath.addMeasurements(((AlignedPath)seriesPath).getMeasurementList());
                groupPath.addSchemas(((AlignedPath)seriesPath).getSchemaList());
                alignedPathToAggrIndexesMap.put(groupPath, subIndexes);
                continue;
            }
            if (!((MeasurementPath)seriesPath).isUnderAlignedEntity()) continue;
            indexes = pathToAggrIndexesMap.remove(seriesPath);
            groupPath = (AlignedPath)temp.get(seriesPath.getDevice());
            if (groupPath == null) {
                groupPath = new AlignedPath((MeasurementPath)seriesPath);
                temp.put(seriesPath.getDevice(), groupPath);
                alignedPathToAggrIndexesMap.computeIfAbsent(groupPath, key -> new ArrayList()).add(indexes);
                continue;
            }
            subIndexes = (List)alignedPathToAggrIndexesMap.remove(groupPath);
            subIndexes.add(indexes);
            groupPath.addMeasurement((MeasurementPath)seriesPath);
            alignedPathToAggrIndexesMap.put(groupPath, subIndexes);
        }
        return alignedPathToAggrIndexesMap;
    }

    public static Pair<String, String> parseDeadbandInfo(Map<String, String> props) {
        if (props == null) {
            return new Pair(null, null);
        }
        String deadband = props.get("loss");
        deadband = deadband == null ? null : deadband.toUpperCase(Locale.ROOT);
        HashMap<String, String> deadbandParameters = new HashMap<String, String>();
        for (String k : IoTDBConstant.SDT_PARAMETERS) {
            if (!props.containsKey(k)) continue;
            deadbandParameters.put(k, props.get(k));
        }
        return new Pair((Object)deadband, deadbandParameters.isEmpty() ? null : String.format("%s", deadbandParameters));
    }
}

