/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.monitor;

import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.NodeStatus;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStatusManager {
    private static final Logger logger = LoggerFactory.getLogger(NodeStatusManager.class);
    private static final long NODE_STATUS_UPDATE_INTERVAL_MS = 60000L;
    private static final NodeStatusManager INSTANCE = new NodeStatusManager();
    private MetaGroupMember metaGroupMember;
    private Map<Node, NodeStatus> nodeStatusMap = new ConcurrentHashMap<Node, NodeStatus>();

    public static NodeStatusManager getINSTANCE() {
        return INSTANCE;
    }

    public void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    private TNodeStatus getNodeStatusWithAsyncServer(Node node) {
        TNodeStatus status;
        AsyncMetaClient asyncMetaClient = (AsyncMetaClient)this.metaGroupMember.getAsyncClient(node);
        if (asyncMetaClient == null) {
            return null;
        }
        try {
            status = SyncClientAdaptor.queryNodeStatus(asyncMetaClient);
        }
        catch (TException e) {
            if (e.getCause() instanceof ConnectException) {
                logger.warn("Cannot query the node status of {}: {}", (Object)node, (Object)e.getCause());
            } else {
                logger.error("query node status failed {}", (Object)node, (Object)e);
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Cannot query the node status of {}", (Object)node, (Object)e);
            return null;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TNodeStatus getNodeStatusWithSyncServer(Node node) {
        TNodeStatus status;
        SyncMetaClient syncMetaClient = (SyncMetaClient)this.metaGroupMember.getSyncClient(node);
        if (syncMetaClient == null) {
            logger.error("Cannot query the node status of {} for no available client", (Object)node);
            return null;
        }
        try {
            status = syncMetaClient.queryNodeStatus();
        }
        catch (TException e) {
            syncMetaClient.getInputProtocol().getTransport().close();
            logger.error("Cannot query the node status of {}", (Object)node, (Object)e);
            TNodeStatus tNodeStatus = null;
            return tNodeStatus;
        }
        finally {
            ClientUtils.putBackSyncClient((RaftService.Client)syncMetaClient);
        }
        return status;
    }

    public NodeStatus getNodeStatus(Node node, boolean tryUpdate) {
        NodeStatus nodeStatus = this.nodeStatusMap.computeIfAbsent(node, n -> new NodeStatus());
        if (this.metaGroupMember == null || node.equals(this.metaGroupMember.getThisNode())) {
            return nodeStatus;
        }
        if (tryUpdate) {
            this.tryUpdateNodeStatus(node, nodeStatus);
        }
        return nodeStatus;
    }

    private void tryUpdateNodeStatus(Node node, NodeStatus nodeStatus) {
        long currTime = System.currentTimeMillis();
        if (nodeStatus.getStatus() != null && currTime - nodeStatus.getLastUpdateTime() <= 60000L) {
            return;
        }
        long startTime = System.nanoTime();
        TNodeStatus status = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.getNodeStatusWithAsyncServer(node) : this.getNodeStatusWithSyncServer(node);
        long responseTime = System.nanoTime() - startTime;
        if (status != null) {
            nodeStatus.setStatus(status);
            nodeStatus.setLastUpdateTime(System.currentTimeMillis());
            nodeStatus.setLastResponseLatency(responseTime);
        } else {
            nodeStatus.setLastResponseLatency(Long.MAX_VALUE);
        }
        logger.info("NodeStatus of {} is updated, status: {}, response time: {}", new Object[]{node, nodeStatus.getStatus(), nodeStatus.getLastResponseLatency()});
    }

    public long getLastResponseLatency(Node node) {
        NodeStatus nodeStatus = this.getNodeStatus(node, true);
        return nodeStatus.getLastResponseLatency();
    }

    public void clear() {
        this.nodeStatusMap.clear();
    }

    public void activate(Node node) {
        this.getNodeStatus(node, false).activate();
    }

    public void deactivate(Node node) {
        this.getNodeStatus(node, false).deactivate();
    }

    public boolean isActivated(Node node) {
        return this.getNodeStatus(node, false).isActivated();
    }
}

