package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.VariableMatrixWidth;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A tile matrix, usually corresponding to a particular zoom level of a TileMatrixSet.
 **/
@ApiModel(description = "A tile matrix, usually corresponding to a particular zoom level of a TileMatrixSet.")
@JsonTypeName("tileMatrix")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileMatrix   {
  private @Valid String title;
  private @Valid String description;
  private @Valid List<String> keywords = null;
  private @Valid String id;
  private @Valid BigDecimal scaleDenominator;
  private @Valid BigDecimal cellSize;
  public enum CornerOfOriginEnum {

    TOPLEFT(String.valueOf("topLeft")), BOTTOMLEFT(String.valueOf("bottomLeft"));


    private String value;

    CornerOfOriginEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static CornerOfOriginEnum fromString(String s) {
        for (CornerOfOriginEnum b : CornerOfOriginEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static CornerOfOriginEnum fromValue(String value) {
        for (CornerOfOriginEnum b : CornerOfOriginEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid CornerOfOriginEnum cornerOfOrigin = CornerOfOriginEnum.TOPLEFT;
  private @Valid Object pointOfOrigin;
  private @Valid BigDecimal tileWidth;
  private @Valid BigDecimal tileHeight;
  private @Valid BigDecimal matrixHeight;
  private @Valid BigDecimal matrixWidth;
  private @Valid List<VariableMatrixWidth> variableMatrixWidths = null;

  /**
   * Title of this tile matrix, normally used for display to a human
   **/
  public TileMatrix title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Title of this tile matrix, normally used for display to a human")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Brief narrative description of this tile matrix set, normally available for display to a human
   **/
  public TileMatrix description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Brief narrative description of this tile matrix set, normally available for display to a human")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this dataset
   **/
  public TileMatrix keywords(List<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this dataset")
  @JsonProperty("keywords")
  public List<String> getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  public TileMatrix addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }

    this.keywords.add(keywordsItem);
    return this;
  }

  public TileMatrix removeKeywordsItem(String keywordsItem) {
    if (keywordsItem != null && this.keywords != null) {
      this.keywords.remove(keywordsItem);
    }

    return this;
  }
  /**
   * Identifier selecting one of the scales defined in the TileMatrixSet and representing the scaleDenominator the tile. Implementation of &#39;identifier&#39;
   **/
  public TileMatrix id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Identifier selecting one of the scales defined in the TileMatrixSet and representing the scaleDenominator the tile. Implementation of 'identifier'")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   * Scale denominator of this tile matrix
   **/
  public TileMatrix scaleDenominator(BigDecimal scaleDenominator) {
    this.scaleDenominator = scaleDenominator;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Scale denominator of this tile matrix")
  @JsonProperty("scaleDenominator")
  @NotNull
  public BigDecimal getScaleDenominator() {
    return scaleDenominator;
  }

  @JsonProperty("scaleDenominator")
  public void setScaleDenominator(BigDecimal scaleDenominator) {
    this.scaleDenominator = scaleDenominator;
  }

  /**
   * Cell size of this tile matrix
   **/
  public TileMatrix cellSize(BigDecimal cellSize) {
    this.cellSize = cellSize;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Cell size of this tile matrix")
  @JsonProperty("cellSize")
  @NotNull
  public BigDecimal getCellSize() {
    return cellSize;
  }

  @JsonProperty("cellSize")
  public void setCellSize(BigDecimal cellSize) {
    this.cellSize = cellSize;
  }

  /**
   * The corner of the tile matrix (_topLeft_ or _bottomLeft_) used as the origin for numbering tile rows and columns. This corner is also a corner of the (0, 0) tile.
   **/
  public TileMatrix cornerOfOrigin(CornerOfOriginEnum cornerOfOrigin) {
    this.cornerOfOrigin = cornerOfOrigin;
    return this;
  }

  
  @ApiModelProperty(value = "The corner of the tile matrix (_topLeft_ or _bottomLeft_) used as the origin for numbering tile rows and columns. This corner is also a corner of the (0, 0) tile.")
  @JsonProperty("cornerOfOrigin")
  public CornerOfOriginEnum getCornerOfOrigin() {
    return cornerOfOrigin;
  }

  @JsonProperty("cornerOfOrigin")
  public void setCornerOfOrigin(CornerOfOriginEnum cornerOfOrigin) {
    this.cornerOfOrigin = cornerOfOrigin;
  }

  /**
   **/
  public TileMatrix pointOfOrigin(Object pointOfOrigin) {
    this.pointOfOrigin = pointOfOrigin;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("pointOfOrigin")
  @NotNull
  public Object getPointOfOrigin() {
    return pointOfOrigin;
  }

  @JsonProperty("pointOfOrigin")
  public void setPointOfOrigin(Object pointOfOrigin) {
    this.pointOfOrigin = pointOfOrigin;
  }

  /**
   * Width of each tile of this tile matrix in pixels
   * minimum: 1
   **/
  public TileMatrix tileWidth(BigDecimal tileWidth) {
    this.tileWidth = tileWidth;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Width of each tile of this tile matrix in pixels")
  @JsonProperty("tileWidth")
  @NotNull
 @DecimalMin("1")  public BigDecimal getTileWidth() {
    return tileWidth;
  }

  @JsonProperty("tileWidth")
  public void setTileWidth(BigDecimal tileWidth) {
    this.tileWidth = tileWidth;
  }

  /**
   * Height of each tile of this tile matrix in pixels
   * minimum: 1
   **/
  public TileMatrix tileHeight(BigDecimal tileHeight) {
    this.tileHeight = tileHeight;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Height of each tile of this tile matrix in pixels")
  @JsonProperty("tileHeight")
  @NotNull
 @DecimalMin("1")  public BigDecimal getTileHeight() {
    return tileHeight;
  }

  @JsonProperty("tileHeight")
  public void setTileHeight(BigDecimal tileHeight) {
    this.tileHeight = tileHeight;
  }

  /**
   * Width of the matrix (number of tiles in width)
   * minimum: 1
   **/
  public TileMatrix matrixHeight(BigDecimal matrixHeight) {
    this.matrixHeight = matrixHeight;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Width of the matrix (number of tiles in width)")
  @JsonProperty("matrixHeight")
  @NotNull
 @DecimalMin("1")  public BigDecimal getMatrixHeight() {
    return matrixHeight;
  }

  @JsonProperty("matrixHeight")
  public void setMatrixHeight(BigDecimal matrixHeight) {
    this.matrixHeight = matrixHeight;
  }

  /**
   * Height of the matrix (number of tiles in height)
   * minimum: 1
   **/
  public TileMatrix matrixWidth(BigDecimal matrixWidth) {
    this.matrixWidth = matrixWidth;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Height of the matrix (number of tiles in height)")
  @JsonProperty("matrixWidth")
  @NotNull
 @DecimalMin("1")  public BigDecimal getMatrixWidth() {
    return matrixWidth;
  }

  @JsonProperty("matrixWidth")
  public void setMatrixWidth(BigDecimal matrixWidth) {
    this.matrixWidth = matrixWidth;
  }

  /**
   * Describes the rows that has variable matrix width
   **/
  public TileMatrix variableMatrixWidths(List<VariableMatrixWidth> variableMatrixWidths) {
    this.variableMatrixWidths = variableMatrixWidths;
    return this;
  }

  
  @ApiModelProperty(value = "Describes the rows that has variable matrix width")
  @JsonProperty("variableMatrixWidths")
  public List<VariableMatrixWidth> getVariableMatrixWidths() {
    return variableMatrixWidths;
  }

  @JsonProperty("variableMatrixWidths")
  public void setVariableMatrixWidths(List<VariableMatrixWidth> variableMatrixWidths) {
    this.variableMatrixWidths = variableMatrixWidths;
  }

  public TileMatrix addVariableMatrixWidthsItem(VariableMatrixWidth variableMatrixWidthsItem) {
    if (this.variableMatrixWidths == null) {
      this.variableMatrixWidths = new ArrayList<>();
    }

    this.variableMatrixWidths.add(variableMatrixWidthsItem);
    return this;
  }

  public TileMatrix removeVariableMatrixWidthsItem(VariableMatrixWidth variableMatrixWidthsItem) {
    if (variableMatrixWidthsItem != null && this.variableMatrixWidths != null) {
      this.variableMatrixWidths.remove(variableMatrixWidthsItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileMatrix tileMatrix = (TileMatrix) o;
    return Objects.equals(this.title, tileMatrix.title) &&
        Objects.equals(this.description, tileMatrix.description) &&
        Objects.equals(this.keywords, tileMatrix.keywords) &&
        Objects.equals(this.id, tileMatrix.id) &&
        Objects.equals(this.scaleDenominator, tileMatrix.scaleDenominator) &&
        Objects.equals(this.cellSize, tileMatrix.cellSize) &&
        Objects.equals(this.cornerOfOrigin, tileMatrix.cornerOfOrigin) &&
        Objects.equals(this.pointOfOrigin, tileMatrix.pointOfOrigin) &&
        Objects.equals(this.tileWidth, tileMatrix.tileWidth) &&
        Objects.equals(this.tileHeight, tileMatrix.tileHeight) &&
        Objects.equals(this.matrixHeight, tileMatrix.matrixHeight) &&
        Objects.equals(this.matrixWidth, tileMatrix.matrixWidth) &&
        Objects.equals(this.variableMatrixWidths, tileMatrix.variableMatrixWidths);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, keywords, id, scaleDenominator, cellSize, cornerOfOrigin, pointOfOrigin, tileWidth, tileHeight, matrixHeight, matrixWidth, variableMatrixWidths);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileMatrix {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    scaleDenominator: ").append(toIndentedString(scaleDenominator)).append("\n");
    sb.append("    cellSize: ").append(toIndentedString(cellSize)).append("\n");
    sb.append("    cornerOfOrigin: ").append(toIndentedString(cornerOfOrigin)).append("\n");
    sb.append("    pointOfOrigin: ").append(toIndentedString(pointOfOrigin)).append("\n");
    sb.append("    tileWidth: ").append(toIndentedString(tileWidth)).append("\n");
    sb.append("    tileHeight: ").append(toIndentedString(tileHeight)).append("\n");
    sb.append("    matrixHeight: ").append(toIndentedString(matrixHeight)).append("\n");
    sb.append("    matrixWidth: ").append(toIndentedString(matrixWidth)).append("\n");
    sb.append("    variableMatrixWidths: ").append(toIndentedString(variableMatrixWidths)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

