package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.CollectionInfoDataType;
import org.apache.baremaps.ogcapi.model.ExtentUad;
import org.apache.baremaps.ogcapi.model.Link;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("collection")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class Collection   {
  private @Valid String id;
  private @Valid String title;
  private @Valid String description;
  private @Valid List<Link> links = new ArrayList<>();
  private @Valid ExtentUad extent;
  private @Valid String itemType = "unknown";
  private @Valid List<String> crs = null;
  private @Valid CollectionInfoDataType dataType;
  private @Valid Integer geometryDimension;
  private @Valid BigDecimal minScaleDenominator;
  private @Valid BigDecimal maxScaleDenominator;
  private @Valid BigDecimal minCellSize;
  private @Valid BigDecimal maxCellSize;

  /**
   * identifier of the collection used, for example, in URIs
   **/
  public Collection id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "identifier of the collection used, for example, in URIs")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   * human readable title of the collection
   **/
  public Collection title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "human readable title of the collection")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * a description of the data in the collection
   **/
  public Collection description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "a description of the data in the collection")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public Collection links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public Collection addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public Collection removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }
  /**
   **/
  public Collection extent(ExtentUad extent) {
    this.extent = extent;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("extent")
  public ExtentUad getExtent() {
    return extent;
  }

  @JsonProperty("extent")
  public void setExtent(ExtentUad extent) {
    this.extent = extent;
  }

  /**
   * indicator about the type of the items in the collection if the collection has an accessible /collections/{collectionId}/items endpoint
   **/
  public Collection itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

  
  @ApiModelProperty(value = "indicator about the type of the items in the collection if the collection has an accessible /collections/{collectionId}/items endpoint")
  @JsonProperty("itemType")
  public String getItemType() {
    return itemType;
  }

  @JsonProperty("itemType")
  public void setItemType(String itemType) {
    this.itemType = itemType;
  }

  /**
   * the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system
   **/
  public Collection crs(List<String> crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system")
  @JsonProperty("crs")
  public List<String> getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(List<String> crs) {
    this.crs = crs;
  }

  public Collection addCrsItem(String crsItem) {
    if (this.crs == null) {
      this.crs = new ArrayList<>();
    }

    this.crs.add(crsItem);
    return this;
  }

  public Collection removeCrsItem(String crsItem) {
    if (crsItem != null && this.crs != null) {
      this.crs.remove(crsItem);
    }

    return this;
  }
  /**
   **/
  public Collection dataType(CollectionInfoDataType dataType) {
    this.dataType = dataType;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("dataType")
  public CollectionInfoDataType getDataType() {
    return dataType;
  }

  @JsonProperty("dataType")
  public void setDataType(CollectionInfoDataType dataType) {
    this.dataType = dataType;
  }

  /**
   * The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown
   * minimum: 0
   * maximum: 3
   **/
  public Collection geometryDimension(Integer geometryDimension) {
    this.geometryDimension = geometryDimension;
    return this;
  }

  
  @ApiModelProperty(value = "The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown")
  @JsonProperty("geometryDimension")
 @Min(0) @Max(3)  public Integer getGeometryDimension() {
    return geometryDimension;
  }

  @JsonProperty("geometryDimension")
  public void setGeometryDimension(Integer geometryDimension) {
    this.geometryDimension = geometryDimension;
  }

  /**
   * Minimum scale denominator for usage of the collection
   **/
  public Collection minScaleDenominator(BigDecimal minScaleDenominator) {
    this.minScaleDenominator = minScaleDenominator;
    return this;
  }

  
  @ApiModelProperty(value = "Minimum scale denominator for usage of the collection")
  @JsonProperty("minScaleDenominator")
  public BigDecimal getMinScaleDenominator() {
    return minScaleDenominator;
  }

  @JsonProperty("minScaleDenominator")
  public void setMinScaleDenominator(BigDecimal minScaleDenominator) {
    this.minScaleDenominator = minScaleDenominator;
  }

  /**
   * Maximum scale denominator for usage of the collection
   **/
  public Collection maxScaleDenominator(BigDecimal maxScaleDenominator) {
    this.maxScaleDenominator = maxScaleDenominator;
    return this;
  }

  
  @ApiModelProperty(value = "Maximum scale denominator for usage of the collection")
  @JsonProperty("maxScaleDenominator")
  public BigDecimal getMaxScaleDenominator() {
    return maxScaleDenominator;
  }

  @JsonProperty("maxScaleDenominator")
  public void setMaxScaleDenominator(BigDecimal maxScaleDenominator) {
    this.maxScaleDenominator = maxScaleDenominator;
  }

  /**
   * Minimum cell size for usage of the collection
   **/
  public Collection minCellSize(BigDecimal minCellSize) {
    this.minCellSize = minCellSize;
    return this;
  }

  
  @ApiModelProperty(value = "Minimum cell size for usage of the collection")
  @JsonProperty("minCellSize")
  public BigDecimal getMinCellSize() {
    return minCellSize;
  }

  @JsonProperty("minCellSize")
  public void setMinCellSize(BigDecimal minCellSize) {
    this.minCellSize = minCellSize;
  }

  /**
   * Maximum cell size for usage of the collection
   **/
  public Collection maxCellSize(BigDecimal maxCellSize) {
    this.maxCellSize = maxCellSize;
    return this;
  }

  
  @ApiModelProperty(value = "Maximum cell size for usage of the collection")
  @JsonProperty("maxCellSize")
  public BigDecimal getMaxCellSize() {
    return maxCellSize;
  }

  @JsonProperty("maxCellSize")
  public void setMaxCellSize(BigDecimal maxCellSize) {
    this.maxCellSize = maxCellSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Collection collection = (Collection) o;
    return Objects.equals(this.id, collection.id) &&
        Objects.equals(this.title, collection.title) &&
        Objects.equals(this.description, collection.description) &&
        Objects.equals(this.links, collection.links) &&
        Objects.equals(this.extent, collection.extent) &&
        Objects.equals(this.itemType, collection.itemType) &&
        Objects.equals(this.crs, collection.crs) &&
        Objects.equals(this.dataType, collection.dataType) &&
        Objects.equals(this.geometryDimension, collection.geometryDimension) &&
        Objects.equals(this.minScaleDenominator, collection.minScaleDenominator) &&
        Objects.equals(this.maxScaleDenominator, collection.maxScaleDenominator) &&
        Objects.equals(this.minCellSize, collection.minCellSize) &&
        Objects.equals(this.maxCellSize, collection.maxCellSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, description, links, extent, itemType, crs, dataType, geometryDimension, minScaleDenominator, maxScaleDenominator, minCellSize, maxCellSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Collection {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    extent: ").append(toIndentedString(extent)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    geometryDimension: ").append(toIndentedString(geometryDimension)).append("\n");
    sb.append("    minScaleDenominator: ").append(toIndentedString(minScaleDenominator)).append("\n");
    sb.append("    maxScaleDenominator: ").append(toIndentedString(maxScaleDenominator)).append("\n");
    sb.append("    minCellSize: ").append(toIndentedString(minCellSize)).append("\n");
    sb.append("    maxCellSize: ").append(toIndentedString(maxCellSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

