/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.tx.TxCommand;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class TxInfoCommandArg
extends TxCommand.AbstractTxCommandArg {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(example="<TX identifier as GridCacheVersion [topVer=..., order=..., nodeOrder=...] (can be found in logs)>|<TX identifier as UUID (can be retrieved via --tx command)>")
    private String value;
    private IgniteUuid uuid;
    private GridCacheVersion gridCacheVersion;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.value);
        U.writeIgniteUuid(out, this.uuid);
        out.writeObject(this.gridCacheVersion);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = U.readString(in);
        this.uuid = U.readIgniteUuid(in);
        this.gridCacheVersion = (GridCacheVersion)in.readObject();
    }

    public void uuid(IgniteUuid uuid) {
        this.uuid = uuid;
    }

    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
        try {
            this.uuid = IgniteUuid.fromString(value);
            return;
        }
        catch (RuntimeException runtimeException) {
            GridCacheVersion gcv = new GridCacheVersion(0, 0, 0L);
            String regexPtrn = gcv.toString().replaceAll("\\d+", "(\\\\d+)").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
            Pattern p = Pattern.compile(regexPtrn);
            Matcher m = p.matcher(value);
            if (!m.find()) {
                throw new IllegalArgumentException("Argument for tx --info should be either UUID or GridCacheVersion text representation: " + value);
            }
            assert (m.groupCount() == 4) : "Unexpected group count [cnt=" + m.groupCount() + ", pattern=" + regexPtrn + "]";
            try {
                this.gridCacheVersion = new GridCacheVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(3)), Long.parseLong(m.group(2)));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Argument for tx --info should be either UUID or GridCacheVersion text representation: " + value, e);
            }
            return;
        }
    }

    public GridCacheVersion gridCacheVersion() {
        return this.gridCacheVersion;
    }

    public void gridCacheVersion(GridCacheVersion gridCacheVer) {
        this.gridCacheVersion = gridCacheVer;
    }

    public IgniteUuid uuid() {
        return this.uuid;
    }
}

