/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.FSMCaller;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.closure.LoadSnapshotClosure;
import org.apache.ignite.raft.jraft.closure.SaveSnapshotClosure;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RaftException;
import org.apache.ignite.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite.raft.jraft.option.SnapshotExecutorOptions;
import org.apache.ignite.raft.jraft.rpc.InstallSnapshotResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.storage.LogManager;
import org.apache.ignite.raft.jraft.storage.SnapshotExecutor;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCountDownEvent;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.StringUtils;
import org.apache.ignite.raft.jraft.util.Utils;

public class SnapshotExecutorImpl
implements SnapshotExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotExecutorImpl.class);
    private final Lock lock = new ReentrantLock();
    private long lastSnapshotTerm;
    private long lastSnapshotIndex;
    private long term;
    private volatile boolean savingSnapshot;
    private volatile boolean loadingSnapshot;
    private volatile boolean stopped;
    private SnapshotStorage snapshotStorage;
    private SnapshotCopier curCopier;
    private FSMCaller fsmCaller;
    private NodeImpl node;
    private LogManager logManager;
    private final AtomicReference<DownloadingSnapshot> downloadingSnapshot = new AtomicReference<Object>(null);
    private RaftOutter.SnapshotMeta loadingSnapshotMeta;
    private final SnapshotCountDownEvent runningJobs = new SnapshotCountDownEvent();
    private RaftMessagesFactory msgFactory;

    @OnlyForTest
    public long getLastSnapshotTerm() {
        return this.lastSnapshotTerm;
    }

    @Override
    public long getLastSnapshotIndex() {
        return this.lastSnapshotIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(SnapshotExecutorOptions opts) {
        SnapshotReader reader;
        LocalSnapshotStorage tmp;
        if (StringUtils.isBlank(opts.getUri())) {
            LOG.error("Snapshot uri is empty [node={}].", new Object[]{this.node.getNodeId()});
            return false;
        }
        this.logManager = opts.getLogManager();
        this.fsmCaller = opts.getFsmCaller();
        this.node = opts.getNode();
        this.term = opts.getInitTerm();
        this.msgFactory = this.node.getRaftOptions().getRaftMessagesFactory();
        this.snapshotStorage = this.node.getServiceFactory().createSnapshotStorage(opts.getUri(), this.node.getRaftOptions());
        if (opts.isFilterBeforeCopyRemote()) {
            this.snapshotStorage.setFilterBeforeCopyRemote();
        }
        if (opts.getSnapshotThrottle() != null) {
            this.snapshotStorage.setSnapshotThrottle(opts.getSnapshotThrottle());
        }
        if (!this.snapshotStorage.init(null)) {
            LOG.error("Fail to init snapshot storage [node={}].", new Object[]{this.node.getNodeId()});
            return false;
        }
        if (this.snapshotStorage instanceof LocalSnapshotStorage && !(tmp = (LocalSnapshotStorage)this.snapshotStorage).hasServerPeerId()) {
            tmp.setServerPeerId(opts.getPeerId());
        }
        if ((reader = this.snapshotStorage.open()) == null) {
            return true;
        }
        this.loadingSnapshotMeta = reader.load();
        if (this.loadingSnapshotMeta == null) {
            LOG.error("Fail to load meta [node={}, metaProviderUri={}].", new Object[]{this.node.getNodeId(), opts.getUri()});
            Utils.closeQuietly(reader);
            return false;
        }
        LOG.info("Loading snapshot, [node={}, meta={}].", new Object[]{this.node.getNodeId(), this.loadingSnapshotMeta});
        this.loadingSnapshot = true;
        this.runningJobs.incrementAndGet(0);
        FirstSnapshotLoadDone done = new FirstSnapshotLoadDone(reader);
        Requires.requireTrue(this.fsmCaller.onSnapshotLoad(done));
        try {
            done.waitForRun();
        }
        catch (InterruptedException e) {
            LOG.warn("Wait for FirstSnapshotLoadDone run is interrupted [node={}].", new Object[]{this.node.getNodeId()});
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.closeQuietly(reader);
        }
        if (!done.status.isOk()) {
            LOG.error("Fail to load snapshot [node={}, snapshotProviderUri={}, firstSnapshotLoadDoneStatus={}].", new Object[]{this.node.getNodeId(), opts.getUri(), done.status});
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        long savedTerm;
        this.lock.lock();
        try {
            savedTerm = this.term;
            this.stopped = true;
        }
        finally {
            this.lock.unlock();
        }
        this.interruptDownloadingSnapshots(savedTerm);
    }

    @Override
    public NodeImpl getNode() {
        return this.node;
    }

    @Override
    public void doSnapshot(Closure done) {
        this.doSnapshot(done, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSnapshot(Closure done, boolean forced) {
        boolean doUnlock = true;
        this.lock.lock();
        try {
            if (this.stopped) {
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EPERM, "Is stopped.", new Object[0]));
                return;
            }
            if (this.downloadingSnapshot.get() != null) {
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EBUSY, "Is loading another snapshot.", new Object[0]));
                return;
            }
            if (this.savingSnapshot) {
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EBUSY, "Is saving another snapshot.", new Object[0]));
                return;
            }
            if (this.fsmCaller.getLastAppliedIndex() == this.lastSnapshotIndex) {
                doUnlock = false;
                this.lock.unlock();
                this.logManager.clearBufferedLogs();
                Status status = forced ? new Status(RaftError.EAGAIN, "No new logs since last snapshot.", new Object[0]) : Status.OK();
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, status);
                return;
            }
            long distance = this.fsmCaller.getLastAppliedIndex() - this.lastSnapshotIndex;
            if (!forced && distance < (long)this.node.getOptions().getSnapshotLogIndexMargin()) {
                if (this.node != null) {
                    LOG.debug("Node {} snapshotLogIndexMargin={}, distance={}, so ignore this time of snapshot by snapshotLogIndexMargin setting.", new Object[]{this.node.getNodeId(), distance, this.node.getOptions().getSnapshotLogIndexMargin()});
                }
                doUnlock = false;
                this.lock.unlock();
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done);
                return;
            }
            SnapshotWriter writer = this.snapshotStorage.create();
            if (writer == null) {
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EIO, "Fail to create writer.", new Object[0]));
                this.reportError(RaftError.EIO.getNumber(), "Fail to create snapshot writer.", new Object[0]);
                return;
            }
            this.savingSnapshot = true;
            SaveSnapshotDone saveSnapshotDone = new SaveSnapshotDone(writer, done, null, forced, this.node.getOptions().getCommonExecutor());
            if (!this.fsmCaller.onSnapshotSave(saveSnapshotDone)) {
                Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EHOSTDOWN, "The raft node is down.", new Object[0]));
                return;
            }
            this.runningJobs.incrementAndGet(1);
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int onSnapshotSaveDone(Status st, RaftOutter.SnapshotMeta meta, SnapshotWriter writer, boolean forced) {
        int ret;
        this.lock.lock();
        try {
            ret = st.getCode();
            if (st.isOk()) {
                if (meta.lastIncludedIndex() <= this.lastSnapshotIndex) {
                    ret = RaftError.ESTALE.getNumber();
                    if (this.node != null) {
                        LOG.warn("Node {} discards an stale snapshot lastIncludedIndex={}, lastSnapshotIndex={}.", new Object[]{this.node.getNodeId(), meta.lastIncludedIndex(), this.lastSnapshotIndex});
                    }
                    writer.setError(RaftError.ESTALE, "Installing snapshot is older than local snapshot", new Object[0]);
                }
            } else {
                LOG.error("Fail to save snapshot [node={}, status={}].", new Object[]{this.node.getNodeId(), st});
            }
        }
        finally {
            this.lock.unlock();
        }
        if (ret == 0) {
            if (!writer.saveMeta(meta)) {
                LOG.error("Fail to save snapshot [node={}, writerPath={}, writerErrorMessage={}].", new Object[]{this.node.getNodeId(), writer.getPath(), writer.getErrorMsg()});
                ret = RaftError.EIO.getNumber();
            }
        } else if (writer.isOk()) {
            writer.setError(ret, "Fail to do snapshot.", new Object[0]);
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.error("Fail to close writer [node={}].", new Object[]{this.node.getNodeId(), e});
            ret = RaftError.EIO.getNumber();
        }
        boolean doUnlock = true;
        this.lock.lock();
        try {
            if (ret == 0) {
                this.lastSnapshotIndex = meta.lastIncludedIndex();
                this.lastSnapshotTerm = meta.lastIncludedTerm();
                doUnlock = false;
                this.lock.unlock();
                this.logManager.setSnapshot(meta, forced);
                doUnlock = true;
                this.lock.lock();
            }
            if (ret == RaftError.EIO.getNumber()) {
                this.reportError(RaftError.EIO.getNumber(), "Fail to save snapshot.", new Object[0]);
            }
            this.savingSnapshot = false;
            this.runningJobs.countDown();
            int n = ret;
            return n;
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSnapshotLoadDone(Status st) {
        DownloadingSnapshot m;
        boolean doUnlock = true;
        this.lock.lock();
        try {
            Requires.requireTrue(this.loadingSnapshot, "Not loading snapshot");
            m = this.downloadingSnapshot.get();
            if (st.isOk()) {
                this.lastSnapshotIndex = this.loadingSnapshotMeta.lastIncludedIndex();
                this.lastSnapshotTerm = this.loadingSnapshotMeta.lastIncludedTerm();
                doUnlock = false;
                this.lock.unlock();
                this.logManager.setSnapshot(this.loadingSnapshotMeta, false);
                doUnlock = true;
                this.lock.lock();
            }
            StringBuilder sb = new StringBuilder();
            if (this.node != null) {
                sb.append("Node ").append(this.node.getNodeId()).append(" ");
            }
            sb.append("onSnapshotLoadDone, ").append(this.loadingSnapshotMeta);
            LOG.info(sb.toString(), new Object[0]);
            doUnlock = false;
            this.lock.unlock();
            if (this.node != null) {
                this.node.updateConfigurationAfterInstallingSnapshot();
            }
            doUnlock = true;
            this.lock.lock();
            this.loadingSnapshot = false;
            this.downloadingSnapshot.set(null);
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
        if (m != null) {
            if (!st.isOk()) {
                m.done.run(st);
            } else {
                m.responseBuilder.success(true);
                m.done.sendResponse(m.responseBuilder.build());
            }
        }
        this.runningJobs.countDown();
    }

    @Override
    public void installSnapshot(RpcRequests.InstallSnapshotRequest request, InstallSnapshotResponseBuilder response, RpcRequestClosure done) {
        RaftOutter.SnapshotMeta meta = request.meta();
        DownloadingSnapshot ds = new DownloadingSnapshot(request, response, done);
        if (!this.registerDownloadingSnapshot(ds)) {
            LOG.warn("Fail to register downloading snapshot [node={}].", new Object[]{this.node.getNodeId()});
            return;
        }
        Requires.requireNonNull(this.curCopier, "curCopier");
        try {
            this.curCopier.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Install snapshot copy job was canceled [node={}].", new Object[]{this.node.getNodeId()});
        }
        this.loadDownloadingSnapshot(ds, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDownloadingSnapshot(DownloadingSnapshot ds, RaftOutter.SnapshotMeta meta) {
        SnapshotReader reader;
        this.lock.lock();
        try {
            if (ds != this.downloadingSnapshot.get()) {
                return;
            }
            Requires.requireNonNull(this.curCopier, "curCopier");
            reader = this.curCopier.getReader();
            if (!this.curCopier.isOk()) {
                if (this.curCopier.getCode() == RaftError.EIO.getNumber()) {
                    this.reportError(this.curCopier.getCode(), this.curCopier.getErrorMsg(), new Object[0]);
                }
                Utils.closeQuietly(reader);
                ds.done.run(this.curCopier);
                Utils.closeQuietly(this.curCopier);
                this.curCopier = null;
                this.downloadingSnapshot.set(null);
                this.runningJobs.countDown();
                return;
            }
            Utils.closeQuietly(this.curCopier);
            this.curCopier = null;
            if (reader == null || !reader.isOk()) {
                Utils.closeQuietly(reader);
                this.downloadingSnapshot.set(null);
                ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EINTERNAL, "Fail to copy snapshot from %s", ds.request.uri()));
                this.runningJobs.countDown();
                return;
            }
            this.loadingSnapshot = true;
            this.loadingSnapshotMeta = meta;
        }
        finally {
            this.lock.unlock();
        }
        InstallSnapshotDone installSnapshotDone = new InstallSnapshotDone(reader);
        if (!this.fsmCaller.onSnapshotLoad(installSnapshotDone)) {
            LOG.warn("Fail to call fsm onSnapshotLoad [node={}].", new Object[]{this.node.getNodeId()});
            installSnapshotDone.run(new Status(RaftError.EHOSTDOWN, "This raft node is down", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerDownloadingSnapshot(DownloadingSnapshot ds) {
        boolean result;
        DownloadingSnapshot saved;
        block21: {
            saved = null;
            result = true;
            this.lock.lock();
            try {
                if (this.stopped) {
                    LOG.warn("Register DownloadingSnapshot failed: node is stopped [node={}].", new Object[]{this.node.getNodeId()});
                    ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EHOSTDOWN, "Node is stopped.", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                if (this.savingSnapshot) {
                    LOG.warn("Register DownloadingSnapshot failed: is saving snapshot [node={}].", new Object[]{this.node.getNodeId()});
                    ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EBUSY, "Node is saving snapshot.", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                ds.responseBuilder.term(this.term);
                if (ds.request.term() != this.term) {
                    LOG.warn("Register DownloadingSnapshot failed: term mismatch [node={}, expectTerm={}, gotTerm={}].", new Object[]{this.node.getNodeId(), this.term, ds.request.term()});
                    ds.responseBuilder.success(false);
                    ds.done.sendResponse(ds.responseBuilder.build());
                    boolean bl = false;
                    return bl;
                }
                if (ds.request.meta().lastIncludedIndex() <= this.lastSnapshotIndex) {
                    LOG.warn("Register DownloadingSnapshot failed: snapshot is not newer, request [node={}, lastIncludedIndex={}, lastSnapshotIndex={}].", new Object[]{this.node.getNodeId(), ds.request.meta().lastIncludedIndex(), this.lastSnapshotIndex});
                    ds.responseBuilder.success(true);
                    ds.done.sendResponse(ds.responseBuilder.build());
                    boolean bl = false;
                    return bl;
                }
                DownloadingSnapshot m = this.downloadingSnapshot.get();
                if (m == null) {
                    this.downloadingSnapshot.set(ds);
                    Requires.requireTrue(this.curCopier == null, "Current copier is not null");
                    this.curCopier = this.snapshotStorage.startToCopyFrom(ds.request.uri(), this.newCopierOpts());
                    if (this.curCopier == null) {
                        this.downloadingSnapshot.set(null);
                        LOG.warn("Register DownloadingSnapshot failed: fail to copy file [node={}. from={}].", new Object[]{this.node.getNodeId(), ds.request.uri()});
                        ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EINVAL, "Fail to copy from: %s", ds.request.uri()));
                        boolean bl = false;
                        return bl;
                    }
                    this.runningJobs.incrementAndGet(2);
                    boolean bl = true;
                    return bl;
                }
                if (m.request.meta().lastIncludedIndex() == ds.request.meta().lastIncludedIndex()) {
                    saved = m;
                    this.downloadingSnapshot.set(ds);
                    result = true;
                    break block21;
                }
                if (m.request.meta().lastIncludedIndex() > ds.request.meta().lastIncludedIndex()) {
                    LOG.warn("Register DownloadingSnapshot failed: is installing a newer one [node={}. lastIncludeIndex={}].", new Object[]{this.node.getNodeId(), m.request.meta().lastIncludedIndex()});
                    ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EINVAL, "A newer snapshot is under installing", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                if (this.loadingSnapshot) {
                    LOG.warn("Register DownloadingSnapshot failed: is loading an older snapshot [node={}, lastIncludeIndex={}].", new Object[]{this.node.getNodeId(), m.request.meta().lastIncludedIndex()});
                    ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EBUSY, "A former snapshot is under loading", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                Requires.requireNonNull(this.curCopier, "curCopier");
                this.curCopier.cancel();
                LOG.warn("Register DownloadingSnapshot failed: an older snapshot is under installing, cancel downloading,[node={}, lastIncludeIndex={}].", new Object[]{this.node.getNodeId(), m.request.meta().lastIncludedIndex()});
                ds.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EBUSY, "A former snapshot is under installing, trying to cancel", new Object[0]));
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (saved != null) {
            LOG.warn("Register DownloadingSnapshot failed: interrupted by retry installing request [node={}].", new Object[]{this.node.getNodeId()});
            saved.done.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.EINTR, "Interrupted by the retry InstallSnapshotRequest", new Object[0]));
        }
        return result;
    }

    private SnapshotCopierOptions newCopierOpts() {
        SnapshotCopierOptions copierOpts = new SnapshotCopierOptions();
        copierOpts.setNodeOptions(this.node.getOptions());
        copierOpts.setRaftClientService(this.node.getRpcClientService());
        copierOpts.setTimerManager(this.node.getOptions().getScheduler());
        copierOpts.setRaftOptions(this.node.getRaftOptions());
        return copierOpts;
    }

    @Override
    public void interruptDownloadingSnapshots(long newTerm) {
        this.lock.lock();
        try {
            Requires.requireTrue(newTerm >= this.term);
            this.term = newTerm;
            if (this.downloadingSnapshot.get() == null) {
                return;
            }
            if (this.loadingSnapshot) {
                return;
            }
            Requires.requireNonNull(this.curCopier, "curCopier");
            this.curCopier.cancel();
            LOG.info("Trying to cancel downloading snapshot [node={}, installSnapshotRequest={}].", new Object[]{this.node.getNodeId(), this.downloadingSnapshot.get().request});
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reportError(int errCode, String fmt, Object ... args) {
        RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT);
        error.setStatus(new Status(errCode, fmt, args));
        this.fsmCaller.onError(error);
    }

    @Override
    public boolean isInstallingSnapshot() {
        return this.downloadingSnapshot.get() != null;
    }

    @Override
    public SnapshotStorage getSnapshotStorage() {
        return this.snapshotStorage;
    }

    @Override
    public void join() throws InterruptedException {
        this.runningJobs.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(Describer.Printer out) {
        boolean _stopped;
        boolean _loadingSnapshot;
        boolean _savingSnapshot;
        long _term;
        long _lastSnapshotIndex;
        long _lastSnapshotTerm;
        this.lock.lock();
        try {
            _lastSnapshotTerm = this.lastSnapshotTerm;
            _lastSnapshotIndex = this.lastSnapshotIndex;
            _term = this.term;
            _savingSnapshot = this.savingSnapshot;
            _loadingSnapshot = this.loadingSnapshot;
            _stopped = this.stopped;
        }
        finally {
            this.lock.unlock();
        }
        out.print("  lastSnapshotTerm: ").println(_lastSnapshotTerm);
        out.print("  lastSnapshotIndex: ").println(_lastSnapshotIndex);
        out.print("  term: ").println(_term);
        out.print("  savingSnapshot: ").println(_savingSnapshot);
        out.print("  loadingSnapshot: ").println(_loadingSnapshot);
        out.print("  stopped: ").println(_stopped);
    }

    private class FirstSnapshotLoadDone
    implements LoadSnapshotClosure {
        SnapshotReader reader;
        CountDownLatch eventLatch;
        Status status;

        FirstSnapshotLoadDone(SnapshotReader reader) {
            this.reader = reader;
            this.eventLatch = new CountDownLatch(1);
        }

        @Override
        public void run(Status status) {
            this.status = status;
            SnapshotExecutorImpl.this.onSnapshotLoadDone(this.status);
            this.eventLatch.countDown();
        }

        public void waitForRun() throws InterruptedException {
            this.eventLatch.await();
        }

        @Override
        public SnapshotReader start() {
            return this.reader;
        }
    }

    private class SaveSnapshotDone
    implements SaveSnapshotClosure {
        SnapshotWriter writer;
        Closure done;
        boolean forced;
        RaftOutter.SnapshotMeta meta;
        Executor executor;

        SaveSnapshotDone(SnapshotWriter writer, Closure done, RaftOutter.SnapshotMeta meta, boolean forced, Executor executor) {
            this.writer = writer;
            this.done = done;
            this.meta = meta;
            this.forced = forced;
            this.executor = executor;
        }

        @Override
        public void run(Status status) {
            Utils.runInThread(this.executor, () -> this.continueRun(status));
        }

        void continueRun(Status st) {
            int ret = SnapshotExecutorImpl.this.onSnapshotSaveDone(st, this.meta, this.writer, this.forced);
            if (ret != 0 && st.isOk()) {
                st.setError(ret, "node call onSnapshotSaveDone failed", new Object[0]);
            }
            if (this.done != null) {
                Utils.runClosureInExecutor(this.executor, this.done, st);
            }
        }

        @Override
        public SnapshotWriter start(RaftOutter.SnapshotMeta meta) {
            this.meta = meta;
            return this.writer;
        }
    }

    static class DownloadingSnapshot {
        RpcRequests.InstallSnapshotRequest request;
        InstallSnapshotResponseBuilder responseBuilder;
        RpcRequestClosure done;

        DownloadingSnapshot(RpcRequests.InstallSnapshotRequest request, InstallSnapshotResponseBuilder responseBuilder, RpcRequestClosure done) {
            this.request = request;
            this.responseBuilder = responseBuilder;
            this.done = done;
        }
    }

    private class InstallSnapshotDone
    implements LoadSnapshotClosure {
        SnapshotReader reader;

        InstallSnapshotDone(SnapshotReader reader) {
            this.reader = reader;
        }

        @Override
        public void run(Status status) {
            SnapshotExecutorImpl.this.onSnapshotLoadDone(status);
        }

        @Override
        public SnapshotReader start() {
            return this.reader;
        }
    }
}

