/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.ErrorGroups;

public class TransactionInternalCheckedException
extends IgniteInternalCheckedException {
    public TransactionInternalCheckedException(int code) {
        super(UUID.randomUUID(), code);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code) {
        super(traceId, code);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(int code, String message) {
        super(code, message);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code, String message) {
        super(traceId, code, message);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroups.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(int code, Throwable cause) {
        super(code, cause);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroups.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(UUID traceId, int code, Throwable cause) {
        super(traceId, code, cause);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroups.errorGroupByCode((int)code).name() + "]";
    }

    public TransactionInternalCheckedException(int code, String message, Throwable cause) {
        super(code, message, cause);
        assert (ErrorGroups.extractGroupCode((int)code) == ErrorGroups.Transactions.TX_ERR_GROUP.groupCode()) : "Error code does not relate to transaction error group [code=" + code + ", errGroup=" + ErrorGroups.errorGroupByCode((int)code).name() + "]";
    }
}

