/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Internal
@BootstrapContextCompatible
public class DefaultEventLoopGroupRegistry
implements EventLoopGroupRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventLoopGroupRegistry.class);
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final BeanLocator beanLocator;
    private final Map<EventLoopGroup, EventLoopGroupConfiguration> eventLoopGroups = new ConcurrentHashMap<EventLoopGroup, EventLoopGroupConfiguration>();

    public DefaultEventLoopGroupRegistry(EventLoopGroupFactory eventLoopGroupFactory, BeanLocator beanLocator) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.beanLocator = beanLocator;
    }

    @PreDestroy
    void shutdown() {
        this.eventLoopGroups.forEach((eventLoopGroup, configuration) -> {
            block2: {
                try {
                    long quietPeriod = configuration.getShutdownQuietPeriod().toMillis();
                    long timeout = configuration.getShutdownTimeout().toMillis();
                    eventLoopGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) break block2;
                    LOG.warn("Error shutting down EventLoopGroup: {}", (Object)t.getMessage(), (Object)t);
                }
            }
        });
        this.eventLoopGroups.clear();
    }

    @EachBean(value=EventLoopGroupConfiguration.class)
    @Bean
    @BootstrapContextCompatible
    protected EventLoopGroup eventLoopGroup(EventLoopGroupConfiguration configuration) {
        EventLoopGroup eventLoopGroup;
        String executor = configuration.getExecutorName().orElse(null);
        if (executor != null) {
            eventLoopGroup = this.beanLocator.findBean(Executor.class, Qualifiers.byName((String)executor)).map(executorService -> this.eventLoopGroupFactory.createEventLoopGroup(configuration.getNumThreads(), (Executor)executorService, (Integer)configuration.getIoRatio().orElse(null))).orElseThrow(() -> new ConfigurationException("No executor service configured for name: " + executor));
        } else {
            ThreadFactory threadFactory = this.beanLocator.findBean(ThreadFactory.class, Qualifiers.byName((String)configuration.getName())).orElseGet(() -> new DefaultThreadFactory(configuration.getName() + "-" + DefaultThreadFactory.toPoolName(NioEventLoopGroup.class)));
            eventLoopGroup = this.eventLoopGroupFactory.createEventLoopGroup(configuration, threadFactory);
        }
        this.eventLoopGroups.put(eventLoopGroup, configuration);
        return eventLoopGroup;
    }

    @Singleton
    @Requires(missingProperty="micronaut.netty.event-loops.default")
    @Primary
    @BootstrapContextCompatible
    @Bean(typed={EventLoopGroup.class})
    protected EventLoopGroup defaultEventLoopGroup(@Named(value="netty") ThreadFactory threadFactory) {
        DefaultEventLoopGroupConfiguration configuration = new DefaultEventLoopGroupConfiguration();
        EventLoopGroup eventLoopGroup = this.eventLoopGroupFactory.createEventLoopGroup(configuration, threadFactory);
        this.eventLoopGroups.put(eventLoopGroup, configuration);
        return eventLoopGroup;
    }

    @Override
    @NonNull
    public EventLoopGroup getDefaultEventLoopGroup() {
        return (EventLoopGroup)this.beanLocator.getBean(EventLoopGroup.class);
    }

    @Override
    public Optional<EventLoopGroup> getEventLoopGroup(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        if ("default".equals(name)) {
            return this.beanLocator.findBean(EventLoopGroup.class);
        }
        return this.beanLocator.findBean(EventLoopGroup.class, Qualifiers.byName((String)name));
    }

    @Override
    public Optional<EventLoopGroupConfiguration> getEventLoopGroupConfiguration(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.beanLocator.findBean(EventLoopGroupConfiguration.class, Qualifiers.byName((String)name));
    }
}

