/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rule.ImmutableSortConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.immutables.value.Value;

@Value.Enclosing
public class SortConverterRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    protected SortConverterRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelOptCluster cluster = sort.getCluster();
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)sort.getCollation()).replace((RelTrait)IgniteDistributions.single());
        if (sort.collation == RelCollations.EMPTY || sort.fetch == null && sort.offset != null) {
            call.transformTo((RelNode)new IgniteLimit(cluster, traits, SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)traits), sort.offset, sort.fetch));
            return;
        }
        call.transformTo((RelNode)new IgniteSort(cluster, traits, SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)traits.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortConverterRule.Config.of().withOperandSupplier(b -> b.operand(LogicalSort.class).anyInputs());

        default public SortConverterRule toRule() {
            return new SortConverterRule(this);
        }
    }
}

