/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.HashMap;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionDependencyResolver;
import org.apache.ignite.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSourceProvider;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;

public class ExecutionDependencyResolverImpl
implements ExecutionDependencyResolver {
    private final ExecutableTableRegistry registry;
    private final ScannableDataSourceProvider dataSourceProvider;

    public ExecutionDependencyResolverImpl(ExecutableTableRegistry registry, ScannableDataSourceProvider dataSourceProvider) {
        this.registry = registry;
        this.dataSourceProvider = dataSourceProvider;
    }

    @Override
    public ResolvedDependencies resolveDependencies(Iterable<IgniteRel> rels, final int catalogVersion) {
        final HashMap<Integer, ExecutableTable> tableMap = new HashMap<Integer, ExecutableTable>();
        final HashMap<Integer, ScannableDataSource> dataSources = new HashMap<Integer, ScannableDataSource>();
        IgniteRelShuttle shuttle = new IgniteRelShuttle(){

            @Override
            public IgniteRel visit(IgniteSender rel) {
                IgniteDistribution distribution = TraitUtils.distribution((RelNode)rel);
                this.resolveDistributionFunction(distribution);
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteTrimExchange rel) {
                IgniteDistribution distribution = TraitUtils.distribution((RelNode)rel);
                this.resolveDistributionFunction(distribution);
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableModify rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteIndexScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteTableScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.resolveTable(catalogVersion, igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteSystemViewScan rel) {
                IgniteSystemView view = (IgniteSystemView)rel.getTable().unwrap(IgniteSystemView.class);
                assert (view != null);
                dataSources.put(view.id(), ExecutionDependencyResolverImpl.this.dataSourceProvider.forSystemView(view));
                return rel;
            }

            private void resolveDistributionFunction(IgniteDistribution distribution) {
                DistributionFunction function = distribution.function();
                if (function.affinity()) {
                    int tableId = ((DistributionFunction.AffinityDistribution)function).tableId();
                    this.resolveTable(catalogVersion, tableId);
                }
            }

            private void resolveTable(int catalogVersion2, int tableId) {
                tableMap.computeIfAbsent(tableId, id -> ExecutionDependencyResolverImpl.this.registry.getTable(catalogVersion2, tableId));
            }
        };
        for (IgniteRel rel : rels) {
            shuttle.visit(rel);
        }
        return new ResolvedDependencies(tableMap, dataSources);
    }
}

