/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage.serialization;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.storage.AlterColumnEntry;
import org.apache.ignite.internal.catalog.storage.AlterZoneEntry;
import org.apache.ignite.internal.catalog.storage.DropColumnsEntry;
import org.apache.ignite.internal.catalog.storage.DropIndexEntry;
import org.apache.ignite.internal.catalog.storage.DropSchemaEntry;
import org.apache.ignite.internal.catalog.storage.DropTableEntry;
import org.apache.ignite.internal.catalog.storage.DropZoneEntry;
import org.apache.ignite.internal.catalog.storage.MakeIndexAvailableEntry;
import org.apache.ignite.internal.catalog.storage.NewColumnsEntry;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.NewSchemaEntry;
import org.apache.ignite.internal.catalog.storage.NewSystemViewEntry;
import org.apache.ignite.internal.catalog.storage.NewTableEntry;
import org.apache.ignite.internal.catalog.storage.NewZoneEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.RenameIndexEntry;
import org.apache.ignite.internal.catalog.storage.RenameTableEntry;
import org.apache.ignite.internal.catalog.storage.SetDefaultZoneEntry;
import org.apache.ignite.internal.catalog.storage.SnapshotEntry;
import org.apache.ignite.internal.catalog.storage.StartBuildingIndexEntry;
import org.apache.ignite.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;

public interface CatalogEntrySerializerProvider {
    public static final CatalogEntrySerializerProvider DEFAULT_PROVIDER = new CatalogEntrySerializerProvider(){
        private final CatalogObjectSerializer<? extends MarshallableEntry>[] serializers = new CatalogObjectSerializer[MarshallableEntryType.values().length];
        {
            this.serializers[MarshallableEntryType.ALTER_COLUMN.id()] = AlterColumnEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.ALTER_ZONE.id()] = AlterZoneEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_ZONE.id()] = NewZoneEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.DROP_COLUMN.id()] = DropColumnsEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.DROP_INDEX.id()] = DropIndexEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.DROP_TABLE.id()] = DropTableEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.DROP_ZONE.id()] = DropZoneEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.MAKE_INDEX_AVAILABLE.id()] = MakeIndexAvailableEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.REMOVE_INDEX.id()] = RemoveIndexEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.START_BUILDING_INDEX.id()] = StartBuildingIndexEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_COLUMN.id()] = NewColumnsEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_INDEX.id()] = NewIndexEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_SYS_VIEW.id()] = NewSystemViewEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_TABLE.id()] = NewTableEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.RENAME_TABLE.id()] = RenameTableEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.ID_GENERATOR.id()] = ObjectIdGenUpdateEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.SNAPSHOT.id()] = SnapshotEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.RENAME_INDEX.id()] = RenameIndexEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.SET_DEFAULT_ZONE.id()] = SetDefaultZoneEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.NEW_SCHEMA.id()] = NewSchemaEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.DROP_SCHEMA.id()] = DropSchemaEntry.SERIALIZER;
            this.serializers[MarshallableEntryType.VERSIONED_UPDATE.id()] = new VersionedUpdate.VersionedUpdateSerializer(this);
            assert (Stream.of(this.serializers).noneMatch(Objects::isNull));
        }

        @Override
        public CatalogObjectSerializer<MarshallableEntry> get(int typeId) {
            if (typeId < 0 || typeId > this.serializers.length) {
                throw new IllegalArgumentException("Unknown type ID: " + typeId);
            }
            return this.serializers[typeId];
        }
    };

    public CatalogObjectSerializer<MarshallableEntry> get(int var1);
}

