/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.StartBuildingIndexEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class StartBuildingIndexEntry
extends AbstractChangeIndexStatusEntry
implements Fireable {
    public static final CatalogObjectSerializer<StartBuildingIndexEntry> SERIALIZER = new StartBuildingIndexEntrySerializer();

    public StartBuildingIndexEntry(int indexId) {
        super(indexId, CatalogIndexStatus.BUILDING);
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_BUILDING;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new StartBuildingIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.START_BUILDING_INDEX.id();
    }

    private static class StartBuildingIndexEntrySerializer
    implements CatalogObjectSerializer<StartBuildingIndexEntry> {
        private StartBuildingIndexEntrySerializer() {
        }

        @Override
        public StartBuildingIndexEntry readFrom(IgniteDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new StartBuildingIndexEntry(indexId);
        }

        @Override
        public void writeTo(StartBuildingIndexEntry object, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)object.indexId);
        }
    }
}

